/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.osgi;

import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.vim.binding.pbm.version.version1;
import com.vmware.vim.binding.vim.version.internal.version10;
import com.vmware.vim.binding.vmodl.compatible;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmodlContextInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmodlContextInitializer.class);
    private static final String CORE_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl";
    private static final String QUERY_VMODL_PACKAGE = "com.vmware.vim.binding.vmodl.query";
    private static final Executor EXEC;
    private final AtomicBoolean _initialized = new AtomicBoolean(false);
    private final ConcurrentMap<String, FutureTask<Void>> _taskByPackage = new ConcurrentHashMap<String, FutureTask<Void>>();
    private final DAG _packageGraph;
    private final VmodlContext _vmodlContext;
    private final String _targetPackage;
    private final CountDownLatch _completed = new CountDownLatch(1);
    private final AtomicReference<Throwable> _firstError = new AtomicReference<Object>(null);
    private final Class<? extends Annotation> _version;

    private static boolean isInCoreVmodlPackage(Class<?> version) {
        String pkg = VmodlContextInitializer.getPackageFor(version);
        return pkg.equals(CORE_VMODL_PACKAGE) || pkg.equals(QUERY_VMODL_PACKAGE);
    }

    private static String getPackageFor(Class<?> version) {
        String packageName = version.getPackage().getName();
        return packageName.replace(".internal", "").replace(".version", "");
    }

    private static void addVersion(Class<?> version, DAG graph, Set<Class<?>> processedVersions) throws CycleDetectedException {
        if (!processedVersions.add(version)) {
            return;
        }
        String pkg = VmodlContextInitializer.getPackageFor(version);
        graph.addVertex(pkg);
        compatible compat = version.getAnnotation(compatible.class);
        if (compat == null) {
            return;
        }
        Class[] parentVersions = compat.value();
        if (version == version1.class) {
            HashSet<Class<version10>> parentSet = new HashSet<Class<version10>>();
            parentSet.addAll(Arrays.asList(parentVersions));
            parentSet.add(version10.class);
            parentVersions = new Class[parentVersions.length + 1];
            parentSet.toArray(parentVersions);
        }
        for (Class parent : parentVersions) {
            if (VmodlContextInitializer.isInCoreVmodlPackage(parent)) continue;
            VmodlContextInitializer.addVersion(parent, graph, processedVersions);
            String parentPkg = VmodlContextInitializer.getPackageFor(parent);
            if (pkg.equals(parentPkg) || graph.hasEdge(parentPkg, pkg)) continue;
            graph.addEdge(parentPkg, pkg);
        }
    }

    private static DAG buildVersionsGraph(Class<?> version) throws CycleDetectedException {
        DAG dag = new DAG();
        VmodlContextInitializer.addVersion(version, dag, new HashSet());
        return dag;
    }

    public VmodlContextInitializer(VmodlContext vmodlContext, Class<? extends Annotation> version) throws VmodlContextInitException {
        if (version == null) {
            throw new IllegalArgumentException("versionToLoad");
        }
        try {
            this._packageGraph = VmodlContextInitializer.buildVersionsGraph(version);
        }
        catch (CycleDetectedException e) {
            throw new VmodlContextInitException(e);
        }
        this._targetPackage = VmodlContextInitializer.getPackageFor(version);
        this._vmodlContext = vmodlContext;
        this._version = version;
    }

    public Class<? extends Annotation> getVersionClass() {
        return this._version;
    }

    public void load() {
        if (this._initialized.compareAndSet(false, true)) {
            for (String pkg : this._packageGraph.getLabels()) {
                List parents = this._packageGraph.getParentLabels(pkg);
                if (!parents.isEmpty()) continue;
                this.startLoadTask(pkg);
            }
        }
    }

    public void waitToComplete() throws VmodlContextInitException, InterruptedException {
        this.load();
        this._completed.await();
        Throwable t = this._firstError.get();
        if (t != null) {
            throw new VmodlContextInitException(t);
        }
    }

    public VmodlContext getVmodlContext() {
        return this._vmodlContext;
    }

    private boolean startLoadTask(final String pkg) {
        if (this.isComplete()) {
            return false;
        }
        FutureTask<Void> task = new FutureTask<Void>((Callable)new LoaderTask(pkg)){

            @Override
            protected void set(Void v) {
                super.set(v);
                VmodlContextInitializer.this.packageLoaded(pkg);
            }

            @Override
            protected void setException(Throwable t) {
                super.setException(t);
                VmodlContextInitializer.this.packageLoadFailed(t);
            }

            @Override
            public boolean cancel(boolean interrupt) {
                if (super.cancel(interrupt)) {
                    VmodlContextInitializer.this.packageLoadFailed(new CancellationException());
                    return true;
                }
                return false;
            }
        };
        if (this._taskByPackage.putIfAbsent(pkg, task) == null) {
            try {
                EXEC.execute(task);
                return true;
            }
            catch (RejectedExecutionException ree) {
                this.packageLoadFailed(ree);
                throw ree;
            }
        }
        return false;
    }

    private void packageLoaded(String pkg) {
        List dependentPackages = this._packageGraph.getChildLabels(pkg);
        boolean startedTask = false;
        for (String dp : dependentPackages) {
            if (!this.areAllParentPackagesReady(dp)) continue;
            startedTask |= this.startLoadTask(dp);
        }
        if (!startedTask && this.isComplete()) {
            this._completed.countDown();
        }
    }

    private void packageLoadFailed(Throwable t) {
        if (this._firstError.compareAndSet(null, t)) {
            this._completed.countDown();
        }
    }

    private boolean isComplete() {
        if (this._completed.getCount() == 0L) {
            return true;
        }
        return this.isPackageLoaded(this._targetPackage);
    }

    private boolean areAllParentPackagesReady(String pkg) {
        List parentPackages = this._packageGraph.getParentLabels(pkg);
        for (String parent : parentPackages) {
            if (this.isPackageLoaded(parent)) continue;
            return false;
        }
        return true;
    }

    private boolean isPackageLoaded(String pkg) {
        Future task = (Future)this._taskByPackage.get(pkg);
        return task != null && task.isDone();
    }

    static {
        final ThreadPoolExecutor exec = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new Utils.ThreadFactoryImpl("srm-vmodl-context-thread"));
        exec.allowCoreThreadTimeOut(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                exec.shutdown();
            }
        });
        EXEC = exec;
    }

    public static class VmodlContextInitException
    extends RuntimeException {
        VmodlContextInitException(Throwable cause) {
            super(cause.getLocalizedMessage(), cause);
        }
    }

    private class LoaderTask
    implements Callable<Void> {
        private final String _package;

        public LoaderTask(String pkg) {
            this._package = pkg;
        }

        @Override
        public Void call() throws Exception {
            LOGGER.debug("Loading vmodl package '{}'.", (Object)this._package);
            try {
                VmodlContextInitializer.this._vmodlContext.loadVmodlPackages(new String[]{this._package}, false);
                LOGGER.debug("Vmodl package '{}' loaded.", (Object)this._package);
            }
            catch (VmodlAlreadyLoadedException alExc) {
                LOGGER.debug("Vmodl package '{}' already loaded.", (Object)this._package);
            }
            catch (Exception exc) {
                LOGGER.error("Vmodl package '{}' failed to load.", (Object)this._package, (Object)exc);
                throw exc;
            }
            return null;
        }
    }
}

