/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.version;

import com.vmware.srm.client.topology.impl.vmomi.hms.HmsServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.osgi.VmodlContextInitializer;
import com.vmware.srm.client.topology.impl.vmomi.srm.SrmServiceImpl;
import com.vmware.srm.client.topology.impl.vmomi.vc.VcServiceImpl;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class VersionUtils {
    private static final String VC_VERSION_PKG = "com.vmware.vim.binding.vim.version";
    private static final String SRM_VERSION_PKG = "com.vmware.vim.binding.dr.version";
    private static final String HMS_VERSION_PKG = "com.vmware.vim.binding.hms.version";

    private static VmodlVersionMap getVcSupportedVersions() {
        VmodlContextInitializer vcLoader = VcServiceImpl.VMODL_INIT;
        try {
            vcLoader.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return vcLoader.getVmodlContext().getVmodlVersionMap();
    }

    private static VmodlVersionMap getSrmSupportedVersions() {
        VmodlContextInitializer srmLoader = SrmServiceImpl.VMODL_INIT;
        try {
            srmLoader.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return srmLoader.getVmodlContext().getVmodlVersionMap();
    }

    private static VmodlVersionMap getHmsSupportedVersions() {
        VmodlContextInitializer hmsLoader = HmsServiceImpl.VMODL_INIT;
        try {
            hmsLoader.waitToComplete();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return hmsLoader.getVmodlContext().getVmodlVersionMap();
    }

    public static VmodlVersion getPublicVersion(VmodlVersion version) {
        Validate.notNull((Object)version, (String)"version");
        if (!version.isInternal()) {
            return version;
        }
        String publicVersionName = version.getVersionClass().getName().replace(".internal", "");
        for (VmodlVersion vv : version.getParentVersion()) {
            if (!vv.getVersionClass().getName().equals(publicVersionName)) continue;
            return vv;
        }
        throw new RuntimeException("No public version for '" + String.valueOf(version) + "' with parents '" + String.valueOf(version.getParentVersion()) + "'");
    }

    public static boolean isCompatible(VmodlVersion v1, VmodlVersion v2) {
        Validate.notNull((Object)v1, (String)"v1 version");
        Validate.notNull((Object)v2, (String)"v2 version");
        v2 = v2.isInternal() ? VersionUtils.getPublicVersion(v2) : v2;
        return v1.isCompatible(v2);
    }

    public static VmodlVersion getVmodlVersion(Class<? extends Annotation> versionClass, VmodlVersionMap supportedVersions) {
        Validate.notNull(versionClass, (String)"versionClass");
        Validate.notNull((Object)supportedVersions, (String)"supportedVersions");
        VmodlVersion version = supportedVersions.getVersion(versionClass);
        if (version == null) {
            throw new RuntimeException("Unsupported version '" + String.valueOf(versionClass) + "'");
        }
        return VersionUtils.getPublicVersion(version);
    }

    public static VmodlVersion getVcVmodlVersion(Class<? extends Annotation> vcVersionClass) {
        Validate.notNull(vcVersionClass, (String)"vcVersionClass");
        if (!vcVersionClass.getName().startsWith(VC_VERSION_PKG)) {
            throw new IllegalArgumentException("Invalid VC vmodl version class " + String.valueOf(vcVersionClass));
        }
        return VersionUtils.getVmodlVersion(vcVersionClass, VersionUtils.getVcSupportedVersions());
    }

    public static VmodlVersion getSrmVmodlVersion(Class<? extends Annotation> srmVersionClass) {
        Validate.notNull(srmVersionClass, (String)"srmVersionClass");
        if (!srmVersionClass.getName().startsWith(SRM_VERSION_PKG)) {
            throw new IllegalArgumentException("Invalid SRM vmodl version class " + String.valueOf(srmVersionClass));
        }
        return VersionUtils.getVmodlVersion(srmVersionClass, VersionUtils.getSrmSupportedVersions());
    }

    public static VmodlVersion getHmsVmodlVersion(Class<? extends Annotation> hmsVersionClass) {
        Validate.notNull(hmsVersionClass, (String)"hmsVersionClass");
        if (!hmsVersionClass.getName().startsWith(HMS_VERSION_PKG)) {
            throw new IllegalArgumentException("Invalid HMS vmodl version class " + String.valueOf(hmsVersionClass));
        }
        return VersionUtils.getVmodlVersion(hmsVersionClass, VersionUtils.getHmsSupportedVersions());
    }

    public static List<VmodlVersion> getSupportedVersionsChain(Class<? extends Annotation> fromVersionClass, Class<? extends Annotation> toVersionClass, VmodlVersionMap versionsMap) {
        ArrayList<VmodlVersion> chain;
        VmodlVersion toVersion;
        VmodlVersion fromVersion = VersionUtils.getVmodlVersion(fromVersionClass, versionsMap);
        if (VersionUtils.tryBuildVersionsChain(fromVersion, toVersion = VersionUtils.getVmodlVersion(toVersionClass, versionsMap), chain = new ArrayList<VmodlVersion>())) {
            return chain;
        }
        throw new RuntimeException("No supported version chain from '" + String.valueOf(fromVersion) + "' to '" + String.valueOf(toVersion) + "' found.");
    }

    private static boolean tryBuildVersionsChain(VmodlVersion fromVersion, VmodlVersion toVersion, List<VmodlVersion> chain) {
        chain.add(fromVersion);
        if (fromVersion.equals((Object)toVersion)) {
            return true;
        }
        for (VmodlVersion parent : fromVersion.getParentVersion()) {
            if (!VersionUtils.tryBuildVersionsChain(parent, toVersion, chain)) continue;
            return true;
        }
        chain.remove(chain.size() - 1);
        return false;
    }
}

