/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.srm.client.infrastructure.utils.L10N;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collection;
import java.util.function.Function;

public interface PcResult {
    public Collection<ManagedObjectReference> getMoRefs();

    public Exception getErrorForGuid(String var1);

    public <T> T getProperty(ManagedObjectReference var1, String var2) throws PcResultException;

    default public <T> T tryGetProperty(ManagedObjectReference moRef, String propName, Function<Throwable, RuntimeException> errorHandler) {
        try {
            return this.getProperty(moRef, propName);
        }
        catch (PcResultException e) {
            RuntimeException error = errorHandler.apply(e.getCause());
            if (error == null) {
                return null;
            }
            throw error;
        }
    }

    default public <T> T tryGetProperty(ManagedObjectReference moRef, String propName) {
        return this.tryGetProperty(moRef, propName, e -> null);
    }

    public static class PcResultException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final ManagedObjectReference moRef;

        public PcResultException(ManagedObjectReference moRef, Throwable cause) {
            super(L10N.localize("retrievedPropertiesFailForMoRefErrorMessage", moRef.toString()), cause);
            this.moRef = moRef;
        }

        public PcResultException(ManagedObjectReference moRef, String property, Throwable cause) {
            super(L10N.localize("missingPropertyForMoRefErrorMessage", property, moRef), cause);
            this.moRef = moRef;
        }
    }

    public static class UnknownPropertyException
    extends RuntimeException {
        public final ManagedObjectReference moRef;
        public final String property;

        public UnknownPropertyException(ManagedObjectReference moRef, String property) {
            super(L10N.localize("unknownPropertyErrorMessage", property, moRef));
            this.moRef = moRef;
            this.property = property;
        }
    }
}

