/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websockets.requesthandlers.lookup;

import com.vmware.dr.ui.tools.utilities.CachingProducer;
import com.vmware.dr.ui.tools.utilities.HashUtils;
import com.vmware.dr.ui.tools.utilities.StringUtils;
import com.vmware.srm.client.infrastructure.websockets.requesthandlers.DrWsRequestHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrWsHandlerLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrWsHandlerLookup.class);
    private static final String WS_HANDLERS_PROPS = "websockethandlers.properties";
    private static final DrWsHandlerLookup INSTANCE = new DrWsHandlerLookup();
    private final CacheImpl _cache;

    public static DrWsHandlerLookup get() {
        return INSTANCE;
    }

    private DrWsHandlerLookup() {
        Properties props = new Properties();
        ClassLoader cl = DrWsHandlerLookup.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(WS_HANDLERS_PROPS);){
            Validate.notNull((Object)is, (String)"Unable to load resource 'websockethandlers.properties'.");
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet<Key> keys = new HashSet<Key>();
        for (String path : props.stringPropertyNames()) {
            Class<?> clazz;
            String className = props.getProperty(path);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("ws handler class cannot be loaded: ", (Throwable)e);
                continue;
            }
            keys.add(new Key(path, clazz));
        }
        this._cache = new CacheImpl(keys);
    }

    public DrWsRequestHandler<?, ?> lookup(String path) {
        try {
            return (DrWsRequestHandler)this._cache.get(new Key(path));
        }
        catch (Exception e) {
            LOGGER.error("Unable to get request handler", (Throwable)e);
            return null;
        }
    }

    private static final class Key {
        final String path;
        final Class<? extends DrWsRequestHandler<?, ?>> handlerClass;
        private Integer _hash;

        Key(String path) {
            this(path, null);
        }

        Key(String path, Class<? extends DrWsRequestHandler<?, ?>> handlerClass) {
            this.path = path;
            this.handlerClass = handlerClass;
        }

        public int hashCode() {
            if (this._hash == null) {
                this._hash = HashUtils.getHashCode((Object[])new Object[]{this.path});
            }
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return HashUtils.areEqual((Object)this.path, (Object)other.path);
        }

        public String toString() {
            HashMap<String, String> members = new HashMap<String, String>();
            members.put("path", this.path);
            return StringUtils.getToStringValue((String)"WsHandlerLookup.Key", members);
        }
    }

    private static final class CacheImpl
    extends CachingProducer<Key, DrWsRequestHandler<?, ?>> {
        CacheImpl(Set<Key> keys) {
            super(keys);
        }

        protected DrWsRequestHandler<?, ?> produce(Key key) throws Exception {
            return key.handlerClass.newInstance();
        }
    }
}

