/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.websso;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.utilities.Exceptions;
import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.srm.client.infrastructure.http.io.HttpResponseController;
import com.vmware.srm.client.infrastructure.websso.IDPConfigParser;
import com.vmware.srm.client.infrastructure.websso.LsppUtils;
import com.vmware.srm.client.infrastructure.websso.XmlUtils;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IDPConfigRetriever {
    private final LsppService _ssoReg;
    private final IDPConfigParser _parser = new IDPConfigParser();

    IDPConfigRetriever(LsppService ssoReg) {
        Validate.notNull((Object)LsppUtils.getEndpoint(ssoReg, LsppUtils.WEBSSO));
        this._ssoReg = ssoReg;
    }

    public Promise<IDPConfiguration> retrieve() throws GeneralSecurityException, IOException {
        LsppServiceEndpoint se = LsppUtils.getEndpoint(this._ssoReg, LsppUtils.WEBSSO);
        if (se == null) {
            throw new IllegalArgumentException("No WebSSO endpoint in: " + String.valueOf(this._ssoReg));
        }
        KeyStore store = CertificateUtils.createTrustStore((Collection)se.getCertificates());
        SslTrust.TrustData td = SslTrust.get((KeyStore)store);
        return HttpResponseController.doGet(se.url, (KeyStore)td.second(), (ThumbprintVerifier)td.first()).thenApply(httpResponse -> {
            InputStream input;
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                throw new RuntimeException("No http entity in response from " + String.valueOf(se.url));
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            try {
                Document doc = this.parse(input);
                IDPConfiguration iDPConfiguration = this._parser.create(doc);
                return iDPConfiguration;
            }
            catch (Exception e) {
                throw Exceptions.getRuntimeException((Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    private Document parse(InputStream idpStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder docBuilder = XmlUtils.createBuiler();
        return docBuilder.parse(idpStream);
    }
}

