/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheClientHeadersProvider;
import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.ConnectionMonitor;
import com.vmware.vapi.internal.protocol.client.rpc.http.HttpClientProxyConfigurationHelper;
import com.vmware.vapi.internal.protocol.client.rpc.http.SslClientUtil;
import com.vmware.vapi.internal.protocol.client.rpc.http.adapter.NioHttpClientBuilderAdapter;
import com.vmware.vapi.internal.util.DefaultThreadFactory;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.HttpConfiguration;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheNioHttpClientBuilder {
    private PoolingNHttpClientConnectionManager connManager;
    private static Logger logger = LoggerFactory.getLogger(ApacheNioHttpClientBuilder.class);
    private ConnectionMonitor.CleanableConnectionPool pool;
    private RequestConfig defaultRequestConfig;

    public RequestConfig getDefaultRequestConfig() {
        return this.defaultRequestConfig;
    }

    public CloseableHttpAsyncClient buildAndConfigure(final HttpConfiguration httpConfig) throws SecurityException {
        Validate.notNull(httpConfig);
        this.defaultRequestConfig = ApacheHttpUtil.createDefaultRequestConfig(httpConfig);
        try {
            HttpConfiguration.ProxyConfiguration proxyConfig;
            this.connManager = this.createConnectionManager(httpConfig);
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)this.connManager).setUserAgent(ApacheHttpUtil.VAPI_USER_AGENT).setThreadFactory((ThreadFactory)new DefaultThreadFactory("vAPI-I/O reactor-")).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    return httpConfig.getKeepAlivePeriod();
                }
            });
            HttpConfiguration.HeadersProvider headersProvider = httpConfig.getHeadersProvider();
            if (headersProvider != null) {
                builder.addInterceptorFirst((HttpRequestInterceptor)new ApacheClientHeadersProvider(headersProvider));
            }
            if ((proxyConfig = httpConfig.getProxyConfiguration()) != null) {
                HttpClientProxyConfigurationHelper.addProxyConfiguration(proxyConfig, new NioHttpClientBuilderAdapter(builder));
            }
            CloseableHttpAsyncClient client = builder.build();
            client.start();
            return client;
        }
        catch (IOReactorException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ConnectionMonitor.CleanableConnectionPool registerClientWithConnectionMonitor() {
        if (this.connManager == null) {
            throw new IllegalStateException();
        }
        if (this.pool == null) {
            this.pool = new ConnectionMonitor.CleanableConnectionPool(){

                @Override
                public void closeExpiredConnections() {
                    ApacheNioHttpClientBuilder.this.connManager.closeExpiredConnections();
                }

                @Override
                public int leasedConnections() {
                    return ApacheNioHttpClientBuilder.this.connManager.getTotalStats().getLeased();
                }
            };
            ConnectionMonitor.register(this.pool);
        } else {
            logger.warn("Unable to register client more than once!");
        }
        return this.pool;
    }

    private PoolingNHttpClientConnectionManager createConnectionManager(HttpConfiguration config) throws IOReactorException {
        ConnectingIOReactor ioreactor = this.createConnectionIOReactor(config);
        Registry<SchemeIOSessionStrategy> schemeRegistry = this.createAsyncSchemeRegistry(config.getSslConfiguration());
        PoolingNHttpClientConnectionManager cm = new PoolingNHttpClientConnectionManager(ioreactor, schemeRegistry);
        cm.setMaxTotal(config.getMaxConnections());
        cm.setDefaultMaxPerRoute(config.getMaxConnections());
        return cm;
    }

    private ConnectingIOReactor createConnectionIOReactor(HttpConfiguration config) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoThreadCount()).setSoTimeout(config.getSoTimeout()).setConnectTimeout(config.getConnectTimeout()).build();
        return new DefaultConnectingIOReactor(ioReactorConfig, (ThreadFactory)new DefaultThreadFactory("vAPI-I/O dispatcher-"));
    }

    Registry<SchemeIOSessionStrategy> createAsyncSchemeRegistry(HttpConfiguration.SslConfiguration sslConfig) {
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE);
        if (sslConfig != HttpConfiguration.SslConfiguration.SKIP_SSL_INITIALIZATION) {
            X509HostnameVerifier hostnameVerifier = SslClientUtil.createHostnameVerifier(sslConfig.isHostnameVerificationDisabled(), SSLIOSessionStrategy.STRICT_HOSTNAME_VERIFIER);
            SSLContext context = SslClientUtil.createSslContext(sslConfig);
            String[] protocols = SslClientUtil.getProtocols(context, sslConfig);
            registryBuilder.register("https", (Object)new SSLIOSessionStrategy(context, protocols, sslConfig.getEnabledCipherSuites(), hostnameVerifier));
        }
        return registryBuilder.build();
    }
}

