/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioResponseHandlingStrategy;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.InputStreamBinaryInput;
import com.vmware.vapi.internal.util.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BioFramedResponseHandlingStrategy
implements BioResponseHandlingStrategy {
    private final int maxFrameSize;

    public BioFramedResponseHandlingStrategy(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleContent(InputStream content, CorrelatingClient.ResponseCallback cb, AbortHandle abortHandle, String uri) throws IOException {
        try {
            byte[] frame;
            ChunkedTransferEncodingFrameDeserializer frameDeserializer = new ChunkedTransferEncodingFrameDeserializer(this.maxFrameSize);
            InputStreamBinaryInput input = new InputStreamBinaryInput(content);
            while ((frame = frameDeserializer.readFrame(input)) != null) {
                cb.received(new ByteArrayInputStream(frame), CorrelatingClient.NO_OP_CONTROL);
            }
        }
        finally {
            IoUtil.silentClose(content);
        }
    }
}

