/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.http.handle.BioResponseHandlingStrategy;
import com.vmware.vapi.internal.protocol.common.Util;
import com.vmware.vapi.internal.protocol.common.http.ApacheHttpClientExceptionTranslator;
import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.InputStreamBinaryInput;
import com.vmware.vapi.internal.util.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioStreamingResponseHandlingStrategy
implements BioResponseHandlingStrategy {
    private static Logger logger = LoggerFactory.getLogger(BioStreamingResponseHandlingStrategy.class);
    private final int maxFrameSize;

    public BioStreamingResponseHandlingStrategy(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    @Override
    public void handleContent(InputStream content, CorrelatingClient.ResponseCallback cb, AbortHandle abortHandle, String uri) throws IOException {
        ControllableTransport transport = new ControllableTransport(content, cb, abortHandle, uri);
        Util.registerStreamingAbortListerner(transport, abortHandle);
        if (Util.checkRequestAborted(abortHandle, cb)) {
            transport.cancel();
            return;
        }
        transport.resumeRead();
    }

    public class ControllableTransport
    implements CorrelatingClient.TransportControl {
        private final FrameDeserializer frameDeserializer;
        private InputStream is;
        private CorrelatingClient.ResponseCallback cb;
        private AbortHandle abortHandle;
        private String uri;
        private BinaryInput input;
        private volatile boolean readSuspended;
        private volatile boolean aborted;
        private ReentrantLock lock;

        public ControllableTransport(InputStream is, CorrelatingClient.ResponseCallback cb, AbortHandle abortHandle, String uri) {
            this.frameDeserializer = new ChunkedTransferEncodingFrameDeserializer(BioStreamingResponseHandlingStrategy.this.maxFrameSize);
            this.readSuspended = false;
            this.aborted = false;
            this.is = is;
            this.cb = cb;
            this.abortHandle = abortHandle;
            this.uri = uri;
            this.input = new InputStreamBinaryInput(is);
            this.lock = new ReentrantLock();
        }

        protected void finalize() throws Throwable {
            IoUtil.silentClose(this.is);
            super.finalize();
        }

        @Override
        public void suspendRead() {
            this.readSuspended = true;
        }

        @Override
        public void resumeRead() {
            if (this.lock.isHeldByCurrentThread()) {
                this.readSuspended = false;
                logger.trace("The same thread is already reading frames.");
                return;
            }
            this.lock.lock();
            this.readSuspended = false;
            byte[] frame = null;
            try {
                while (!this.readSuspended && !this.aborted) {
                    logger.trace("Reading frames.");
                    frame = this.frameDeserializer.readFrame(this.input);
                    if (frame == null || frame.length == 0) {
                        logger.trace("Finished reading.");
                        break;
                    }
                    this.cb.received(new ByteArrayInputStream(frame), this);
                }
                if ((frame == null || frame.length == 0) && !this.readSuspended || this.aborted) {
                    IoUtil.silentClose(this.is);
                    this.is = null;
                    this.cb.completed();
                }
            }
            catch (Exception ex) {
                logger.debug("Error during reading frames.", (Throwable)ex);
                this.cb.failed(ApacheHttpClientExceptionTranslator.translate(ex, this.abortHandle, this.uri));
                IoUtil.silentClose(this.is);
                this.is = null;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void cancel() {
            logger.debug("Cancelling the streaming frame desirialization.");
            this.aborted = true;
            if (this.lock.tryLock()) {
                IoUtil.silentClose(this.is);
                this.is = null;
                this.lock.unlock();
            }
        }
    }
}

