/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import com.vmware.vapi.internal.protocol.client.rpc.http.handle.CappedInputBuffer;
import java.io.IOException;
import java.nio.BufferOverflowException;
import org.apache.http.ContentTooLongException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;

public class CappedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private static final int DEFAULT_INIT_BUFF_SIZE = 4096;
    private static final int MAX_INIT_BUFF_SIZE = 262144;
    private volatile HttpResponse response;
    protected volatile CappedInputBuffer buf;
    private final int maxTotalBuffSize;

    public CappedAsyncResponseConsumer(int maxBuffSize) {
        if (maxBuffSize <= 0) {
            throw new IllegalArgumentException("maxBuffSize must be a positive number");
        }
        this.maxTotalBuffSize = maxBuffSize;
    }

    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > (long)this.maxTotalBuffSize) {
            throw new ContentTooLongException("Entity content is too long: %d. Max allowed is: %d", new Object[]{len, this.maxTotalBuffSize});
        }
        int initBuffSize = 0;
        initBuffSize = len > 0L ? Math.min(262144, (int)len) : Math.min(4096, this.maxTotalBuffSize);
        this.buf = new CappedInputBuffer(this.maxTotalBuffSize, initBuffSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.response.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.buf));
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioControl) throws IOException {
        Asserts.notNull((Object)((Object)this.buf), (String)"Content buffer");
        try {
            this.buf.consumeContent(decoder);
        }
        catch (BufferOverflowException ex) {
            throw new IOException("Cannot consume response. Buffer overflow");
        }
    }

    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

