/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtil {
    private static final Logger logger = LoggerFactory.getLogger(IoUtil.class);
    private static final int MAX_COPY_BUFFER_SIZE = 1024;

    private IoUtil() {
    }

    public static void copy(InputStream src, OutputStream dst) throws IOException {
        IoUtil.copy(src, dst, Integer.MAX_VALUE);
    }

    public static void copy(InputStream src, OutputStream dst, int maxBytes) throws IOException {
        int len;
        int size = Math.min(maxBytes, 1024);
        byte[] buffer = new byte[size];
        int totalRead = 0;
        while ((len = src.read(buffer)) >= 0) {
            if ((totalRead += len) > maxBytes) {
                throw new IOException(String.format("Max of %d bytes to copy exceeded", maxBytes));
            }
            dst.write(buffer, 0, len);
        }
    }

    public static byte[] readAll(InputStream inp) throws IOException {
        return IoUtil.readAll(inp, Integer.MAX_VALUE);
    }

    public static byte[] readAll(InputStream inp, int maxBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.copy(inp, out, maxBytes);
        return out.toByteArray();
    }

    public static void silentClose(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception ex) {
            logger.debug("Error while closing resource", (Throwable)ex);
        }
    }
}

