/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.l10n;

import com.vmware.vapi.l10n.ResourceBundleProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Java8Utf8BundleProvider
implements ResourceBundleProvider {
    private String baseName;
    private final ResourceBundle.Control utfControl;

    public Java8Utf8BundleProvider(String baseName) {
        Objects.requireNonNull(baseName);
        this.baseName = baseName;
        this.utfControl = new Utf8Control();
    }

    @Override
    public ResourceBundle getResourceBundle(String msgId, Locale locale) {
        return ResourceBundle.getBundle(this.baseName, locale, this.utfControl);
    }

    public static class Utf8Control
    extends ResourceBundle.Control {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (!format.equals("java.properties")) {
                return super.newBundle(baseName, locale, format, loader, reload);
            }
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

