/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import com.vmware.vapi.internal.protocol.server.rpc.http.impl.BasicLifecycleManager;
import com.vmware.vapi.protocol.server.rpc.http.Endpoint;
import com.vmware.vapi.protocol.server.rpc.http.Filter;
import com.vmware.vapi.protocol.server.rpc.http.LifecycleListener;
import com.vmware.vapi.protocol.server.rpc.http.LifecycleManager;
import com.vmware.vapi.protocol.server.rpc.http.Server;
import com.vmware.vapi.protocol.server.rpc.http.ServerConfigurator;
import com.vmware.vapi.protocol.server.rpc.http.Service;
import com.vmware.vapi.protocol.server.rpc.http.StaticContentService;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpEndpoint;
import com.vmware.vapi.protocol.server.rpc.http.impl.StaticContentServiceImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements Server,
LifecycleManager {
    protected static final Logger _logger = LoggerFactory.getLogger(AbstractServer.class);
    protected static final Service[] NO_SERVICES = new Service[0];
    protected static final Filter[] NO_FILTERS = new Filter[0];
    public static final int DEFAULT_PORT = 8080;
    protected Endpoint[] _endpoints = new Endpoint[]{new HttpEndpoint(8080)};
    protected Service[] _services = NO_SERVICES;
    protected Filter[] _filters = NO_FILTERS;
    protected final LifecycleManager _lifecycleManager = new BasicLifecycleManager();
    protected ServerConfigurator _serverConfig;
    private String[] _enabledCiphers;

    protected abstract Service prepareDefaultServlet(StaticContentService var1);

    @Override
    public void setEndpoints(Endpoint[] endpoints) {
        AbstractServer.validateArray(endpoints);
        this._endpoints = endpoints;
    }

    @Override
    public void setServices(Service[] services) {
        AbstractServer.validateArray(services);
        this._services = services;
        this.prepareStaticContentServices();
    }

    @Override
    public void setFilters(Filter[] filters) {
        AbstractServer.validateArray(filters);
        this._filters = filters;
    }

    @Override
    public void setServerConfigurator(ServerConfigurator serverConfig) {
        this._serverConfig = serverConfig;
    }

    protected static void validateArray(Object[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("Empty array element at index " + i);
        }
    }

    protected void prepareStaticContentServices() {
        for (int i = 0; i < this._services.length; ++i) {
            if (!(this._services[i] instanceof StaticContentServiceImpl)) continue;
            StaticContentService staticSrv = (StaticContentService)this._services[i];
            if (staticSrv.getContentBase() == null) {
                throw new IllegalArgumentException("contentBase must not be null for service " + staticSrv);
            }
            this._services[i] = this.prepareDefaultServlet(staticSrv);
        }
    }

    protected void applyServerConfigurator() {
        if (this._serverConfig != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Applying server configurator " + this._serverConfig + " to server " + this);
            }
            this._serverConfig.configure(this);
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this._lifecycleManager.addLifecycleListener(lifecycleListener);
    }

    @Override
    public void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        this._lifecycleManager.setLifecycleListeners(lifecycleListeners);
    }

    @Override
    public void shutdown() {
        this._lifecycleManager.shutdown();
    }

    @Override
    public void shutdownNow() {
        this._lifecycleManager.shutdownNow();
    }

    public void setEnabledSSLCiphers(String[] enabledCiphers) {
        if (enabledCiphers == null || enabledCiphers.length == 0) {
            throw new NullPointerException("Can not specify empty list");
        }
        this._enabledCiphers = enabledCiphers;
    }

    protected String[] getDisabledSSLCiphers() {
        if (this._enabledCiphers == null) {
            return null;
        }
        SSLSocketFactory sslf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslf.getDefaultCipherSuites()));
        ciphers.removeAll(Arrays.asList(this._enabledCiphers));
        return ciphers.toArray(new String[ciphers.size()]);
    }

    protected String[] getEnabledSSLCiphers() {
        if (this._enabledCiphers == null) {
            return null;
        }
        SSLSocketFactory sslf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslf.getDefaultCipherSuites()));
        ciphers.retainAll(Arrays.asList(this._enabledCiphers));
        return ciphers.toArray(new String[ciphers.size()]);
    }
}

