/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.rpc.http.impl;

import com.vmware.vapi.internal.protocol.server.rpc.http.util.FileUtil;
import com.vmware.vapi.internal.protocol.server.rpc.http.util.StringUtil;
import com.vmware.vapi.protocol.server.rpc.http.Endpoint;
import com.vmware.vapi.protocol.server.rpc.http.Filter;
import com.vmware.vapi.protocol.server.rpc.http.InternalException;
import com.vmware.vapi.protocol.server.rpc.http.Service;
import com.vmware.vapi.protocol.server.rpc.http.StaticContentService;
import com.vmware.vapi.protocol.server.rpc.http.impl.AbstractServer;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpEndpoint;
import com.vmware.vapi.protocol.server.rpc.http.impl.HttpsEndpoint;
import com.vmware.vapi.protocol.server.rpc.http.impl.ServiceImpl;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.HttpConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcServer
extends AbstractServer {
    private static final Logger _logger = LoggerFactory.getLogger(TcServer.class);
    public static final String CONN_HOST = "address";
    public static final String CONN_NUM_ACCEPTORS = "acceptorThreadCount";
    public static final String CONN_ACCEPT_QUEUE_SIZE = "acceptCount";
    public static final String CONN_MAX_IDLE_TIME = "connectionTimeout";
    public static final String CONN_SSL_ENABLED = "SSLEnabled";
    public static final String CONN_KEYSTORE_TYPE = "keystoreType";
    public static final String CONN_KEYSTORE_FILE = "keystoreFile";
    public static final String CONN_KEYSTORE_PASS = "keystorePass";
    public static final String CONN_KEYSTORE_PROVIDER = "keystoreProvider";
    public static final String CONN_KEY_PASS = "keyPass";
    public static final String CONN_TRUSTSTORE_TYPE = "truststoreType";
    public static final String CONN_TRUSTSTORE_FILE = "truststoreFile";
    public static final String CONN_TRUSTSTORE_PASS = "truststorePass";
    public static final String CONN_TRUSTSTORE_PROVIDER = "truststoreProvider";
    public static final String CONN_CLIENT_AUTH = "clientAuth";
    public static final String CONN_ALGORITHM = "algorithm";
    public static final String CONN_CIPHERS = "ciphers";
    public static final String CONN_SSL_IMPLEMENTATION = "sslImplementationName";
    public static final String CONN_ENABLED_PROTOCOLS = "sslEnabledProtocols";
    public static final String SERVER = "server";
    public static final String ASYNC_TIMEOUT_KEY = "asyncTimeout";
    private static final long ASYNC_TIMEOUT_NOT_SET = -1000L;
    private Tomcat _server;
    private Context _context;
    private String _staticContentBasePath;
    private org.apache.catalina.Executor _threadPool;
    private long _asyncTimeout = -1000L;

    public void setThreadPool(org.apache.catalina.Executor threadPool) {
        this._threadPool = threadPool;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this._asyncTimeout = asyncTimeout;
    }

    void prepareToStart() throws Exception {
        this._server = new Tomcat();
        if (this._threadPool != null) {
            this._server.getService().addExecutor(this._threadPool);
        }
        this.createHandler();
        this.createConnectors();
        StandardServer server = (StandardServer)this._server.getServer();
        AprLifecycleListener listener = new AprLifecycleListener();
        listener.setSSLEngine("on");
        server.addLifecycleListener((LifecycleListener)listener);
        this.applyServerConfigurator();
        if (_logger.isInfoEnabled()) {
            _logger.info("Starting server on " + Arrays.toString(this._endpoints));
        }
    }

    @Override
    public void start() throws Exception {
        this.prepareToStart();
        this._server.start();
    }

    private void createConnectors() {
        for (int i = 0; i < this._endpoints.length; ++i) {
            Connector connector = null;
            if (this._endpoints[i].getProtocol() == Endpoint.Protocol.HTTP) {
                connector = this.createHttpConnector((HttpEndpoint)this._endpoints[i]);
                connector.setScheme("http");
            } else {
                connector = this.createHttpsConnector((HttpsEndpoint)this._endpoints[i]);
                connector.setScheme("https");
            }
            connector.setProperty(CONN_HOST, this._endpoints[i].getHost());
            connector.setPort(this._endpoints[i].getPort());
            connector.setAttribute(CONN_NUM_ACCEPTORS, (Object)this._endpoints[i].getNumAcceptors());
            connector.setAttribute(CONN_ACCEPT_QUEUE_SIZE, (Object)this._endpoints[i].getAcceptQueueSize());
            connector.setAttribute(CONN_MAX_IDLE_TIME, (Object)this._endpoints[i].getMaxIdleTime());
            connector.setAttribute(SERVER, (Object)"Apache");
            if (this._threadPool != null) {
                ProtocolHandler pHandler = connector.getProtocolHandler();
                if (pHandler instanceof AbstractProtocol) {
                    ((AbstractProtocol)pHandler).setExecutor((Executor)this._threadPool);
                } else {
                    _logger.warn("Cannot inject custom Executor to the connector. A default Executor will be used");
                }
            }
            this._server.getService().addConnector(connector);
            if (i != 0) continue;
            this._server.setConnector(connector);
        }
    }

    private Connector createHttpConnector(HttpEndpoint endpoint) {
        switch (endpoint.getEndpointType()) {
            case NON_BLOCKING_NIO: {
                return new Connector(Http11NioProtocol.class.getName());
            }
            case BLOCKING: {
                return new Connector();
            }
        }
        throw new IllegalArgumentException("Unknown Endpoint type: " + (Object)((Object)endpoint.getEndpointType()));
    }

    private Connector createHttpsConnector(HttpsEndpoint endpoint) {
        Connector connector = null;
        switch (endpoint.getEndpointType()) {
            case NON_BLOCKING_NIO: {
                connector = new Connector(Http11NioProtocol.class.getName());
                this.configureSslConnector(connector, endpoint);
                return connector;
            }
            case BLOCKING: {
                connector = new Connector(Http11Protocol.class.getName());
                this.configureSslConnector(connector, endpoint);
                return connector;
            }
        }
        throw new IllegalArgumentException("Unknown Endpoint type: " + (Object)((Object)endpoint.getEndpointType()));
    }

    private void configureSslConnector(Connector connector, HttpsEndpoint endpoint) {
        String protocols;
        connector.setSecure(true);
        connector.setProperty(CONN_SSL_ENABLED, "true");
        connector.setProperty(CONN_SSL_IMPLEMENTATION, JSSEImplementation.class.getName());
        if (endpoint.getKeyStoreType() != null) {
            connector.setProperty(CONN_KEYSTORE_TYPE, endpoint.getKeyStoreType());
        }
        if (endpoint.getKeyStorePath() != null) {
            connector.setAttribute(CONN_KEYSTORE_FILE, (Object)FileUtil.getAbsoluteFilename(endpoint.getKeyStorePath()));
        }
        if (endpoint.getKeyStorePassword() != null) {
            connector.setAttribute(CONN_KEYSTORE_PASS, (Object)endpoint.getKeyStorePassword());
        }
        if (endpoint.getKeyPassword() != null) {
            connector.setAttribute(CONN_KEY_PASS, (Object)endpoint.getKeyPassword());
        }
        if (endpoint.getTrustStorePath() != null) {
            connector.setAttribute(CONN_TRUSTSTORE_FILE, (Object)FileUtil.getAbsoluteFilename(endpoint.getTrustStorePath()));
        }
        if (endpoint.getTrustStorePassword() != null) {
            connector.setAttribute(CONN_TRUSTSTORE_PASS, (Object)endpoint.getTrustStorePassword());
        }
        if (endpoint.getTrustStorePath() == null && endpoint.getTrustStorePassword() == null) {
            connector.setProperty(CONN_TRUSTSTORE_FILE, (String)connector.getProperty(CONN_KEYSTORE_FILE));
            connector.setProperty(CONN_TRUSTSTORE_PASS, (String)connector.getProperty(CONN_KEYSTORE_PASS));
            connector.setProperty(CONN_TRUSTSTORE_TYPE, (String)connector.getProperty(CONN_KEYSTORE_TYPE));
        }
        if (endpoint.getNeedClientAuth()) {
            connector.setAttribute(CONN_CLIENT_AUTH, (Object)"true");
        } else if (endpoint.getWantClientAuth()) {
            connector.setAttribute(CONN_CLIENT_AUTH, (Object)"want");
        } else {
            connector.setAttribute(CONN_CLIENT_AUTH, (Object)"false");
        }
        Object[] cipherSuites = this.getEnabledSSLCiphers();
        if (cipherSuites != null) {
            connector.setProperty(CONN_CIPHERS, StringUtil.join(cipherSuites, ","));
        }
        if ((protocols = endpoint.getEnabledProtocols()) != null) {
            connector.setProperty(CONN_ENABLED_PROTOCOLS, protocols);
        }
    }

    private void createHandler() throws ServletException {
        String baseDir = null;
        baseDir = this._staticContentBasePath != null ? this._staticContentBasePath : new File(".").getAbsolutePath();
        this._context = this._server.addContext("/", baseDir);
        this.registerMimeMappings();
        this._context.setParentClassLoader(this.getClass().getClassLoader());
        if (this._services.length == 0) {
            throw new IllegalStateException("There are no services configured");
        }
        this.addServices();
        this.addFilters();
    }

    private void registerMimeMappings() {
        try {
            String[] mimeMappings;
            Context dummyContext = this._server.addContext("/dummyContext", ".");
            Tomcat.initWebappDefaults((Context)dummyContext);
            for (String mimeMapping : mimeMappings = dummyContext.findMimeMappings()) {
                this._context.addMimeMapping(mimeMapping, dummyContext.findMimeMapping(mimeMapping));
            }
            dummyContext.stop();
            dummyContext.destroy();
        }
        catch (LifecycleException e) {
            _logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addServices() {
        int servletNo = 0;
        for (Service srv : this._services) {
            SecurityConstraint[] securityConstraints;
            String servletName = "servlet " + servletNo++;
            Wrapper holder = Tomcat.addServlet((Context)this._context, (String)servletName, (Servlet)srv.getServlet());
            if (this._asyncTimeout != -1000L) {
                holder.addInitParameter(ASYNC_TIMEOUT_KEY, String.valueOf(this._asyncTimeout));
            }
            if (srv.getInitParameters() != null) {
                for (Map.Entry<String, String> initParam : srv.getInitParameters().entrySet()) {
                    holder.addInitParameter(initParam.getKey(), initParam.getValue());
                }
            }
            String path = srv.getPath();
            this._context.addServletMapping(path, servletName);
            if (path.indexOf(42) < 0 && !path.endsWith("/")) {
                String trailingSlashPath = path + "/";
                this._context.addServletMapping(trailingSlashPath, servletName);
            }
            holder.setAsyncSupported(true);
            HttpConstraintElement dc = new HttpConstraintElement(TcServer.resolveDataConstraint(srv.getTransportGuarantee()), new String[0]);
            for (SecurityConstraint securityConstraint : securityConstraints = SecurityConstraint.createConstraints((ServletSecurityElement)new ServletSecurityElement(dc), (String)path)) {
                this._context.addConstraint(securityConstraint);
            }
            holder.setLoadOnStartup(0);
        }
    }

    private void addFilters() {
        int filterNo = 0;
        for (Filter flt : this._filters) {
            FilterDef filterDef = new FilterDef();
            String filterName = "filter " + filterNo++;
            filterDef.setFilterName(filterName);
            filterDef.setFilter(flt.getFilter());
            if (flt.getInitParameters() != null) {
                for (Map.Entry<String, String> entry : flt.getInitParameters().entrySet()) {
                    filterDef.addInitParameter(entry.getKey(), entry.getValue());
                }
            }
            this._context.addFilterDef(filterDef);
            FilterMap filterMap = new FilterMap();
            filterMap.setFilterName(filterName);
            filterMap.addURLPattern(flt.getPath());
            for (Filter.Dispatcher t : flt.getDispatchers()) {
                filterMap.setDispatcher(t.name());
            }
            this._context.addFilterMap(filterMap);
        }
    }

    private static ServletSecurity.TransportGuarantee resolveDataConstraint(Service.TransportGuarantee tg) {
        switch (tg) {
            case NONE: {
                return ServletSecurity.TransportGuarantee.NONE;
            }
            case INTEGRAL: {
                return ServletSecurity.TransportGuarantee.CONFIDENTIAL;
            }
            case CONFIDENTIAL: {
                return ServletSecurity.TransportGuarantee.CONFIDENTIAL;
            }
        }
        throw new InternalException("Unknown transport guarantee " + (Object)((Object)tg));
    }

    @Override
    public void stop() throws Exception {
        this.shutdown();
        if (_logger.isInfoEnabled()) {
            _logger.info("Stopping server.");
        }
        if (this._server.getServer() != null && this._server.getServer().getState() != LifecycleState.DESTROYED) {
            if (this._server.getServer().getState() != LifecycleState.STOPPED) {
                this._server.getServer().stop();
            }
            this._server.getServer().destroy();
        }
    }

    @Override
    public void join() throws Exception {
        this._server.getServer().await();
    }

    public Tomcat getServer() {
        return this._server;
    }

    public Context getContext() {
        return this._context;
    }

    @Override
    protected Service prepareDefaultServlet(StaticContentService staticSrv) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        File staticContentBase = new File(staticSrv.getContentBasePath());
        this._staticContentBasePath = staticContentBase.getAbsolutePath();
        initParams.put("listings", String.valueOf(staticSrv.getDirListing()));
        ServiceImpl converted = new ServiceImpl();
        converted.setServlet((Servlet)new DefaultServlet());
        converted.setInitParameters(initParams);
        converted.setPath(staticSrv.getPath());
        converted.setTransportGuarantee(staticSrv.getTransportGuarantee());
        return converted;
    }
}

