/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std.introspection;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.errors.StructDefinitions;
import com.vmware.vapi.std.introspection.ServiceDefinitions;
import com.vmware.vapi.std.introspection.ServiceSyncProvider;
import java.util.Arrays;

public class ServiceSyncApiInterface
extends ApiInterfaceSkeleton {
    private ServiceSyncProvider impl;

    public ServiceSyncApiInterface() {
        this((Class<? extends ServiceSyncProvider>)null);
    }

    public ServiceSyncApiInterface(Class<? extends ServiceSyncProvider> implClass) {
        this(ServiceSyncApiInterface.createImplInstance(implClass, "com.vmware.vapi.std.introspection.impl.ServiceImpl", ServiceSyncProvider.class));
    }

    public ServiceSyncApiInterface(ServiceSyncProvider impl) {
        this(impl, TypeConverterImpl.getInstance());
    }

    public ServiceSyncApiInterface(ServiceSyncProvider impl, TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.service", converter);
        Validate.notNull(impl);
        this.impl = impl;
        this.registerMethod(new ListApiMethod());
        this.registerMethod(new GetApiMethod());
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(ServiceSyncApiInterface.this.getIdentifier(), "get", ServiceDefinitions.__getInput, ServiceDefinitions.__getOutput, ServiceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                @Override
                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, ServiceDefinitions.__getInput, ServiceSyncApiInterface.this.getTypeConverter());
            String id = (String)extr.valueForField("id");
            try {
                asyncHandle.setResult(MethodResult.newResult(ServiceSyncApiInterface.this.getTypeConverter().convertToVapi(ServiceSyncApiInterface.this.impl.get(id, invocationContext), ServiceDefinitions.__getOutput, new TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult(MethodResult.newErrorResult(this.toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(ServiceSyncApiInterface.this.getIdentifier(), "list", ServiceDefinitions.__listInput, ServiceDefinitions.__listOutput, ServiceSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        @Override
        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult(MethodResult.newResult(ServiceSyncApiInterface.this.getTypeConverter().convertToVapi(ServiceSyncApiInterface.this.impl.list(invocationContext), ServiceDefinitions.__listOutput, new TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult(MethodResult.newErrorResult(this.toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }
}

