/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.tracing;

import com.vmware.vapi.internal.tracing.otel.OtelTracer;
import com.vmware.vapi.tracing.Tracer;
import com.vmware.vapi.tracing.TracingLevel;
import io.opentelemetry.api.OpenTelemetry;
import java.util.Objects;

public class OpenTelemetryTracerBuilder {
    private final OpenTelemetry oTel;
    private TracingLevel tracingLevel = TracingLevel.INFO;

    public Tracer build() {
        return new OtelTracer(this.oTel, this.tracingLevel);
    }

    public OpenTelemetryTracerBuilder(OpenTelemetry openTelemetry) {
        this.oTel = Objects.requireNonNull(openTelemetry, "openTelemetry");
    }

    public OpenTelemetryTracerBuilder setTracingLevel(TracingLevel tracingLevel) {
        this.tracingLevel = Objects.requireNonNull(tracingLevel, "tracingLevel");
        return this;
    }
}

