/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.util;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vcenter.certificate_management.StructDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.SigningCertificateDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.SubscriptionsDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TlsCsrDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TlsDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.TrustedRootChainsDefinitions;
import com.vmware.vcenter.certificate_management.vcenter.VmcaRootDefinitions;
import com.vmware.vcenter.identity.AuthBrokerIdpDefinitions;
import com.vmware.vcenter.identity.ForeignSecurityPrincipalsDefinitions;
import com.vmware.vcenter.identity.MigrationDefinitions;
import com.vmware.vcenter.identity.VcIdentityDefinitions;
import com.vmware.vcenter.identity.broker.tenants.ProvidersDefinitions;
import com.vmware.vcenter.identity.broker.tenants.providers.SyncClientDefinitions;
import com.vmware.vcenter.identity.provider.KeySetDefinitions;
import com.vmware.vcenter.trust.VcTrustsDefinitions;
import java.util.Map;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.x509_cert_chain", StructDefinitions.x509CertChain);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.info", TrustedRootChainsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.summary", TrustedRootChainsDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.trusted_root_chains.create_spec", TrustedRootChainsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.signing_certificate.info", SigningCertificateDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.signing_certificate.set_spec", SigningCertificateDefinitions.setSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.create_spec", SubscriptionsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.info", SubscriptionsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.summary", SubscriptionsDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.list_result", SubscriptionsDefinitions.listResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.filter_spec", SubscriptionsDefinitions.filterSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.subscriptions.update_spec", SubscriptionsDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.info", TlsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.spec", TlsDefinitions.spec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls.replace_spec", TlsDefinitions.replaceSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls_csr.info", TlsCsrDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.tls_csr.spec", TlsCsrDefinitions.spec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.certificate_management.vcenter.vmca_root.create_spec", VmcaRootDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.summary", AuthBrokerIdpDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.info", AuthBrokerIdpDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.directory_info", AuthBrokerIdpDefinitions.directoryInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.list_result", AuthBrokerIdpDefinitions.listResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.create_spec", AuthBrokerIdpDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.directory_create_spec", AuthBrokerIdpDefinitions.directoryCreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.update_spec", AuthBrokerIdpDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.auth_broker_idp.directory_update_spec", AuthBrokerIdpDefinitions.directoryUpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.info", ForeignSecurityPrincipalsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.create_spec", ForeignSecurityPrincipalsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.foreign_security_principals.update_spec", ForeignSecurityPrincipalsDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.migration.precheck_result", MigrationDefinitions.precheckResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.summary", com.vmware.vcenter.identity.ProvidersDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.info", com.vmware.vcenter.identity.ProvidersDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.create_spec", com.vmware.vcenter.identity.ProvidersDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.update_spec", com.vmware.vcenter.identity.ProvidersDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_summary", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2Summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_info", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2Info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_create_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2CreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_update_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2UpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_summary", com.vmware.vcenter.identity.ProvidersDefinitions.oidcSummary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_info", com.vmware.vcenter.identity.ProvidersDefinitions.oidcInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_create_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oidcCreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oidc_update_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oidcUpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.active_directory_over_ldap", com.vmware.vcenter.identity.ProvidersDefinitions.activeDirectoryOverLdap);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_client_create_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2ClientCreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_client_update_spec", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2ClientUpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_client_info", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2ClientInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_client_secret", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2ClientSecret);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.oauth2_bearer_token", com.vmware.vcenter.identity.ProvidersDefinitions.oauth2BearerToken);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.pop_proxy_config", com.vmware.vcenter.identity.ProvidersDefinitions.popProxyConfig);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.replace_spec", com.vmware.vcenter.identity.ProvidersDefinitions.replaceSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.principal_conversion_failure", com.vmware.vcenter.identity.ProvidersDefinitions.principalConversionFailure);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.providers.replace_result", com.vmware.vcenter.identity.ProvidersDefinitions.replaceResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.vc_identity.update_spec", VcIdentityDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.vc_identity.info", VcIdentityDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.token_info", com.vmware.vcenter.identity.broker.tenants.StructDefinitions.tokenInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.summary", ProvidersDefinitions.summary);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.info", ProvidersDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.directory_info", ProvidersDefinitions.directoryInfo);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.list_result", ProvidersDefinitions.listResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.create_spec", ProvidersDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.oidc_profile_spec", ProvidersDefinitions.oidcProfileSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.directory_create_spec", ProvidersDefinitions.directoryCreateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.update_spec", ProvidersDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.directory_update_spec", ProvidersDefinitions.directoryUpdateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.directories.sync_client.info", com.vmware.vcenter.identity.broker.tenants.directories.SyncClientDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.directories.sync_client.generate_result", com.vmware.vcenter.identity.broker.tenants.directories.SyncClientDefinitions.generateResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.sync_client.info", SyncClientDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.broker.tenants.providers.sync_client.generate_result", SyncClientDefinitions.generateResult);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.provider.key_set.info", KeySetDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.identity.provider.key_set.set_spec", KeySetDefinitions.setSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.create_spec", VcTrustsDefinitions.createSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.update_spec", VcTrustsDefinitions.updateSpec);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.info", VcTrustsDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.vcenter.trust.vc_trusts.summary", VcTrustsDefinitions.summary);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

