/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.data.Credentials;
import com.vmware.srm.client.impex.tool.io.data.KeyStoreData;
import com.vmware.srm.client.impex.tool.io.data.Lspp;
import com.vmware.srm.client.impex.tool.io.data.SrmPairInfo;
import com.vmware.srm.client.impex.tool.io.request.Request;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class InputWaiterRequester {
    protected final BlockingQueue<Request> _requests = new LinkedBlockingQueue<Request>();
    protected final IOHelper _ioHelper;

    protected InputWaiterRequester(IOHelper ioHelper) {
        this._ioHelper = ioHelper;
    }

    public ExitStatus waitForInput() throws InterruptedException {
        Request request;
        do {
            request = this._requests.take();
            request.execute();
        } while (!request.isFinal());
        return request.getExitStatus();
    }

    public abstract Promise<Lspp> promptForLspp();

    public abstract Promise<Boolean> promptForThumbprint(String var1, String var2);

    public abstract Promise<Boolean> promptForUsingLocalKeyStore(String var1);

    public abstract Promise<Boolean> promptForUsingLocalServiceAccount(String var1);

    public abstract Promise<String> promptForLocalSAPath();

    public abstract Promise<Credentials> promptForLocalCredentials(String var1);

    public abstract Promise<KeyStoreData> promptForLocalKeyStoreData();

    public abstract Promise<String> promptForSrmServer(ArrayList<SrmPairInfo> var1);

    public abstract Promise<Boolean> promptForUsingRemoteKeyStore(String var1);

    public abstract Promise<Boolean> promptForUsingRemoteServiceAccount(String var1);

    public abstract Promise<String> promptForRemoteSAPath(String var1);

    public abstract Promise<Credentials> promptForRemoteCredentials(String var1);

    public abstract Promise<KeyStoreData> promptForRemoteKeyStoreData();

    public abstract AmErrorHandling continueOnAmError();

    public abstract Promise<Credentials> promptForAmCredentials(String var1);

    public abstract void complete(int var1, String var2);

    protected String getSrmServerGuid(ArrayList<SrmPairInfo> srmPairInfos, String srmNameToFind) {
        return srmPairInfos.stream().filter(srmPairInfo -> srmNameToFind.equals(srmPairInfo.getLocalName())).map(SrmPairInfo::getLocalGuid).findFirst().orElseThrow(() -> new IllegalArgumentException("No SRM server named '" + srmNameToFind + "' is found."));
    }

    public static class ExitStatus {
        private final int _code;
        private final String _message;

        public ExitStatus(int code, String message) {
            this._code = code;
            this._message = message;
        }

        public int getCode() {
            return this._code;
        }

        public String getMessage() {
            return this._message;
        }
    }

    public static enum AmErrorHandling {
        CONTINUE,
        INTERRUPT,
        PROMPT;

    }

    public static class RejectedException
    extends RuntimeException {
        public RejectedException(String message) {
            super(message);
        }
    }
}

