/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.workflow;

import com.vmware.srm.client.impex.tool.io.CmdInputWR;
import com.vmware.srm.client.impex.tool.io.ConsoleIOHelper;
import com.vmware.srm.client.impex.tool.io.ConsoleInputWR;
import com.vmware.srm.client.impex.tool.io.FileInputWR;
import com.vmware.srm.client.impex.tool.io.IOHelper;
import com.vmware.srm.client.impex.tool.io.InputWaiterRequester;
import com.vmware.srm.client.impex.tool.io.StandardIOHelper;
import com.vmware.srm.client.impex.tool.io.args.Arguments;
import com.vmware.srm.client.impex.tool.io.data.UserInputProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;

public class UserInteractor {
    private static final AtomicReference<InputWaiterRequester> INPUT_WR_INSTANCE = new AtomicReference();
    private static final IOHelper IO_HELPER = System.console() == null ? new StandardIOHelper(System.in, System.out) : new ConsoleIOHelper(System.console());

    public static void initFromStdInUsingCmdArgs(Arguments arguments) {
        if (!INPUT_WR_INSTANCE.compareAndSet(null, new CmdInputWR(IO_HELPER, arguments))) {
            throw new IllegalStateException("InputWaiterRequester is already initialized.");
        }
    }

    public static void initFromStdIn() {
        if (!INPUT_WR_INSTANCE.compareAndSet(null, new ConsoleInputWR(IO_HELPER))) {
            throw new IllegalStateException("InputWaiterRequester is already initialized.");
        }
    }

    public static void initFromFile(String propertiesFilePath) throws IOException, UserInputProperties.InvalidPropertyException {
        if (!INPUT_WR_INSTANCE.compareAndSet(null, new FileInputWR(IO_HELPER, UserInteractor.loadFile(propertiesFilePath)))) {
            throw new IllegalStateException("InputWaiterRequester is already initialized.");
        }
    }

    public static IOHelper getIoHelper() {
        return IO_HELPER;
    }

    public static InputWaiterRequester getInputWaiter() {
        InputWaiterRequester inputRW = INPUT_WR_INSTANCE.get();
        Validate.notNull(inputRW, "InputWaiterRequester");
        return inputRW;
    }

    private static UserInputProperties loadFile(String propertiesFilePath) throws IOException, UserInputProperties.InvalidPropertyException {
        Validate.notEmpty(propertiesFilePath);
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(new File(propertiesFilePath));){
            properties.load(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));
        }
        return new UserInputProperties(properties);
    }
}

