/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import java.util.Objects;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ApacheClientConnectionClose
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new ApacheClientConnectionClose();

    private ApacheClientConnectionClose() {
    }

    public void process(HttpRequest request, HttpContext context) {
        Objects.requireNonNull(request);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Close");
        }
    }
}

