/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.impl.InetConnection;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ApacheClientConnectionInterceptor
implements HttpResponseInterceptor {
    private static final Log LOG = LogFactory.getLog(ApacheClientConnectionInterceptor.class);
    public static final HttpResponseInterceptor INSTANCE = new ApacheClientConnectionInterceptor();

    private ApacheClientConnectionInterceptor() {
    }

    public void process(HttpResponse request, HttpContext context) {
        CachedInetConnection conn;
        if (!(context instanceof HttpCoreContext)) {
            return;
        }
        HttpCoreContext ctx = (HttpCoreContext)context;
        try {
            conn = new CachedInetConnection((HttpInetConnection)ctx.getConnection(HttpInetConnection.class));
        }
        catch (Exception e) {
            LOG.trace((Object)"Unable to extract connection info from HTTP context", (Throwable)e);
            return;
        }
        try {
            ctx.setAttribute("vlsi-client-connection", (Object)conn);
        }
        catch (Exception e) {
            LOG.trace((Object)"Unable to set connection as context attribute", (Throwable)e);
            return;
        }
    }

    class CachedInetConnection
    implements InetConnection {
        private InetAddress localAddress;
        private int localPort;
        private InetAddress remoteAddress;
        private int remotePort;

        CachedInetConnection(HttpInetConnection source) {
            this.localAddress = source.getLocalAddress();
            this.localPort = source.getLocalPort();
            this.remoteAddress = source.getRemoteAddress();
            this.remotePort = source.getRemotePort();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.localAddress;
        }

        @Override
        public int getLocalPort() {
            return this.localPort;
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public int getRemotePort() {
            return this.remotePort;
        }

        public String toString() {
            return String.format("%s:%d -> %s:%d", this.localAddress, this.localPort, this.remoteAddress, this.remotePort);
        }
    }
}

