/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ConnectionMonitor;
import java.security.Principal;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class BaseCompiledHttpConfiguration
implements CompiledHttpConfiguration {
    private static final Log LOG = LogFactory.getLog(BaseCompiledHttpConfiguration.class);
    private boolean _active = true;
    private WeakHashMap<Client, Boolean> _usage = new WeakHashMap();
    private Principal _clientSSLToken;
    private final ConnectionMonitor.CleanableConnectionPool pool;

    protected BaseCompiledHttpConfiguration(ConnectionMonitor.CleanableConnectionPool pool) {
        this.pool = pool;
        if (pool != null) {
            ConnectionMonitor.register(pool);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this._active;
    }

    @Override
    public synchronized void reserve(Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reserving CompiledHttpConfiguration@" + this.hashCode() + " to Client@" + client.hashCode()));
        }
        if (!this._active) {
            throw new IllegalStateException("HTTP configuration already shutdown!");
        }
        this._usage.put(client, Boolean.TRUE);
    }

    @Override
    public synchronized void release(Client client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing Client@" + client.hashCode() + " reference from CompiledHttpConfiguration@" + this.hashCode() + ", " + (this._usage.size() - 1) + " active clients left."));
        }
        this._usage.remove(client);
        if (this._usage.isEmpty() && this._active) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Shutting down CompiledHttpConfiguration@" + this.hashCode() + " as there are no more clients."));
            }
            this.shutdown();
        }
    }

    protected synchronized void setActive(boolean active) {
        this._active = active;
    }

    @Override
    public Principal getClientSSLToken() {
        return this._clientSSLToken;
    }

    @Override
    public void setClientSSLToken(Principal clientSSLToken) {
        if (this._clientSSLToken != null) {
            if (!this._clientSSLToken.equals(clientSSLToken)) {
                throw new InternalException("Trying to override already set SSL user token with different one.");
            }
            return;
        }
        this._clientSSLToken = clientSSLToken;
    }

    @Override
    public void shutdown() {
        this.setActive(false);
    }
}

