/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.common.Exchange;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.Response;
import com.vmware.vim.vmomi.client.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.client.exception.ClientHaltException;
import com.vmware.vim.vmomi.client.exception.InvalidSslCertificateException;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.http.CompiledHttpConfiguration;
import com.vmware.vim.vmomi.client.http.impl.ApacheClientRequestConfigurationMerger;
import com.vmware.vim.vmomi.client.http.impl.HttpSchemeUtils;
import com.vmware.vim.vmomi.client.http.impl.InetConnection;
import com.vmware.vim.vmomi.client.http.impl.TracingScopedRunnable;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.tracing.NoopTracer;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import com.vmware.vim.vmomi.core.types.ManagedMethod;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public abstract class HttpExchangeBase
extends TracingScopedRunnable
implements Exchange,
Runnable {
    private static final Log LOG = LogFactory.getLog(HttpExchangeBase.class);
    protected static final Header CONTENT_TYPE = new BasicHeader("Content-Type", "text/xml; charset=utf-8");
    protected static final Header ACCEPT_ENCODING = new BasicHeader("Accept-Encoding", "gzip");
    protected static final Header CONTENT_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    protected static final String REQUEST_VERSION_ID_TEMPLATE = "urn:%1$s/%2$s";
    static final String CONNECTION_CONTEXT_KEY = "vlsi-client-connection";
    private final Request _request;
    private final boolean _requestIsPost;
    private final Response _response;
    private final CompiledHttpConfiguration _compiledConfig;
    private final URI _endpoint;
    private final boolean _enableCompression;
    private final InvocationInterceptor _invocationInterceptor;
    private final ApacheClientRequestConfigurationMerger _configMerger;
    private final Tracer.Span _tracingSpan;

    protected HttpExchangeBase(Request request, Response response, CompiledHttpConfiguration compiledHttpConfig, ApacheClientRequestConfigurationMerger configMerger, URI endpoint, boolean enableCompression, InvocationInterceptor invocationInterceptor, String io, boolean sync, Tracer tracer) {
        this._request = request;
        this._requestIsPost = request.getDownloadLocation() == null;
        this._response = response;
        this._compiledConfig = compiledHttpConfig;
        this._configMerger = configMerger;
        this._endpoint = this._requestIsPost ? endpoint : request.getDownloadLocation();
        this._enableCompression = enableCompression;
        this._invocationInterceptor = invocationInterceptor;
        this._tracingSpan = this.startTrace(io, sync, tracer);
    }

    @Override
    public Request getRequest() {
        return this._request;
    }

    @Override
    public Response getResponse() {
        return this._response;
    }

    protected void beginInvocation() {
        block5: {
            if (this._invocationInterceptor != null) {
                try {
                    this._invocationInterceptor.beginInvocation(this.getInvocationContext());
                }
                catch (Exception e) {
                    if (e instanceof ClientHaltException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"ClientHaltException on InvocationInterceptor.beginInvocation(...), aborting execution", (Throwable)e);
                        }
                        throw (ClientHaltException)e;
                    }
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)"Exception on InvocationInterceptor.beginInvocation(...)", (Throwable)e);
                }
            }
        }
    }

    protected void completeInvocation(boolean success) {
        block3: {
            if (this._invocationInterceptor != null) {
                try {
                    this._invocationInterceptor.completeInvocation(this.getInvocationContext(), success);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)"Exception on InvocationInterceptor.completeInvocation(...)", (Throwable)e);
                }
            }
        }
        this.finishTrace();
    }

    private Tracer.Span startTrace(String io, boolean sync, Tracer tracer) {
        Object opId;
        RequestContext context;
        String workflowVal;
        InvocationContext invContext = this.getInvocationContext();
        if (invContext == null) {
            return NoopTracer.INSTANCE.getActiveSpan();
        }
        ManagedMethod method = invContext.getMethod();
        String spanName = method.getFullyQualifiedVmodlName() == null ? method.getName() : method.getFullyQualifiedVmodlName();
        Tracer.Span span = tracer.spanBuilder(spanName).setAttribute("component", "vlsi-client").setAttribute("span.kind", "client").setAttribute("thread", Thread.currentThread().getName()).setAttribute("http.method", this._requestIsPost ? "POST" : "GET").setAttribute("http.url", this._endpoint.toString()).setAttribute("io", io).setAttribute("sync", sync).startSpan();
        String workflowCurrentVal = span.getBaggage("workflow");
        String string = workflowVal = workflowCurrentVal == null ? method.getFullyQualifiedVmodlName() : workflowCurrentVal;
        if (workflowVal != null) {
            span.addBaggage("workflow", workflowVal);
            span.setAttribute("workflow", workflowVal);
        }
        if ((context = invContext.getStubRequestContext()) != null && (opId = context.get((Object)"operationID")) != null) {
            span.setAttribute("opId", opId.toString());
        }
        return span;
    }

    protected void finishTrace() {
        Tracer.Span span = this._tracingSpan;
        InvocationContext ic = this.getInvocationContext();
        if (ic != null) {
            InetSocketAddress remoteAddress;
            InetSocketAddress localAddress = ic.getLocalAddress();
            if (localAddress != null) {
                span.setAttribute("local.hostname", localAddress.getHostString());
                span.setAttribute("local.port", localAddress.getPort());
            }
            if ((remoteAddress = ic.getRemoteAddress()) != null) {
                span.setAttribute("peer.hostname", remoteAddress.getHostString());
                span.setAttribute("peer.port", remoteAddress.getPort());
            }
        }
        span.end();
    }

    protected HttpUriRequest prepareRequest() throws IOException, MarshallException {
        HttpPost request;
        Object object = request = this._requestIsPost ? this.createPost() : this.createGet();
        if (this._enableCompression) {
            request.setHeader(CONTENT_ENCODING);
            request.setHeader(ACCEPT_ENCODING);
        }
        this._tracingSpan.injectInto((Object)request, HttpMessage::setHeader);
        return (HttpUriRequest)request;
    }

    protected HttpGet createGet() {
        return new HttpGet(this._endpoint);
    }

    protected HttpPost createPost() throws IOException, MarshallException {
        HttpPost post = new HttpPost(this._endpoint);
        post.setHeader(CONTENT_TYPE);
        String versionId2 = this._request.getVersion().getVersionId();
        post.setHeader("SOAPAction", versionId2 != null && versionId2.length() > 0 ? String.format(REQUEST_VERSION_ID_TEMPLATE, this._request.getVersion().getNamespace(), versionId2) : "");
        post.setEntity((HttpEntity)new RequestEntity());
        return post;
    }

    protected URI getEndPoint() {
        return this._endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseResponse(HttpResponse response) throws IOException {
        InputStream responseBody = null;
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            this._tracingSpan.setAttribute("http.status", statusCode);
            if (statusCode == Response.Status.InvalidSslCertificate.getCode()) {
                throw new InvalidSslCertificateException("Invalid SSL certificate (HTTP 526 status code)", EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
            }
            responseBody = response.getEntity().getContent();
            Header contentEncoding = response.getFirstHeader("Content-Encoding");
            if (contentEncoding != null && "gzip".equals(contentEncoding.getValue())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Received HTTP response with gzip content encoding.");
                }
                responseBody = new GZIPInputStream(responseBody);
            }
            this.getResponse().setResponse(Response.Status.getStatus(statusCode), responseBody);
        }
        finally {
            block12: {
                if (responseBody != null) {
                    try {
                        responseBody.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug((Object)"Exception on connection close.", (Throwable)e);
                    }
                }
            }
        }
    }

    protected HttpClientContext prepareLocalContext() {
        RequestConfig config = this._configMerger.mergeWithDefaultConfig(this._request.getConfiguration());
        HttpClientContext httpContext = new HttpClientContext();
        httpContext.setRequestConfig(config);
        if (!HttpSchemeUtils.isSecure(this.getEndPoint())) {
            return httpContext;
        }
        if (this._compiledConfig.getClientSSLToken() != null) {
            httpContext.setUserToken((Object)this._compiledConfig.getClientSSLToken());
        }
        return httpContext;
    }

    protected InvocationContext getInvocationContext() {
        if (this._response instanceof ResponseImpl) {
            return ((ResponseImpl)this._response).getInvocationContext();
        }
        return null;
    }

    protected void extractUserToken(HttpClientContext httpContext) {
        if (httpContext == null || !HttpSchemeUtils.isSecure(this.getEndPoint())) {
            return;
        }
        if (httpContext.getUserToken() != null && this._compiledConfig.getClientSSLToken() == null) {
            this._compiledConfig.setClientSSLToken((Principal)httpContext.getUserToken(Principal.class));
        }
    }

    void extractInetAddresses(HttpContext httpContext) {
        block6: {
            InvocationContext ic = this.getInvocationContext();
            if (ic == null) {
                return;
            }
            InetConnection connection = null;
            InetSocketAddress localAddress = null;
            InetSocketAddress remoteAddress = null;
            try {
                connection = (InetConnection)httpContext.getAttribute(CONNECTION_CONTEXT_KEY);
                localAddress = new InetSocketAddress(connection.getLocalAddress(), connection.getLocalPort());
                remoteAddress = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            }
            catch (Exception e) {
                LOG.trace((Object)"Unable to extract IP addresses from http-client", (Throwable)e);
            }
            if (connection != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("VLSI-client connection: %s", connection));
            }
            try {
                ic.setInetAddresses(localAddress, remoteAddress);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)String.format("Unable to set local (%s) and remote (%s) IP addresses in invocation-context", localAddress, remoteAddress), (Throwable)e);
            }
        }
    }

    protected void setResponseError(Exception e) {
        this._tracingSpan.addErrorEvent(e);
        this.getResponse().setError(e);
    }

    @Override
    protected Tracer.Span getTracingSpan() {
        return this._tracingSpan;
    }

    private class RequestEntity
    extends AbstractHttpEntity {
        private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

        public RequestEntity() throws IOException, MarshallException {
            OutputStream os = HttpExchangeBase.this._enableCompression ? new GZIPOutputStream(this._buffer) : this._buffer;
            HttpExchangeBase.this._request.writeBody(os);
            os.close();
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return this._buffer.size();
        }

        public InputStream getContent() {
            return new ByteArrayInputStream(this._buffer.toByteArray());
        }

        public void writeTo(OutputStream outstream) throws IOException {
            outstream.write(this._buffer.toByteArray());
        }

        public boolean isStreaming() {
            return false;
        }
    }
}

