/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.record;

import com.vmware.vim.vmomi.client.common.impl.ManagedObjectFactoryImpl;
import com.vmware.vim.vmomi.core.serialize.impl.XmlObjectInputStream;
import com.vmware.vim.vmomi.core.serialize.impl.XmlObjectOutputStream;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.Unmarshaller;
import com.vmware.vim.vmomi.core.types.ManagedObjectFactory;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;

public class VmomiRecordUtils {
    public static final String METHOD_DATA_FILE = "method-data";
    public static final String CLASS_KEY = "vmomi-class";
    public static final String METHOD_KEY = "vmomi-method";
    public static final String TIME_KEY = "invocation-time";
    public static final String THIS_FILE = "this";
    public static final String ARG_FILE_PREFIX = "arg-";
    public static final String VMOMI_FAULT_FILE = "vmomi-fault";
    public static final String JAVA_FAULT_FILE = "java-fault";
    public static final String RESPONSE_FILE = "response";

    public static void serializeVmomiObjectToFile(Object obj, File file, VmodlContext context, VmodlVersion version) throws IOException, XMLStreamException {
        Validate.notNull((Object)file, (String)"file");
        Validate.notNull((Object)context, (String)"context");
        if (obj == null) {
            VmomiRecordUtils.createEmptyFile(file);
            return;
        }
        Marshaller m = context.createMarshaller(version);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
             XmlObjectOutputStream oos = new XmlObjectOutputStream((OutputStream)os, m);){
            oos.writeObject(obj);
        }
    }

    public static Object deserializeVmomiObjectFromFile(File file, VmodlContext context, VmodlVersion version) throws IOException, XMLStreamException, ClassNotFoundException {
        Validate.notNull((Object)file, (String)"file");
        Validate.notNull((Object)context, (String)"context");
        byte[] content = Files.readAllBytes(file.toPath());
        if (content.length == 0) {
            return null;
        }
        Unmarshaller u = context.createResponseUnmarshaller(version, (ManagedObjectFactory)new ManagedObjectFactoryImpl(null, null));
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        XmlObjectInputStream ois = new XmlObjectInputStream((InputStream)is, u);
        return ois.readObject();
    }

    public static void serializeJavaObjectToFile(Object obj, File file) throws IOException {
        Validate.notNull((Object)file, (String)"file");
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
             ObjectOutputStream oo = new ObjectOutputStream(os);){
            oo.writeObject(obj);
        }
    }

    public static Object deserializeJavaObjectFromFile(File objFile) throws IOException, ClassNotFoundException {
        Validate.notNull((Object)objFile, (String)"file");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(objFile.toPath(), new OpenOption[0]));){
            Object object;
            try (ObjectInputStream oi = new ObjectInputStream(is);){
                object = oi.readObject();
            }
            return object;
        }
    }

    private static void createEmptyFile(File file) throws IOException {
        Files.createFile(file.toPath(), new FileAttribute[0]);
    }
}

