/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.List;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSessionBase;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSessionHandshake
extends ProvSSLSessionBase {
    protected final SecurityParameters securityParameters;
    protected final JsseSecurityParameters jsseSecurityParameters;

    ProvSSLSessionHandshake(ProvSSLSessionContext provSSLSessionContext, String string, int n, SecurityParameters securityParameters, JsseSecurityParameters jsseSecurityParameters) {
        super(provSSLSessionContext, string, n);
        this.securityParameters = securityParameters;
        this.jsseSecurityParameters = jsseSecurityParameters;
    }

    String getApplicationProtocol() {
        return JsseUtils.getApplicationProtocol(this.securityParameters);
    }

    @Override
    protected int getCipherSuiteTLS() {
        return this.securityParameters.getCipherSuite();
    }

    @Override
    protected byte[] getIDArray() {
        return this.securityParameters.getSessionID();
    }

    @Override
    protected JsseSecurityParameters getJsseSecurityParameters() {
        return this.jsseSecurityParameters;
    }

    @Override
    protected JsseSessionParameters getJsseSessionParameters() {
        return null;
    }

    @Override
    protected Certificate getLocalCertificateTLS() {
        return this.securityParameters.getLocalCertificate();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.localSigSchemesCert);
    }

    @Override
    protected Certificate getPeerCertificateTLS() {
        return this.securityParameters.getPeerCertificate();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return SignatureSchemeInfo.getJcaSignatureAlgorithms(this.jsseSecurityParameters.peerSigSchemesCert);
    }

    @Override
    protected ProtocolVersion getProtocolTLS() {
        return this.securityParameters.getNegotiatedVersion();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        return JsseUtils.convertSNIServerNames(this.securityParameters.getClientServerNames());
    }
}

