/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn;

import com.vmware.vapi.cis.authn.json.BearerTokenProcessor;
import com.vmware.vapi.cis.authn.json.JsonSigningProcessor;
import com.vmware.vapi.dsig.json.JsonOAuthProcessor;
import com.vmware.vapi.dsig.json.JsonSessionProcessor;
import com.vmware.vapi.dsig.json.JsonUserPassProcessor;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.ClientConfiguration;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.JsonProtocolConnectionFactory;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.protocol.ProtocolConnectionFactory;
import com.vmware.vapi.protocol.RequestProcessor;
import java.security.KeyStore;
import java.util.Arrays;

public final class ProtocolFactory
implements ProtocolConnectionFactory {
    private final ProtocolConnectionFactory connectionFactory;

    public ProtocolFactory() {
        this.connectionFactory = new JsonProtocolConnectionFactory();
    }

    public ProtocolFactory(ProtocolConnectionFactory connectionFactory) {
        Validate.notNull((Object)connectionFactory);
        this.connectionFactory = connectionFactory;
    }

    public ProtocolConnection getConnection(String type, String args, KeyStore trustStore) {
        if (type.equals(Protocol.http.toString())) {
            HttpConfiguration.SslConfiguration sslConfig = new HttpConfiguration.SslConfiguration.Builder(trustStore).getConfig();
            return this.getHttpConnection(args, null, new HttpConfiguration.Builder().setSslConfiguration(sslConfig).getConfig());
        }
        return null;
    }

    public ProtocolConnection getHttpConnection(String uri, ClientConfiguration clientConfig, HttpConfiguration httpConfig) {
        clientConfig = this.enhanceClientConfig(clientConfig);
        return this.connectionFactory.getHttpConnection(uri, clientConfig, httpConfig);
    }

    private ClientConfiguration enhanceClientConfig(ClientConfiguration clientConfig) {
        ClientConfiguration.Builder builder = new ClientConfiguration.Builder(clientConfig);
        if (clientConfig == null || builder.getRequestProcessors() == null) {
            builder.setRequestProcessors(Arrays.asList(new RequestProcessor[]{new JsonSigningProcessor(), new BearerTokenProcessor(), new JsonSessionProcessor(), new JsonUserPassProcessor(), new JsonOAuthProcessor()}));
        }
        return builder.getConfig();
    }

    public ProtocolConnection getInsecureConnection(String type, String args) {
        if (type.equals(Protocol.http.toString())) {
            return this.getHttpConnection(args, null, null);
        }
        return null;
    }

    public static enum Protocol {
        http;

    }
}

