/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.tool.io;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.infrastructure.authentication.Credentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAFileReader.class);
    private static final int BUFFER_SIZE = 1024;
    private final Path _saPath;

    public SAFileReader(Path saPath) {
        this._saPath = saPath;
    }

    public Promise<Credentials> read() {
        AsynchronousFileChannel channel;
        try {
            channel = AsynchronousFileChannel.open(this._saPath, StandardOpenOption.READ);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to open Srm SA store {}.", (Object)this._saPath, (Object)e);
            return Promises.reject((Exception)e);
        }
        return this.readFromChannel(channel, ByteBuffer.allocate(1024), new ByteArrayOutputStream(), 0L).thenApply(out -> {
            try {
                String[] both = out.toString().split("\r\n|[\r\n]");
                if (both.length != 2) {
                    throw new IllegalStateException("SA store");
                }
                Credentials credentials = new Credentials(both[0], both[1]);
                return credentials;
            }
            finally {
                this.closeChannel(channel);
            }
        });
    }

    private Promise<ByteArrayOutputStream> readFromChannel(AsynchronousFileChannel channel, ByteBuffer bb, ByteArrayOutputStream out, long position) {
        SAFilePromise<Integer> readPromise = new SAFilePromise<Integer>();
        channel.read(bb, position, channel, readPromise);
        return readPromise.thenCompose(bytesRead -> {
            if (bytesRead == -1) {
                return Promises.resolve((Object)out);
            }
            out.write(bb.array(), 0, bb.position());
            bb.clear();
            return this.readFromChannel(channel, bb, out, position + (long)bytesRead.intValue());
        });
    }

    private void closeChannel(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException ioExc) {
            LOGGER.warn("Failed to close SA store {}", (Object)this._saPath, (Object)ioExc);
        }
    }

    private class SAFilePromise<T>
    extends PromiseImpl<T>
    implements CompletionHandler<T, AsynchronousFileChannel> {
        private SAFilePromise() {
        }

        @Override
        public final void completed(T result, AsynchronousFileChannel channel) {
            this.setResult(result);
        }

        @Override
        public final void failed(Throwable exc, AsynchronousFileChannel channel) {
            LOGGER.warn("Unable to read SA store {}.", (Object)SAFileReader.this._saPath, (Object)exc);
            try {
                SAFileReader.this.closeChannel(channel);
            }
            finally {
                this.setError(Exceptions.wrap((Throwable)exc));
            }
        }
    }
}

