/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ValueVisitor;
import java.util.Arrays;

public final class SecretValue
implements DataValue {
    public static final String STRING_REPRESENTATION = "<secret>";
    private static final long serialVersionUID = 1L;
    private final char[] value;

    public SecretValue(char[] value) {
        if (value == null) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.secret.null.chararray", new String[0]));
        }
        this.value = value;
    }

    @Override
    public DataType getType() {
        return DataType.SECRET;
    }

    public char[] getValue() {
        return this.value;
    }

    public void clear() {
        Arrays.fill(this.value, ' ');
    }

    public boolean equals(Object o) {
        if (o instanceof SecretValue) {
            SecretValue secret = (SecretValue)o;
            return Arrays.equals(this.value, secret.value);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return STRING_REPRESENTATION;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public SecretValue copy() {
        return new SecretValue(Arrays.copyOf(this.value, this.value.length));
    }
}

