/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.Consumer;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.internal.bindings.BindingsExceptionTranslator;
import com.vmware.vapi.internal.bindings.Stub;
import java.util.Collection;

abstract class ResultTranslatingHandle<T>
extends AsyncHandle<MethodResult> {
    protected final Stub stub;
    protected final Type outputType;
    protected final Collection<Type> errorTypes;

    ResultTranslatingHandle(Stub stub, Type outputType, Collection<Type> errorTypes) {
        this.stub = stub;
        this.outputType = outputType;
        this.errorTypes = errorTypes;
    }

    @Override
    public void setResult(MethodResult result) {
        if (result.equals(MethodResult.EMPTY)) {
            this.onSuccess(null, null);
        } else if (result.success()) {
            this.onSuccess(this.stub.convert(result.getOutput(), this.outputType), result.getNext());
        } else {
            this.onFailure(this.stub.convertError(result.getError(), this.errorTypes));
        }
        this.postProcessResponse(result);
    }

    protected void postProcessResponse(MethodResult result) {
        Consumer<AsyncHandle<MethodResult>> nextHandleConsumer = result.getNext();
        if (nextHandleConsumer != null) {
            nextHandleConsumer.accept(null);
        }
    }

    @Override
    public void setError(RuntimeException error) {
        this.onFailure(BindingsExceptionTranslator.translate(error));
    }

    abstract void onSuccess(T var1, Consumer<AsyncHandle<MethodResult>> var2);

    abstract void onFailure(RuntimeException var1);
}

