/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.protocol.client.rpc.http.adapter.ProxyAwareHttpClientBuilderAdapter;
import com.vmware.vapi.protocol.HttpConfiguration;
import com.vmware.vapi.protocol.UserPassCredentials;
import com.vmware.vapi.protocol.server.rpc.http.InternalException;
import java.io.IOException;
import java.net.ProxySelector;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientProxyConfigurationHelper {
    private static Logger logger = LoggerFactory.getLogger(HttpClientProxyConfigurationHelper.class);
    private static final String PROXY_AUTH_HEADER_VALUE = "Basic";

    HttpClientProxyConfigurationHelper() {
    }

    static void addProxyConfiguration(HttpConfiguration.ProxyConfiguration proxyConfig, ProxyAwareHttpClientBuilderAdapter builderAdapter) throws SecurityException {
        HttpHost defaultProxy = null;
        if (proxyConfig.usesSystemDefaultProxyConfiguration()) {
            logger.debug("Setting up system default proxy configuration...");
            SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            builderAdapter.setRoutePlanner((HttpRoutePlanner)routePlanner);
        } else {
            defaultProxy = new HttpHost(proxyConfig.getHost(), proxyConfig.getPort());
            logger.debug("Setting default proxy host to {}", (Object)defaultProxy.toURI());
            builderAdapter.setProxy(defaultProxy);
        }
        BasicCredentialsProvider credentialsProvider = null;
        UserPassCredentials defaultCredentials = proxyConfig.getUserPassCredentials();
        if (defaultCredentials != null) {
            credentialsProvider = new BasicCredentialsProvider();
        } else if (proxyConfig.usesSystemDefaultProxyConfiguration()) {
            credentialsProvider = new SystemDefaultCredentialsProvider();
        }
        if (credentialsProvider != null) {
            HttpClientProxyConfigurationHelper.configurePreemptiveBasicAuthentication(builderAdapter, defaultProxy, defaultCredentials, (CredentialsProvider)credentialsProvider);
        }
    }

    private static void configurePreemptiveBasicAuthentication(ProxyAwareHttpClientBuilderAdapter builder, HttpHost defaultProxy, UserPassCredentials defaultCredentials, CredentialsProvider credentialsProvider) {
        HttpRequestInterceptor interceptor;
        BasicScheme proxyAuth = new BasicScheme();
        try {
            proxyAuth.processChallenge((Header)new BasicHeader("Proxy-Authenticate", PROXY_AUTH_HEADER_VALUE));
        }
        catch (MalformedChallengeException e) {
            throw new InternalException(e);
        }
        UsernamePasswordCredentials credentials = defaultCredentials != null ? new UsernamePasswordCredentials(defaultCredentials.getUser(), String.valueOf(defaultCredentials.getPassword())) : null;
        BasicAuthCache authCache = new BasicAuthCache();
        if (defaultProxy != null && defaultCredentials != null) {
            logger.debug("Configuring pre-emptive Basic Authentication with scope {} using BasicCredentialsProvider.", (Object)defaultProxy.toURI());
            authCache.put(defaultProxy, (AuthScheme)proxyAuth);
            credentialsProvider.setCredentials(new AuthScope(defaultProxy), (Credentials)credentials);
            interceptor = (request, context) -> {
                ((HttpClientContext)context).setAuthCache((AuthCache)authCache);
                ((HttpClientContext)context).setCredentialsProvider(credentialsProvider);
            };
        } else {
            interceptor = (arg_0, arg_1) -> HttpClientProxyConfigurationHelper.lambda$configurePreemptiveBasicAuthentication$1(defaultProxy, credentialsProvider, authCache, proxyAuth, (Credentials)credentials, arg_0, arg_1);
        }
        builder.addInterceptorFirst(interceptor);
    }

    private static /* synthetic */ void lambda$configurePreemptiveBasicAuthentication$1(HttpHost defaultProxy, CredentialsProvider credentialsProvider, BasicAuthCache authCache, BasicScheme proxyAuth, Credentials credentials, HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpHost proxy;
        HttpHost httpHost = proxy = defaultProxy != null ? defaultProxy : ((HttpClientContext)context).getHttpRoute().getProxyHost();
        if (proxy != null) {
            logger.debug("Configuring pre-emptive Basic Authentication with scope {} using {}.", (Object)proxy.toURI(), (Object)credentialsProvider.getClass().getSimpleName());
            authCache.put(proxy, (AuthScheme)proxyAuth);
            if (credentialsProvider instanceof BasicCredentialsProvider) {
                credentialsProvider.setCredentials(new AuthScope(proxy), credentials);
            }
            ((HttpClientContext)context).setAuthCache((AuthCache)authCache);
            ((HttpClientContext)context).setCredentialsProvider(credentialsProvider);
        } else {
            logger.warn("Default proxy selector was unable to pick a proxy for target {}! Please check if system properties contain proxyHost/Port for the respective target schema.", (Object)((HttpClientContext)context).getHttpRoute().getTargetHost().toURI());
        }
    }
}

