/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.util.StringUtils;
import com.vmware.vapi.internal.util.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Utils {
    public static <K, V> void addListEntryToMapOfLists(K key, V value, Map<K, List<V>> theMap) {
        Validate.notNull(theMap);
        List<V> values = theMap.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            theMap.put(key, values);
        }
        values.add(value);
    }

    public static String appendQueryToPath(String path, String query) {
        Validate.notNull(path);
        if (StringUtils.isNotBlank(query)) {
            StringBuilder builder = new StringBuilder(path.length() + 1 + query.length());
            builder.append(path);
            if (!path.endsWith("&") && !path.endsWith("?")) {
                builder.append(path.contains("?") ? "&" : "?");
            }
            return builder.append(query).toString();
        }
        return path;
    }

    public static String[] splitOnFirstOccurrenceOfChar(String str, char c) {
        Validate.notNull(str);
        String[] result = new String[2];
        int firstIndexOfEquals = str.indexOf(c);
        if (firstIndexOfEquals > 0) {
            result[0] = str.substring(0, firstIndexOfEquals);
            result[1] = str.substring(firstIndexOfEquals + 1);
        } else {
            result[0] = str;
            result[1] = null;
        }
        return result;
    }

    public static String join(Collection<String> collection, String delimiter) {
        Validate.notNull(collection);
        Validate.notNull(delimiter);
        StringBuilder builder = new StringBuilder();
        for (String s : collection) {
            builder.append(s);
            builder.append(delimiter);
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - delimiter.length(), builder.length());
        }
        return builder.toString();
    }
}

