/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.l10n;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.l10n.LocalizationException;
import com.vmware.vapi.l10n.ResourceBundleProvider;
import com.vmware.vapi.l10n.TemplateFormatter;
import com.vmware.vapi.std.LocalizableMessage;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class MessageLocalizer {
    private TemplateFormatter formatter;
    private ResourceBundleProvider bundleProvider;
    private Locale locale;

    public MessageLocalizer(TemplateFormatter formatter, ResourceBundleProvider bundleProvider, Locale locale) {
        Validate.notNull(formatter);
        Validate.notNull(bundleProvider);
        Validate.notNull(locale);
        this.formatter = formatter;
        this.bundleProvider = bundleProvider;
        this.locale = locale;
    }

    public String localize(LocalizableMessage localizable, Locale locale) {
        Validate.notNull(localizable);
        Validate.notNull(locale);
        return this.doLocalize(localizable.getId(), localizable.getArgs(), locale);
    }

    public String localize(LocalizableMessage localizable) {
        return this.localize(localizable, this.locale);
    }

    public String localize(StructValue localizable, Locale locale) {
        Validate.notNull(localizable);
        Validate.notNull(locale);
        try {
            String msgId = localizable.getString("id");
            ListValue argsListValue = localizable.getList("args");
            return this.doLocalize(msgId, argsListValue.getStringList(), locale);
        }
        catch (CoreException ex) {
            throw new LocalizationException("Specified StructValue is not representing localizable message");
        }
    }

    public String localize(StructValue localizable) {
        return this.localize(localizable, this.locale);
    }

    String doLocalize(String msgId, List<String> args, Locale locale) {
        Validate.notNull(msgId);
        Validate.notNull(args);
        ResourceBundle msgCatalog = this.bundleProvider.getResourceBundle(msgId, locale);
        String msgTemplate = msgCatalog.getString(msgId);
        return this.formatter.format(msgTemplate, args, locale);
    }
}

