/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.util.Validate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class UserPassSecurityContext
implements ExecutionContext.SecurityContext {
    public static final String USER_KEY = "userName";
    public static final String PASSWORD_KEY = "password";
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public UserPassSecurityContext(String user, char[] password) {
        Validate.notNull(user);
        Validate.notNull(password);
        this.properties.put(USER_KEY, user);
        this.properties.put(PASSWORD_KEY, password);
        this.properties.put("authn_scheme_id", "com.vmware.vapi.std.security.user_pass");
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getUser() {
        return (String)this.properties.get(USER_KEY);
    }

    public char[] getPassword() {
        return (char[])this.properties.get(PASSWORD_KEY);
    }

    public static UserPassSecurityContext getInstance(ExecutionContext.SecurityContext context) {
        char[] pass;
        Validate.notNull(context);
        String user = UserPassSecurityContext.getAsString(context.getProperty(USER_KEY));
        String passString = UserPassSecurityContext.getAsString(context.getProperty(PASSWORD_KEY));
        char[] cArray = pass = passString == null ? UserPassSecurityContext.getAsCharArr(context.getProperty(PASSWORD_KEY)) : passString.toCharArray();
        if (user != null && pass != null) {
            return new UserPassSecurityContext(user, pass);
        }
        return null;
    }

    private static String getAsString(Object value) {
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static char[] getAsCharArr(Object value) {
        if (value != null && value instanceof char[]) {
            return (char[])value;
        }
        return null;
    }
}

