/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.advancedSettings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeAdvancedSetting;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeBooleanAdvancedSetting;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeIntegerAdvancedSetting;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeLongAdvancedSetting;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeSiteAdvancedSettings;
import com.vmware.srm.client.impex.configurables.advancedSettings.IeStringAdvancedSetting;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.vim.binding.vim.option.OptionValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;

public class AdvancedSettingsConverter
implements ConfigurableConverter {
    private static final String DISPLAY_NAME_KEY = "localSiteStatus.displayName";
    private static final String KEY_REMOVED_IN_SRM831 = "vrReplication.timeDefault";

    public static List<IeAdvancedSetting> fromVmodl(OptionValue[] optionValues) {
        if (ArrayUtils.isEmpty((Object[])optionValues)) {
            return Collections.emptyList();
        }
        return Arrays.stream(optionValues).filter(optionValue -> !optionValue.getKey().equals(DISPLAY_NAME_KEY)).map(optionValue -> {
            Object value = optionValue.value;
            if (value instanceof Long) {
                return new IeLongAdvancedSetting(optionValue.key, (Long)value);
            }
            if (value instanceof Integer) {
                return new IeIntegerAdvancedSetting(optionValue.key, (Integer)value);
            }
            if (value instanceof Boolean) {
                return new IeBooleanAdvancedSetting(optionValue.key, (Boolean)value);
            }
            if (value instanceof String) {
                return new IeStringAdvancedSetting(optionValue.key, (String)value);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static OptionValue[] toVmodl(boolean local) {
        List<IeAdvancedSetting> settings = AdvancedSettingsConverter.getAdvancedSettings(local);
        if (settings == null) {
            return new OptionValue[0];
        }
        return (OptionValue[])settings.stream().filter(ieAdvancedSetting -> !ieAdvancedSetting.getKey().equals(KEY_REMOVED_IN_SRM831)).map(setting -> new OptionValue(setting.getKey(), setting.getValue())).toArray(OptionValue[]::new);
    }

    private static List<IeAdvancedSetting> getAdvancedSettings(boolean local) {
        return ImpexImportSrmContext.get().getConfigurablesWrapper().getSiteAdvancedSettings().stream().filter(settings -> settings.isLocal() == local).findFirst().map(IeSiteAdvancedSettings::getSettings).orElse(null);
    }
}

