/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.mappings;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.mappings.IeMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeTestNetworkMapping;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryTestNetworkMappingConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryTestNetworkMappingConverter.class);

    public static IeTestNetworkMapping[] fromVmodl(InventoryMapperBase.TestNetworkMapping[] mappings) {
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            return new IeTestNetworkMapping[0];
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return (IeTestNetworkMapping[])Arrays.stream(mappings).map(mapping -> new IeTestNetworkMapping(idBuilder.buildId(mapping.key), idBuilder.buildId(mapping.testNetwork))).filter(IeMapping::fromCurrentPair).toArray(IeTestNetworkMapping[]::new);
    }

    public static InventoryMapperBase.TestNetworkMapping[] toVmodl(IeTestNetworkMapping[] ieMappings, InventoryExtractor.InventoryLookup inventory) {
        if (ArrayUtils.isEmpty((Object[])ieMappings)) {
            return null;
        }
        return (InventoryMapperBase.TestNetworkMapping[])Arrays.stream(ieMappings).map(ieMapping -> InventoryTestNetworkMappingConverter.getTestNetworkMapping(ieMapping, inventory)).filter(Objects::nonNull).toArray(InventoryMapperBase.TestNetworkMapping[]::new);
    }

    private static InventoryMapperBase.TestNetworkMapping getTestNetworkMapping(IeTestNetworkMapping ieMapping, InventoryExtractor.InventoryLookup inventory) {
        String primaryId = ieMapping.getPrimary();
        ManagedObjectReference primary = (ManagedObjectReference)inventory.get(primaryId);
        if (primary == null) {
            String message = ImpexL10N.localize("mappings.testNetwork.primary", primaryId);
            LOGGER.warn(message);
            ImpexImportSrmContext.get().addError(message);
            return null;
        }
        String secondaryId = ieMapping.getSecondary();
        ManagedObjectReference secondary = (ManagedObjectReference)inventory.get(secondaryId);
        if (secondary == null) {
            String message = ImpexL10N.localize("mappings.testNetwork.secondary", secondaryId);
            LOGGER.warn(message);
            ImpexImportSrmContext.get().addError(message);
            return null;
        }
        LOGGER.info("Adding test network mapping with ids {} {}.", (Object)primaryId, (Object)secondaryId);
        return new InventoryMapperBase.TestNetworkMapping(primary, secondary);
    }
}

