/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.inventory;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.srm.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.srm.client.impex.configurables.inventory.InventoryConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.IeVirtualMachine;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.VirtualMachineConverterBase;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.computeRes.ComputeResourceConverter;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.computeRes.IeComputeResource;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.IeResourcePool;
import com.vmware.srm.client.impex.configurables.inventory.datacenter.resPool.ResourcePoolConverter;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Collections;
import java.util.List;

public class InventoryExporter<V extends IeVirtualMachine, C extends VirtualMachineConverterBase<V>, P extends IeResourcePool<V, P>, R extends IeComputeResource<V, P>>
extends SingleSiteExporter<IeInventoryTree> {
    private final C vmConverter;
    private final ResourcePoolConverter<V, C, P> resPoolConverter;
    private final ComputeResourceConverter<V, C, P, R> computeResConverter;
    private final InventoryConverter.PropsProvider propsProvider;

    public InventoryExporter(C vmConverter, ResourcePoolConverter<V, C, P> resPoolConverter, ComputeResourceConverter<V, C, P, R> computeResConverter, InventoryConverter.PropsProvider propsProvider) {
        this.vmConverter = vmConverter;
        this.resPoolConverter = resPoolConverter;
        this.computeResConverter = computeResConverter;
        this.propsProvider = propsProvider;
    }

    public InventoryExporter(C vmConverter, ResourcePoolConverter<V, C, P> resPoolConverter, ComputeResourceConverter<V, C, P, R> computeResConverter) {
        this.vmConverter = vmConverter;
        this.resPoolConverter = resPoolConverter;
        this.computeResConverter = computeResConverter;
        this.propsProvider = new InventoryConverter.PropsProvider();
    }

    @Override
    protected Promise<List<IeInventoryTree>> getSingleSiteConfigurables(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        String vcGuid = local ? ((SrmServer)serversData.getLocalPair().server()).vc().guid() : ((SrmServer)serversData.getRemotePair().server()).vc().guid();
        return PCUtil.retrieveProperties((ServersView)serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{InventoryConverter.getFilterSpec(vcGuid, this.propsProvider)}).thenApply(pcResult -> {
            IeInventoryTree tree = new IeInventoryTree();
            tree.setLocal(local);
            tree.setRoot(InventoryConverter.rootFromVmodl(ImpexExportSrmContext.getIdBuilder(), pcResult, vcGuid, this.vmConverter, this.resPoolConverter, this.computeResConverter));
            return Collections.singletonList(tree);
        });
    }
}

