/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.mappings;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.impex.configurables.mappings.IeMappings;
import com.vmware.srm.client.impex.configurables.mappings.IeNetworkMapping;
import com.vmware.srm.client.impex.configurables.mappings.IeStorageProfileMapping;
import com.vmware.srm.client.impex.configurables.mappings.MappingsConverter;
import com.vmware.srm.client.impex.configurables.mappings.NetworkMappingsConverter;
import com.vmware.srm.client.impex.configurables.mappings.StorageProfileMappingsConverter;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.MappingUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.client.vmomi.pbm.SpbmService;
import com.vmware.vim.binding.dr.InventoryMapperBase;
import com.vmware.vim.binding.dr.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collections;
import java.util.List;

public class MappingsExporter
extends SingleSiteExporter<IeMappings> {
    @Override
    protected Promise<List<IeMappings>> getSingleSiteConfigurables(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        ManagedObjectReference remoteSite = local ? serversData.getLocalPair().pairServerVmomiRef() : serversData.getRemotePair().pairServerVmomiRef();
        Promise localMappingsPromise = PCUtil.retrieveProperties((ServersView)serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{MappingsConverter.getFilterSpec(remoteSite)}).thenCompose(localPcResult -> this.convertMappings((PcResult)localPcResult, local));
        return localMappingsPromise.thenApply(Collections::singletonList);
    }

    private Promise<IeMappings> convertMappings(PcResult pcResult, boolean local) {
        ManagedObjectReference inventoryMapper = MappingsConverter.getInventoryMapper(pcResult, "DrInventoryMapper");
        InventoryMapperBase.FolderMapping[] localFolders = (InventoryMapperBase.FolderMapping[])pcResult.getProperty(inventoryMapper, "folderMappings");
        InventoryMapperBase.ResourcePoolMapping[] localResources = (InventoryMapperBase.ResourcePoolMapping[])pcResult.getProperty(inventoryMapper, "resourcePoolMappings");
        InventoryMapperBase.NetworkMapping[] localNetworks = (InventoryMapperBase.NetworkMapping[])pcResult.getProperty(inventoryMapper, "networkMappings");
        InventoryMapperBase.StorageProfileMapping[] localStorageProfiles = (InventoryMapperBase.StorageProfileMapping[])pcResult.getProperty(inventoryMapper, "storageProfileMappings");
        InventoryMapperBase.TestNetworkMapping[] localTestNetworks = (InventoryMapperBase.TestNetworkMapping[])pcResult.getProperty(inventoryMapper, "testNetworkMappings");
        return this.convertMappings(localNetworks, localFolders, localResources, localStorageProfiles, localTestNetworks, local);
    }

    private Promise<IeMappings> convertMappings(InventoryMapperBase.NetworkMapping[] networks, InventoryMapperBase.FolderMapping[] folders, InventoryMapperBase.ResourcePoolMapping[] resources, InventoryMapperBase.StorageProfileMapping[] storageProfiles, InventoryMapperBase.TestNetworkMapping[] testNetworks, boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        SrmServer pairedSrmServer = local ? (SrmServer)serversData.getRemotePair().server() : (SrmServer)serversData.getLocalPair().server();
        SrmServer localSrmServer = local ? (SrmServer)serversData.getLocalPair().server() : (SrmServer)serversData.getRemotePair().server();
        ServiceInstanceContent pairedContent = local ? serversData.getRemoteContent() : serversData.getLocalContent();
        return this.convertNetworks((SrmService)pairedSrmServer.service(), pairedContent, networks).thenCombine(this.convertStorageProfiles(storageProfiles, pairedSrmServer.vc().spbmService(), localSrmServer.vc().spbmService()), (convertedNetworks, convertedStorageProfiles) -> MappingsConverter.fromVmodl(folders, resources, testNetworks, local, convertedNetworks, convertedStorageProfiles));
    }

    private Promise<IeNetworkMapping[]> convertNetworks(SrmService srmService, ServiceInstanceContent content, InventoryMapperBase.NetworkMapping[] mappings) {
        if (srmService == null) {
            return Promises.resolve((Object)new IeNetworkMapping[0]);
        }
        return MappingUtil.getIpSubnetMapper(srmService, content).thenCompose(ipSubnetMapper -> {
            FuturePromise ipSubnetMappingsFp = new FuturePromise();
            ipSubnetMapper.getIpSubnetMappings((Future)ipSubnetMappingsFp);
            return ipSubnetMappingsFp.thenApply(ipSubnetMappings -> NetworkMappingsConverter.fromVmodl(mappings, ipSubnetMappings));
        });
    }

    private Promise<IeStorageProfileMapping[]> convertStorageProfiles(InventoryMapperBase.StorageProfileMapping[] mappings, SpbmService pairedSpbmService, SpbmService localSpbmService) {
        return MappingUtil.getProfiles(pairedSpbmService).thenCombine(MappingUtil.getProfiles(localSpbmService), (pairedProfiles, localProfiles) -> StorageProfileMappingsConverter.fromVmodl(mappings, pairedProfiles, localProfiles));
    }
}

