/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.srm.client.infrastructure.authentication.data.RemoteLoginQueryData;
import com.vmware.srm.client.infrastructure.authentication.data.RemoteLoginQueryRequestData;
import com.vmware.srm.client.infrastructure.http.SerializationUtil;
import com.vmware.srm.client.infrastructure.oauth2.OAuth2VapiUtils;
import com.vmware.srm.client.infrastructure.requestHandlers.DrInputType;
import com.vmware.srm.client.infrastructure.requestHandlers.FreeRequestHandler;
import com.vmware.srm.client.infrastructure.requestHandlers.context.FreeRequestContext;
import com.vmware.srm.client.infrastructure.requestHandlers.protocol.DrData;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.http.AsyncHttpUtils;
import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.sso.CertificateUtils;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.SslTrust;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.Collection;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@DrInputType(value=RemoteLoginQueryRequestData.class)
public class RemoteLoginQueryDataHandler
implements FreeRequestHandler {
    private static final String REMOTE_LOGIN_QUERY_PATH = "/dr/remotelogin/oauth2/query";
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLoginQueryDataHandler.class);
    private final boolean _extRemoteLoginEnabled = Config.get().getExtRemoteLoginEnabled();

    @Override
    public Promise<? extends DrData> handle(DrData input, FreeRequestContext context) {
        RemoteLoginQueryRequestData inputData = (RemoteLoginQueryRequestData)input;
        Object view = context.view();
        return this.isRemoteLoginSupported((ServersView)view, inputData).thenApply(RemoteLoginQueryData::new);
    }

    private Promise<Boolean> isRemoteLoginSupported(ServersView view, RemoteLoginQueryRequestData inputData) {
        if (!this._extRemoteLoginEnabled) {
            return Promises.resolve((Object)false);
        }
        Promise srmRequest = null;
        Promise hmsRequest = null;
        if (inputData.getSrmGuid() != null) {
            srmRequest = this.findPair(view, inputData.getSrmGuid(), inputData.getRemoteSrmGuid()).thenCompose(ps -> this.getSrmVmomiEndpoint(ps.pairLsppUrl(), ps.pairLsppThumbprint(), inputData.getRemoteSrmGuid())).thenCompose(this::checkRemoteLoginSupported).materialize().thenApply(pr -> {
                if (pr.isSuccessful()) {
                    return (Boolean)pr.getResult();
                }
                LOGGER.warn("Unable to determine remote login support for SRM {}.", (Object)inputData.getSrmGuid(), (Object)pr.getError());
                return false;
            });
        }
        if (inputData.getHmsGuid() != null) {
            hmsRequest = this.findPair(view, inputData.getHmsGuid(), inputData.getRemoteHmsGuid()).thenCompose(ps -> this.getHmsVmomiEndpoint(ps.pairLsppUrl(), ps.pairLsppThumbprint(), inputData.getRemoteHmsGuid())).thenCompose(this::checkRemoteLoginSupported).materialize().thenApply(pr -> {
                if (pr.isSuccessful()) {
                    return (Boolean)pr.getResult();
                }
                LOGGER.warn("Unable to determine remote login support for HMS {}.", (Object)inputData.getHmsGuid(), (Object)pr.getError());
                return false;
            });
        }
        Promise result = srmRequest != null && hmsRequest != null ? Promises.anyOf((Promise[])new Promise[]{srmRequest, hmsRequest}) : (srmRequest != null ? srmRequest : (Promise)Objects.requireNonNull(hmsRequest));
        return result;
    }

    private Promise<Boolean> checkRemoteLoginSupported(LsppServiceEndpoint vmomiEp) {
        URI queryUri;
        KeyStore trustStore;
        try {
            trustStore = CertificateUtils.createTrustStore((Collection)vmomiEp.getCertificates());
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to create trust store for {}", (Object)vmomiEp, (Object)exc);
            return Promises.reject((Exception)exc);
        }
        trustStore = (KeyStore)SslTrust.get((KeyStore)trustStore).second();
        try {
            queryUri = Config.createAppUrl((String)vmomiEp.url.getHost(), (int)443).resolve(REMOTE_LOGIN_QUERY_PATH);
        }
        catch (URISyntaxException e) {
            return Promises.reject((Exception)e);
        }
        return this.checkRemoteLoginSupported(queryUri, trustStore);
    }

    private Promise<Boolean> checkRemoteLoginSupported(URI queryUri, KeyStore trustStore) {
        return AsyncHttpUtils.doGet((URI)queryUri, (KeyStore)trustStore, null).thenCompose(response -> {
            RemoteLoginQueryData data;
            byte[] content;
            HttpStatus status = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (status != HttpStatus.OK) {
                LOGGER.warn("Check for {} failed: {}.", (Object)queryUri, (Object)response.getStatusLine());
                return Promises.resolve((Object)false);
            }
            try {
                content = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            catch (Exception e) {
                return Promises.reject((Exception)e);
            }
            try {
                data = SerializationUtil.fromByteArray(content, RemoteLoginQueryData.class);
            }
            catch (IOException e) {
                return Promises.reject((Exception)e);
            }
            return Promises.resolve((Object)data.isSupported());
        });
    }

    Promise<LsppServiceEndpoint> getSrmVmomiEndpoint(URI lsppUrl, String thumbprint, String pairServerGuid) {
        return OAuth2VapiUtils.getSrmByGuid(lsppUrl, thumbprint, pairServerGuid).thenApply(srmReg -> LsppHelper.getVmomiEndpoint((LsppService)srmReg, (String)"com.vmware.dr.vcDr")).thenApply(ep -> Objects.requireNonNull(ep, "No vmomi endpoint for srm " + pairServerGuid));
    }

    Promise<LsppServiceEndpoint> getHmsVmomiEndpoint(URI lsppUrl, String thumbprint, String pairServerGuid) {
        return OAuth2VapiUtils.getHmsByGuid(lsppUrl, thumbprint, pairServerGuid).thenApply(hmsReg -> LsppHelper.getVmomiEndpoint((LsppService)hmsReg, (String)"com.vmware.vim.hms")).thenApply(ep -> Objects.requireNonNull(ep, "No vmomi endpoint for hms " + pairServerGuid));
    }

    private Promise<PairSetupImpl<?>> findPair(ServersView view, String serverGuid, String pairServerGuid) {
        return view.getServerBy(serverGuid).thenApply(server -> (ExtensionServer)server).thenCompose(server -> server.getPairs().filter(pairSetup -> pairServerGuid.equals(pairSetup.pairServerGuid())).next().materialize().thenCompose(promiseResult -> {
            if (promiseResult.isSuccessful()) {
                return Promises.resolve((Object)((PairSetupImpl)promiseResult.getResult()));
            }
            Exception cause = promiseResult.getError();
            if (cause instanceof Stream.StreamCompleteException) {
                return Promises.reject((Exception)new ExtensionServer.GetPairFailedException(pairServerGuid));
            }
            return Promises.reject((Exception)cause);
        }));
    }
}

