/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.authentication;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import com.vmware.srm.client.infrastructure.authentication.Credentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAStoreManager.class);
    private static final int BUFFER_SIZE = 1024;
    private final Path _saPath;

    public static byte[] toByteArray(Credentials credentials) {
        byte[] newUserAndSeparator = (credentials.user + ":").getBytes();
        byte[] newPass = Base64.getEncoder().encode(credentials.pass.getBytes());
        byte[] result = Arrays.copyOf(newUserAndSeparator, newUserAndSeparator.length + newPass.length);
        System.arraycopy(newPass, 0, result, newUserAndSeparator.length, newPass.length);
        return result;
    }

    public SAStoreManager(Path saPath) {
        this._saPath = saPath;
    }

    public Promise<Credentials> read() {
        AsynchronousFileChannel channel;
        try {
            channel = AsynchronousFileChannel.open(this._saPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read SA store {}.", (Object)this._saPath, (Object)e);
            return Promises.reject((Exception)e);
        }
        FilePromise<FileLock> lockPromise = new FilePromise<FileLock>();
        channel.lock(channel, lockPromise);
        return lockPromise.thenCompose(unusedLock -> this.readFromChannel(channel, ByteBuffer.allocate(1024), new ByteArrayOutputStream(), 0L)).thenApply(out -> {
            try {
                String[] both = out.toString().split(":");
                if (both.length != 2) {
                    throw new IllegalStateException("SA store");
                }
                Credentials credentials = new Credentials(both[0], new String(Base64.getDecoder().decode(both[1])));
                return credentials;
            }
            finally {
                this.closeChannel(channel);
            }
        });
    }

    public Promise<Credentials> update(Credentials knownCredentials, Function<Credentials, Promise<Credentials>> updater) {
        AsynchronousFileChannel channel;
        try {
            channel = AsynchronousFileChannel.open(this._saPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read SA store {}.", (Object)this._saPath, (Object)e);
            return Promises.reject((Exception)e);
        }
        FilePromise<FileLock> lockPromise = new FilePromise<FileLock>();
        channel.lock(channel, lockPromise);
        return lockPromise.thenCompose(unusedLock -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteBuffer bb = ByteBuffer.allocate(1024);
            return this.readFromChannel(channel, bb, out, 0L);
        }).thenCompose(out -> {
            Promise updatedPromise;
            String pass;
            String user;
            try {
                String[] both = out.toString().split(":");
                if (both.length != 2) {
                    throw new IllegalStateException("SA store");
                }
                user = both[0];
                pass = new String(Base64.getDecoder().decode(both[1]));
            }
            catch (Exception exc) {
                this.closeChannel(channel);
                return Promises.reject((Exception)exc);
            }
            Credentials readCredentials = new Credentials(user, pass);
            if (!readCredentials.equals(knownCredentials)) {
                this.closeChannel(channel);
                return Promises.resolve((Object)readCredentials);
            }
            try {
                updatedPromise = Objects.requireNonNull((Promise)updater.apply(readCredentials), "Updater.get");
            }
            catch (Exception exc) {
                updatedPromise = Promises.reject((Exception)exc);
            }
            return updatedPromise.materialize().thenCompose(pr -> {
                ByteBuffer bb;
                if (!pr.isSuccessful()) {
                    LOGGER.warn("SA updater failed.", (Throwable)pr.getError());
                    this.closeChannel(channel);
                    return Promises.reject((Exception)pr.getError());
                }
                Credentials updatedCredentials = (Credentials)pr.getResult();
                try {
                    byte[] serialCredentials = SAStoreManager.toByteArray(updatedCredentials);
                    bb = ByteBuffer.allocate(serialCredentials.length);
                    bb.put(serialCredentials).flip();
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to process new SA credentials.", (Throwable)exc);
                    this.closeChannel(channel);
                    return Promises.reject((Exception)exc);
                }
                try {
                    channel.truncate(bb.limit());
                }
                catch (IOException ioExc) {
                    LOGGER.warn("Failed to truncate SA store {}", (Object)this._saPath, (Object)ioExc);
                    this.closeChannel(channel);
                    return Promises.reject((Exception)ioExc);
                }
                return this.writeToChannel(channel, bb, 0L).thenApply(unused -> {
                    this.closeChannel(channel);
                    return (Credentials)pr.getResult();
                });
            });
        });
    }

    private Promise<ByteArrayOutputStream> readFromChannel(AsynchronousFileChannel channel, ByteBuffer bb, ByteArrayOutputStream out, long position) {
        FilePromise<Integer> readPromise = new FilePromise<Integer>();
        channel.read(bb, position, channel, readPromise);
        return readPromise.thenCompose(bytesRead -> {
            if (bytesRead == -1) {
                return Promises.resolve((Object)out);
            }
            out.write(bb.array(), 0, bb.position());
            bb.clear();
            return this.readFromChannel(channel, bb, out, position + (long)bytesRead.intValue());
        });
    }

    private Promise<Void> writeToChannel(AsynchronousFileChannel channel, ByteBuffer bb, long position) {
        FilePromise<Integer> writePromise = new FilePromise<Integer>();
        channel.write(bb, position, channel, writePromise);
        return writePromise.thenCompose(written -> {
            if (bb.hasRemaining()) {
                return this.writeToChannel(channel, bb, position + (long)written.intValue());
            }
            return Promises.resolve(null);
        });
    }

    private void closeChannel(AsynchronousFileChannel channel) {
        try {
            channel.close();
        }
        catch (IOException ioExc) {
            LOGGER.warn("Failed to close SA store {}", (Object)this._saPath, (Object)ioExc);
        }
    }

    private class FilePromise<T>
    extends PromiseImpl<T>
    implements CompletionHandler<T, AsynchronousFileChannel> {
        private FilePromise() {
        }

        @Override
        public final void completed(T result, AsynchronousFileChannel channel) {
            this.setResult(result);
        }

        @Override
        public final void failed(Throwable exc, AsynchronousFileChannel channel) {
            LOGGER.warn("Unable to acquire lock for SA store {}.", (Object)SAStoreManager.this._saPath, (Object)exc);
            try {
                SAStoreManager.this.closeChannel(channel);
            }
            finally {
                this.setError(Exceptions.wrap((Throwable)exc));
            }
        }
    }
}

