/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.exporters.replications;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.reactive.impl.Streams;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.availability.hms.HmsServer;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.vim.binding.hms.Group;
import com.vmware.vim.binding.hms.ReplicationManager;
import com.vmware.vim.binding.hms.ServiceInstanceContent;
import com.vmware.vim.binding.hms.VirtualMachine;
import com.vmware.vim.binding.hms.remote.ServerInfo;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vr.client.impex.configurables.replications.IeDatastorePath;
import com.vmware.vr.client.impex.configurables.replications.IeDisk;
import com.vmware.vr.client.impex.configurables.replications.IeReplicationGroup;
import com.vmware.vr.client.impex.configurables.replications.IeStorageProfile;
import com.vmware.vr.client.impex.configurables.replications.IeVmInfo;
import com.vmware.vr.client.impex.exporters.SingleSiteExporter;
import com.vmware.vr.client.impex.tool.HmsServersDataWrapper;
import com.vmware.vr.client.impex.tool.ImpexExportHmsContext;
import com.vmware.vr.client.impex.utils.DataStoreUtil;
import com.vmware.vr.client.impex.utils.HmsUtil;
import com.vmware.vr.client.impex.utils.MappingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationGroupsExporter
extends SingleSiteExporter<IeReplicationGroup> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationGroupsExporter.class);

    public ReplicationGroupsExporter(boolean isRobo) {
        super(isRobo);
    }

    @Override
    protected Promise<List<IeReplicationGroup>> getSingleSiteConfigurables(boolean local) {
        HmsServersDataWrapper serversData = ImpexExportHmsContext.getServersDataWrapper();
        HmsService localHmsService = local ? (HmsService)((HmsServer)serversData.getLocalPair().server()).service() : (HmsService)((HmsServer)serversData.getRemotePair().server()).service();
        HmsServer localHmsServer = local ? (HmsServer)serversData.getLocalPair().server() : (HmsServer)serversData.getRemotePair().server();
        HmsServer remoteHmsServer = local ? (HmsServer)serversData.getRemotePair().server() : (HmsServer)serversData.getLocalPair().server();
        String remoteGuid = remoteHmsServer.guid();
        ServiceInstanceContent localServiceContent = local ? serversData.getLocalContent() : serversData.getRemoteContent();
        VcServer localVc = localHmsServer.vc();
        VcServer remoteVc = remoteHmsServer.vc();
        ReplicationManager replicationManager = (ReplicationManager)localHmsService.createStub(localServiceContent.getReplicationManager());
        Promise pagesPromise = localHmsServer.getPairByGuid(remoteGuid).thenCompose(server -> HmsUtil.getVmInfoPage(replicationManager, server.pairServerVmomiRef(), 0, 20).thenCompose(vmInfoPage -> this.getInfoPages(replicationManager, vmInfoPage.totalCount, server.pairServerVmomiRef())));
        Promise<Profile[]> profilesPromise = MappingUtil.getProfiles(remoteVc.spbmService());
        return pagesPromise.thenCompose(pages -> profilesPromise.thenCompose(profiles -> Streams.from((Collection)pages.stream().peek(nil -> LOGGER.info("Total pages :" + pages.size())).collect(Collectors.toList())).flatMap(vmInfoPage -> this.getIeReplicationGroupPromises(localHmsService, local, (Profile[])profiles, localVc, remoteVc, (ReplicationManager.VmInfoPage)vmInfoPage)).filter(CollectionUtils::isNotEmpty).reduce(new ArrayList(), (list, next) -> {
            list.addAll(next);
            return list;
        }).thenApply(groups -> {
            if (groups.isEmpty()) {
                LOGGER.warn(this.getErrorMessageForReplicationGroup(localVc, remoteVc, (Profile[])profiles));
            }
            return groups;
        })));
    }

    private String getErrorMessageForReplicationGroup(VcServer localVc, VcServer remoteVc, Profile[] profiles) {
        StringBuilder message = new StringBuilder("No outgoing replication group is found.\n");
        message.append(" Local VC:").append(localVc.guid()).append(" ").append(localVc.url()).append("\n");
        message.append(" Remote VC:").append(remoteVc.guid()).append(" ").append(remoteVc.url()).append("\n");
        message.append(" Profiles:").append("\n");
        Arrays.stream(profiles).forEach(profile -> message.append("   ").append(profile.getName()).append("\n"));
        return message.toString();
    }

    private Promise<Collection<ReplicationManager.VmInfoPage>> getInfoPages(ReplicationManager replicationManager, int count, ManagedObjectReference serverRef) {
        return Streams.from((Collection)Stream.iterate(0, index -> index + 20).limit(count / 20 + 1).map(index -> Integer.min(index, count)).peek(index -> LOGGER.info("Export vm info at {}/{}", index, (Object)count)).collect(Collectors.toList())).flatMap(index -> HmsUtil.getVmInfoPage(replicationManager, serverRef, index, 20)).collect();
    }

    private Promise<Collection<IeReplicationGroup>> getIeReplicationGroupPromises(HmsService localHmsService, boolean local, Profile[] profiles, VcServer localVc, VcServer remoteVc, ReplicationManager.VmInfoPage vmInfoPage) {
        VirtualMachine.Info[] vms = vmInfoPage.getVms();
        if (null == vms || vms.length == 0) {
            LOGGER.info("No outgoing replication group is found.");
            return Promises.resolve((Object)Collections.EMPTY_LIST);
        }
        return Streams.from((Collection)Arrays.stream(vms).collect(Collectors.toList())).flatMap(vmInfo -> this.getIeReplicationGroupFromVmInfo(localHmsService, local, profiles, localVc, remoteVc, (VirtualMachine.Info)vmInfo)).filter(Objects::nonNull).collect();
    }

    private Promise<IeReplicationGroup> getIeReplicationGroupFromVmInfo(HmsService localHmsService, boolean local, Profile[] profiles, VcServer localVc, VcServer remoteVc, VirtualMachine.Info info) {
        Group group = (Group)localHmsService.createStub(info.getGroup());
        Promise<Group.ExtendedInfo> groupExtendedInfoPromise = ReplicationGroupsExporter.getGroupExtendedInfo(group);
        Promise<IeVmInfo> vmInfoPromise = this.createIeVmInfo((VirtualMachine.VcReplicationVmInfo)info, profiles, localVc, remoteVc);
        return groupExtendedInfoPromise.thenCombine(vmInfoPromise, (extendedInfo, vmInfo) -> {
            LOGGER.debug("Found replication group '{}'.", (Object)extendedInfo.getSettings().getName());
            ServerInfo hbr = extendedInfo.getHbr();
            return new IeReplicationGroup(local, hbr, extendedInfo.getSettings(), (IeVmInfo)vmInfo);
        }).onError(ex -> LOGGER.error("Failed to get group setting: ", (Throwable)ex));
    }

    public static Promise<Group.ExtendedInfo> getGroupExtendedInfo(Group group) {
        FuturePromise groupInfoFuturePromise = new FuturePromise();
        group.getExtendedInfo((Future)groupInfoFuturePromise);
        return groupInfoFuturePromise.onError(ex -> LOGGER.error("Failed to get group info page: ", (Throwable)ex));
    }

    private Promise<IeVmInfo> createIeVmInfo(VirtualMachine.VcReplicationVmInfo replicationInfo, Profile[] profiles, VcServer localVc, VcServer remoteVc) {
        String vmId = ImpexExportHmsContext.getIdBuilder().buildId(new ManagedObjectReference(HmsUtil.getVmodlTypeName(VirtualMachine.class), replicationInfo.getVm().getValue(), localVc.guid()));
        String dsId = ImpexExportHmsContext.getIdBuilder().buildId(new ManagedObjectReference(HmsUtil.getVmodlTypeName(Datastore.class), replicationInfo.getConfigFileLocation().getDatastore().getValue(), remoteVc.guid()));
        Promise<String> dsTypePromise = DataStoreUtil.getDatastoreType(remoteVc, replicationInfo.configFileLocation.getDatastore().getValue());
        Promise friendlyNamePromise = dsTypePromise.thenCompose(type -> DataStoreUtil.getFolderFriendlyNameByPath(remoteVc, replicationInfo.getConfigFileLocation().getDatastore().getValue(), replicationInfo.getConfigFileLocation().getPath(), type, false));
        Promise configFileLocationPromise = dsTypePromise.thenCombine(friendlyNamePromise, (dsType, friendlyName) -> new IeDatastorePath(dsId, (String)dsType, replicationInfo.getConfigFileLocation().getPath(), (String)friendlyName, replicationInfo.getConfigFileLocation().getFileName()));
        IeStorageProfile ieStorageProfile = replicationInfo.getStorageProfileId() == null ? null : new IeStorageProfile(replicationInfo.getStorageProfileId().getUniqueId(), this.getStorageProfileNameById(profiles, replicationInfo.getStorageProfileId().getUniqueId()));
        Promise<Collection<IeDisk>> disksPromises = this.createDisks(replicationInfo, profiles, remoteVc);
        return disksPromises.thenCombine(configFileLocationPromise, (disks, configFileLocation) -> new IeVmInfo(vmId, (IeDatastorePath)configFileLocation, (List<IeDisk>)new ArrayList<IeDisk>((Collection<IeDisk>)disks), replicationInfo.getExcludedDisks(), ieStorageProfile));
    }

    private Promise<Collection<IeDisk>> createDisks(VirtualMachine.VcReplicationVmInfo replicationInfo, Profile[] profiles, VcServer remoteVc) {
        return Streams.just((Object[])replicationInfo.getDisks()).flatMap(disk -> {
            IeStorageProfile diskStorageProfile = Optional.ofNullable(disk.getStorageProfileId()).map(profileId -> new IeStorageProfile(disk.getStorageProfileId().getUniqueId(), this.getStorageProfileNameById(profiles, disk.getStorageProfileId().getUniqueId()))).orElse(null);
            String dsId = ImpexExportHmsContext.getIdBuilder().buildId(new ManagedObjectReference(HmsUtil.getVmodlTypeName(Datastore.class), disk.getDestination().getDatastore().getValue(), remoteVc.guid()));
            Promise<String> dsTypePromise = DataStoreUtil.getDatastoreType(remoteVc, disk.getDestination().getDatastore().getValue());
            Promise friendlyNamePromise = dsTypePromise.thenCompose(dsType -> DataStoreUtil.getFolderFriendlyNameByPath(remoteVc, disk.getDestination().getDatastore().getValue(), disk.getDestination().getPath(), dsType, false));
            return dsTypePromise.thenCombine(friendlyNamePromise, (dsType, friendlyName) -> new IeDisk(disk.getDeviceKey(), new IeDatastorePath(dsId, (String)dsType, disk.getDestination().getPath(), (String)friendlyName, disk.getDestination().getFileName()), diskStorageProfile, disk.getVirtualDiskType(), disk.isSkipDiskUuidValidation()));
        }).collect();
    }

    private String getStorageProfileNameById(Profile[] profiles, String profileId) {
        return Arrays.stream(profiles).filter(profile -> profile.getProfileId().getUniqueId().equals(profileId)).findFirst().orElseThrow(() -> new RuntimeException("Failed to Storage Profile name by id: " + profileId)).getName();
    }
}

