/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vr.client.impex.tool.io;

import com.vmware.vr.client.impex.tool.io.ConsoleIOHelper;
import com.vmware.vr.client.impex.tool.io.IOHelper;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardIOHelper
implements IOHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleIOHelper.class);
    private final PrintStream _printer;
    private final Scanner _scanner;

    public StandardIOHelper(InputStream reader, PrintStream printer) {
        this._scanner = new Scanner(reader);
        this._printer = printer;
    }

    @Override
    public void writeln(String message) {
        LOGGER.info(message);
        this._printer.println(message);
    }

    @Override
    public String readln(String message) {
        LOGGER.info(message);
        this._printer.println(message);
        String input = this._scanner.nextLine();
        LOGGER.info("Input: " + input);
        return input;
    }

    @Override
    public String readPass(String message) {
        LOGGER.info(message);
        return this.readln(message);
    }
}

