/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.Promises;
import com.vmware.dr.ui.tools.utilities.RotationManager;
import com.vmware.srm.client.topology.impl.common.Utils;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.BaseNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LocalLsppNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.LsppConsistencyWatcher;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.TokenProviderImpl;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.LsppHelper;
import com.vmware.srm.client.topology.impl.lspp.LsppNegotiator;
import com.vmware.srm.client.topology.impl.lspp.Types;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.sso.FederationStsProxy;
import com.vmware.srm.client.topology.impl.sso.LsppRotationManagerProvider;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang.Validate;

public class BootstrapNode
extends BaseNode
implements LsppConsistencyWatcher.LsppSupplier,
LsppRotationManagerProvider {
    private final LsppNegotiator _ln;
    private final TokenProviderImpl _tokenProvider;
    private volatile Set<LsppService> _ssos = null;

    public BootstrapNode(URI lsppUrl, String lsppThumbprint, X509Certificate certificate, PrivateKey privateKey) {
        Validate.notNull((Object)lsppUrl, (String)"lsppUrl");
        Validate.notNull((Object)certificate, (String)"certificate");
        Validate.notNull((Object)privateKey, (String)"privateKey");
        this._ln = new LsppNegotiator(lsppUrl, lsppThumbprint, null);
        this._tokenProvider = new TokenProviderImpl();
        this._tokenProvider.setSts(FederationStsProxy.create(this, certificate, privateKey));
    }

    @Override
    public Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(NodeContext context) {
        return LsppHelper.listServers(this._ln, Types.LsppType.Sso).materialize().thenCompose(pr -> {
            if (pr.isSuccessful()) {
                return Promises.resolve((Object)pr.getResult());
            }
            Exception cause = pr.getError();
            this.completeView(context.getView(), cause);
            return context.initLocalTokenProvider(this._tokenProvider, cause).thenApply(unused -> Collections.emptyMap());
        }).thenCompose(ssoMap -> {
            Set<LsppService> ssos = ssoMap.getOrDefault((Object)Types.LsppType.Sso, Collections.emptySet());
            LsppConsistencyWatcher watcher = context.getLsppConsistencyWatcher();
            if (watcher.tryAdd(ssos, this)) {
                this._ssos = ssos;
                return context.initLocalTokenProvider(this._tokenProvider, null).thenApply(unused -> Collections.singleton(new LocalLsppNode(ssos, this._tokenProvider)));
            }
            LsppConsistencyWatcher.LsppFederationChangedException federationChanged = new LsppConsistencyWatcher.LsppFederationChangedException(this.getLsppUrl());
            this.completeView(context.getView(), federationChanged);
            return context.initLocalTokenProvider(this._tokenProvider, federationChanged).thenApply(unused -> Collections.emptySet());
        });
    }

    @Override
    public RotationManager<LsppService> getManager() {
        return new RotationManager(this._ssos);
    }

    @Override
    public URI getLsppUrl() {
        return this._ln.getUrl();
    }

    @Override
    public void dispose() {
        ScheduledExecutorService exec = Utils.getScheduledExecutor();
        exec.execute(() -> {
            this._ln.close();
            this._tokenProvider.dispose();
        });
    }

    private void completeView(ServersViewImpl view, Exception exc) {
        view.getLocalPublisher().complete(exc);
    }
}

