/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CspBuilder {
    private static final String DEFAULT_SRC = "default-src";
    private static final String SCRIPT_SRC = "script-src";
    private static final String STYLE_SRC = "style-src";
    private static final String IMG_SRC = "img-src";
    private static final String FONT_SRC = "font-src";
    private static final String MEDIA_SRC = "media-src";
    private static final String CONNECT_SRC = "connect-src";
    private static final String FRAME_SRC = "frame-src";
    private static final String OBJECT_SRC = "object-src";
    private final SrcWrapper _defaultSrcEntries = new SrcWrapper("default-src");
    private final SrcWrapper _scriptSrcEntries = new SrcWrapper("script-src");
    private final SrcWrapper _styleSrcEntries = new SrcWrapper("style-src");
    private final SrcWrapper _imgSrcEntries = new SrcWrapper("img-src");
    private final SrcWrapper _fontSrcEntries = new SrcWrapper("font-src");
    private final SrcWrapper _mediaSrcEntries = new SrcWrapper("media-src");
    private final SrcWrapper _connectSrcEntries = new SrcWrapper("connect-src");
    private final SrcWrapper _frameSrcEntries = new SrcWrapper("frame-src");
    private final SrcWrapper _objectSrcEntries = new SrcWrapper("object-src");
    private final List<SrcWrapper> _wrappers = new ArrayList<SrcWrapper>();

    public CspBuilder() {
        this._wrappers.add(this._defaultSrcEntries);
        this._wrappers.add(this._scriptSrcEntries);
        this._wrappers.add(this._styleSrcEntries);
        this._wrappers.add(this._imgSrcEntries);
        this._wrappers.add(this._fontSrcEntries);
        this._wrappers.add(this._mediaSrcEntries);
        this._wrappers.add(this._connectSrcEntries);
        this._wrappers.add(this._frameSrcEntries);
        this._wrappers.add(this._objectSrcEntries);
    }

    public SrcWrapper defaultSrc() {
        return this._defaultSrcEntries;
    }

    public SrcWrapper scriptSrc() {
        return this._scriptSrcEntries;
    }

    public SrcWrapper styleSrc() {
        return this._styleSrcEntries;
    }

    public SrcWrapper imgSrc() {
        return this._imgSrcEntries;
    }

    public SrcWrapper fontSrc() {
        return this._fontSrcEntries;
    }

    public SrcWrapper mediaSrc() {
        return this._mediaSrcEntries;
    }

    public SrcWrapper connectSrc() {
        return this._connectSrcEntries;
    }

    public SrcWrapper frameSrc() {
        return this._frameSrcEntries;
    }

    public SrcWrapper objectSrc() {
        return this._objectSrcEntries;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        this._wrappers.stream().map(SrcWrapper::build).forEach(builder::append);
        return builder.toString();
    }

    public static class SrcWrapper {
        private static final String UNSAFE_INLINE = "'unsafe-inline'";
        private static final String UNSAFE_EVAL = "'unsafe-eval'";
        private static final String SELF = "'self'";
        private static final String NONE = "'none'";
        private static final String DATA = "data:";
        private static final String HTTPS = "https:";
        private static final String WSS = "wss:";
        private static final String DELIMITER = " ";
        private static final String TERMINATOR = ";";
        private final Set<String> srcEntries = new HashSet<String>();
        private final String name;

        SrcWrapper(String name) {
            this.name = name;
        }

        public SrcWrapper include(String entry) {
            this.srcEntries.add(entry);
            return this;
        }

        public SrcWrapper includeUnsafeInline() {
            return this.include(UNSAFE_INLINE);
        }

        public SrcWrapper includeUnsafeEval() {
            return this.include(UNSAFE_EVAL);
        }

        public SrcWrapper includeSelf() {
            return this.include(SELF);
        }

        public SrcWrapper includeNone() {
            return this.include(NONE);
        }

        public SrcWrapper includeData() {
            return this.include(DATA);
        }

        public SrcWrapper includeHttps() {
            return this.include(HTTPS);
        }

        public SrcWrapper includeWss() {
            return this.include(WSS);
        }

        public String build() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append(DELIMITER);
            this.srcEntries.forEach(entry -> builder.append((String)entry).append(DELIMITER));
            builder.append(TERMINATOR).append(DELIMITER);
            return builder.toString();
        }
    }
}

