/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi;

import com.vmware.srm.client.topology.client.Topology;
import com.vmware.srm.client.topology.impl.utils.L10N;
import com.vmware.vim.sso.client.SamlToken;
import java.net.URI;
import java.security.PrivateKey;

public interface TokenProvider {
    public boolean isTokenAvailable();

    public SamlToken getToken() throws AuthenticationTokenNotAvailable;

    public PrivateKey getPrivateKey();

    public void login(String var1, String var2) throws TokenExists, AcquireTokenFailed;

    default public void login(SamlToken suToken, SamlToken actAsToken) {
        throw new UnsupportedOperationException();
    }

    public SamlToken acquireDelegatedToken(String var1) throws AuthenticationTokenNotAvailable, AcquireTokenFailed;

    public static class InvalidCredentialsException
    extends AcquireTokenFailed {
        private static final long serialVersionUID = -532589343408308674L;

        public InvalidCredentialsException(Throwable cause) {
            super(L10N.localize("tokenProvider.invalidCreds", new Object[0]), cause);
        }
    }

    public static class TokenExists
    extends Topology.TopologyException {
        private static final long serialVersionUID = -1566643920555789484L;

        public TokenExists(URI url) {
            super(L10N.localize("tokenProvider.tokenExists", url));
        }
    }

    public static class AcquireTokenFailed
    extends Topology.TopologyException {
        private static final long serialVersionUID = -8667341029510876027L;

        public AcquireTokenFailed(URI url, Throwable cause) {
            this(L10N.localize("tokenProvider.acquireFailed", url), cause);
        }

        public AcquireTokenFailed(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AuthenticationTokenNotAvailable
    extends Topology.TopologyException {
        private static final long serialVersionUID = -7241424952567416689L;

        public AuthenticationTokenNotAvailable(URI url) {
            super(L10N.localize("tokenProvider.tokenUnavail", url));
        }
    }
}

