/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi;

import com.vmware.srm.client.topology.impl.init.Config;
import com.vmware.srm.client.topology.impl.vmomi.ssl.DynamicVerifier;
import com.vmware.srm.client.topology.impl.vmomi.vlsi.VlsiClientUtils;
import com.vmware.vim.binding.vmodl.query.version.version1;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.HttpProtocolBinding;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.KeyStore;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class HttpConfigurationManager {
    private static final KeyStore TRUST_STORE = Config.get().getTrustStore();
    private static final Class<? extends Annotation> CLIENTS_VERSION = version1.class;
    private static final URI FAKE_CLIENT_URI = URI.create("https://dr-permanent-client");
    protected final HttpConfiguration _httpConfiguration;
    private final DynamicVerifier _verifier = TRUST_STORE == null ? new DynamicVerifier() : null;
    private final Client _vlsiClient;

    public HttpConfigurationManager() {
        this._httpConfiguration = VlsiClientUtils.createHttpConfig(null, this._verifier, TRUST_STORE);
        HttpClientConfiguration clientConfiguration = VlsiClientUtils.createClientConfig(this._httpConfiguration);
        this._vlsiClient = Client.Factory.createClient((URI)FAKE_CLIENT_URI, CLIENTS_VERSION, (VmodlContext)VmodlContext.createContext((String[])new String[0]), (ClientConfiguration)clientConfiguration);
    }

    public void addThumbprint(String thumbprint) {
        if (TRUST_STORE != null) {
            return;
        }
        this._verifier.addThumbprint(thumbprint);
    }

    public void addThumbprints(KeyStore store) {
        if (TRUST_STORE != null) {
            return;
        }
        this._verifier.addThumbprints(store);
    }

    protected CloseableHttpAsyncClient getHttpClient() {
        HttpProtocolBinding binding = (HttpProtocolBinding)this._vlsiClient.getBinding();
        return (CloseableHttpAsyncClient)binding.getImpl();
    }
}

