/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.vmomi.vlsi.record;

import com.vmware.srm.client.topology.impl.vmomi.vlsi.record.VmomiRecordUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.util.EqualityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;

public class CallRecord {
    private final Method _method;
    private final ManagedObjectReference _thisRef;
    private final Object[] _args;
    private final Object _response;
    private final Exception _fault;
    private final Date _instant;
    private final VmodlContext _context;

    public static void serializeToFile(CallRecord record, File requestDir, VmodlVersion version) {
        requestDir.mkdir();
        Properties methodData = new Properties();
        methodData.setProperty("vmomi-class", record._method.getDeclaringClass().getName());
        methodData.setProperty("vmomi-method", record._method.toString());
        methodData.setProperty("invocation-time", Long.toString(record._instant.getTime()));
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(new File(requestDir, "method-data").toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            methodData.store(os, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            VmomiRecordUtils.serializeVmomiObjectToFile(record._thisRef, new File(requestDir, "this"), record._context, version);
            for (int i = 0; i < record._args.length; ++i) {
                File argFile = new File(requestDir, "arg-" + i);
                VmomiRecordUtils.serializeVmomiObjectToFile(record._args[i], argFile, record._context, version);
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        if (record._fault != null) {
            if (record._fault instanceof MethodFault || record._fault instanceof RuntimeFault) {
                try {
                    VmomiRecordUtils.serializeVmomiObjectToFile(record._fault, new File(requestDir, "vmomi-fault"), record._context, version);
                }
                catch (IOException | XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    VmomiRecordUtils.serializeJavaObjectToFile(record._fault, new File(requestDir, "java-fault"));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            File responseFile = new File(requestDir, "response");
            try {
                VmomiRecordUtils.serializeVmomiObjectToFile(record._response, responseFile, record._context, version);
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CallRecord deserializeFromFile(File requestDir, VmodlContext context, VmodlVersion version) {
        void var14_33;
        Object response;
        ManagedObjectReference thisRef;
        Class<?> moClass;
        Properties methodData = new Properties();
        File methodFile = new File(requestDir, "method-data");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(methodFile.toPath(), new OpenOption[0]));){
            methodData.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            moClass = Class.forName(methodData.getProperty("vmomi-class"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Method method = null;
        String methodName = methodData.getProperty("vmomi-method");
        for (Method m : moClass.getDeclaredMethods()) {
            if (!methodName.equals(m.toString())) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method '" + methodName + "' in class '" + moClass + "' not found");
        }
        long instant = Long.parseLong(methodData.getProperty("invocation-time"));
        try {
            thisRef = (ManagedObjectReference)VmomiRecordUtils.deserializeVmomiObjectFromFile(new File(requestDir, "this"), context, version);
        }
        catch (IOException | ClassNotFoundException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        HashMap<Integer, Object> argsMap = new HashMap<Integer, Object>();
        try {
            DirectoryStream<Path> filesStream = Files.newDirectoryStream(requestDir.toPath(), "arg-*");
            Object object = null;
            try {
                for (Path argPath : filesStream) {
                    File argFile = argPath.toFile();
                    String index = argFile.getName().substring("arg-".length());
                    Object arg = VmomiRecordUtils.deserializeVmomiObjectFromFile(argFile, context, version);
                    argsMap.put(Integer.parseInt(index), arg);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (filesStream != null) {
                    if (object != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        filesStream.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        Object[] args = new Object[argsMap.size()];
        for (Map.Entry entry : argsMap.entrySet()) {
            args[((Integer)entry.getKey()).intValue()] = entry.getValue();
        }
        File responseFile = new File(requestDir, "response");
        if (responseFile.exists()) {
            Object var14_30 = null;
            try {
                response = VmomiRecordUtils.deserializeVmomiObjectFromFile(responseFile, context, version);
            }
            catch (IOException | ClassNotFoundException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        response = null;
        File vmomiFaultFile = new File(requestDir, "vmomi-fault");
        if (vmomiFaultFile.exists()) {
            try {
                Exception exception = (Exception)VmomiRecordUtils.deserializeVmomiObjectFromFile(vmomiFaultFile, context, version);
            }
            catch (IOException | ClassNotFoundException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Exception exception = (Exception)VmomiRecordUtils.deserializeJavaObjectFromFile(new File(requestDir, "java-fault"));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return new CallRecord(method, thisRef, args, response, (Exception)var14_33, new Date(instant), context);
    }

    CallRecord(Method method, ManagedObjectReference thisRef, Object[] args, Object response, Exception fault, Date instant, VmodlContext context) {
        this._method = method;
        this._thisRef = thisRef;
        this._args = args;
        this._response = response;
        this._fault = fault;
        this._instant = instant;
        this._context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallRecord that = (CallRecord)o;
        if (!this._method.equals(that._method)) {
            return false;
        }
        if (!this._thisRef.equals((Object)that._thisRef)) {
            return false;
        }
        if (this._args.length != that._args.length) {
            return false;
        }
        boolean areEqual = true;
        for (int i = 0; areEqual && i < this._args.length; ++i) {
            areEqual = EqualityUtil.areEqual((Object)this._args[i], (Object)that._args[i], (VmodlContext)this._context);
        }
        return areEqual;
    }

    public int hashCode() {
        return Objects.hash(this._method, this._thisRef);
    }

    public String toString() {
        return "CallRecord{_method=" + this._method + ", _thisRef=" + this._thisRef + ", _args=" + Arrays.toString(this._args) + ", _response=" + this._response + ", _fault=" + this._fault + ", _instant=" + this._instant + ", _context=" + this._context + '}';
    }

    public void completeFuture(Future future) {
        if (this._fault == null) {
            future.set(this._response);
        } else {
            future.setException(this._fault);
        }
    }

    public long getInstant() {
        return this._instant.getTime();
    }
}

