/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.Versions;
import emitters.model.Version;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class NsVersionAliases
implements Iterable<Entry> {
    public final Version newestVersion;
    public final Version ltsVersion;
    public final Version dottedVersion;
    public final Version oldestVersion;
    public final int newestVersionIndex;
    public final int ltsVersionIndex;
    public final int dottedVersionIndex;
    public final int oldestVersionIndex;
    private final List<Entry> _list = new ArrayList<Entry>(5);

    NsVersionAliases() {
        List<Version> versionsList = Versions.enumerateVersions();
        ListIterator<Version> it = versionsList.listIterator();
        Version version = it.next();
        int index = 0;
        this.newestVersion = version;
        this.newestVersionIndex = index;
        if (version.getWireNs().equals("vsan")) {
            String id;
            while ((id = version.getWireId()).equals("dev.version") || id.equals("reserved")) {
                version = it.next();
            }
        }
        while (version.getKind() != Version.Kind.LTS) {
            version = it.next();
            ++index;
        }
        this.ltsVersion = version;
        this.ltsVersionIndex = index;
        boolean found = false;
        while (it.hasNext()) {
            String wireId = version.getWireId();
            if (wireId != null && wireId.length() > 2) {
                char first = wireId.charAt(0);
                char second = wireId.charAt(1);
                if (Character.isDigit(first) && second == '.') {
                    found = true;
                    break;
                }
            }
            version = it.next();
            ++index;
        }
        this.dottedVersion = found ? version : this.ltsVersion;
        this.dottedVersionIndex = found ? index : this.ltsVersionIndex;
        it = versionsList.listIterator(versionsList.size());
        this.oldestVersion = it.previous();
        this.oldestVersionIndex = versionsList.size() - 1;
        this._list.add(new Entry("NEWEST", this.newestVersion, this.newestVersionIndex));
        this._list.add(new Entry("LTS", this.ltsVersion, this.ltsVersionIndex));
        this._list.add(new Entry("DOTTED", this.dottedVersion, this.dottedVersionIndex));
        this._list.add(new Entry("OLDEST", this.oldestVersion, this.oldestVersionIndex));
    }

    @Override
    public Iterator<Entry> iterator() {
        return this._list.iterator();
    }

    public static class Entry {
        public final String label;
        public final Version version;
        public final int index;

        public Entry(String label, Version version, int index) {
            this.label = label;
            this.version = version;
            this.index = index;
        }
    }
}

