/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.Utils;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.lists.BuiltIns;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VmodlEmitter {
    protected static final INDENT_ INDENT = null;
    protected static final UNINDENT_ UNINDENT = null;
    private boolean _hideInternalDecls = true;
    private boolean _hideUndocumentedDecls = true;
    private String _filename;
    private StringBuilder _buffer;
    private int _indent;
    private int _indentStackPos;
    private int[] _indentStack = new int[8];
    private boolean _newline;
    private boolean _gap;
    private String[] _indentList = _defaultIndentList;
    protected static final BuiltIns _builtins = new BuiltIns();
    public static Map<String, String> _packageMap = new HashMap<String, String>();
    private static final int MAX_INDENT_LEVEL = 16;
    private static final String[] _defaultIndentList = new String[16];

    protected void setHideInternalDecls(boolean hide) {
        this._hideInternalDecls = hide;
    }

    protected boolean hideInternalDecls() {
        return this._hideInternalDecls;
    }

    protected void setHideUndocumentedDecls(boolean hide) {
        this._hideUndocumentedDecls = hide;
    }

    protected boolean hideUndocumentedDecls() {
        return this._hideUndocumentedDecls;
    }

    protected boolean shouldGenerateFor(Parameter param) {
        Version paramVersion = param.getVersion();
        if (paramVersion == null) {
            return true;
        }
        return Versions.getTargetVersion().isAncestor(paramVersion);
    }

    protected boolean shouldGenerate(VmodlApi vmodlApi) {
        if (this._hideUndocumentedDecls && vmodlApi.isUndocumented()) {
            return false;
        }
        if (this._hideInternalDecls && Versions.isInternalAtTarget(vmodlApi)) {
            return false;
        }
        return Versions.isTargetNewerThan(vmodlApi.getVersion());
    }

    protected boolean shouldGenerateFor(VmodlObject obj, Method method) {
        return this.shouldGenerate(method);
    }

    protected boolean shouldGenerateFor(VmodlObject obj, Property prop) {
        return this.shouldGenerate(prop);
    }

    protected boolean shouldGenerateFor(VmodlObject obj) {
        return this.shouldGenerate(obj);
    }

    protected void beginFile(String filename) {
        if (this._filename != null || this._buffer != null) {
            throw new RuntimeException("beginFile called twice without endFile");
        }
        this._indent = 0;
        this._indentStackPos = 0;
        this._filename = filename;
        this._buffer = new StringBuilder();
        this._newline = true;
        this._gap = true;
    }

    protected void endFile(String filename, StringBuilder builder) {
        if (filename == null || builder == null) {
            throw new RuntimeException("endFile called without beginFile");
        }
        boolean unchanged = false;
        String buffer = builder.toString();
        File file = Platform.getFileHandle(filename);
        int size = (int)file.length();
        if (size == builder.length()) {
            try {
                FileReader reader = new FileReader(file);
                char[] data = new char[size];
                reader.read(data, 0, size);
                reader.close();
                String contents = new String(data);
                if (contents.equals(buffer)) {
                    unchanged = true;
                }
            }
            catch (IOException e) {
                System.err.println("Can't read source '" + filename + "' -- assuming changed");
            }
        }
        if (!unchanged) {
            PrintWriter writer = Platform.createTextFile(new File(filename));
            writer.print(buffer);
            writer.close();
        }
    }

    protected void endFile() {
        this.endFile(this._filename, this._buffer);
        this._buffer = null;
        this._filename = null;
    }

    protected String getFilename() {
        return this._filename;
    }

    protected void setIndentSpaces(String spaces) {
        this._indentList = new String[16];
        VmodlEmitter.initIndentList(this._indentList, spaces);
    }

    protected void indent() {
        ++this._indent;
    }

    protected void unindent() {
        --this._indent;
    }

    protected void pushIndent() {
        this._indentStack[this._indentStackPos++] = this._indent;
    }

    protected void popIndent() {
        this._indent = this._indentStack[--this._indentStackPos];
    }

    private int emitIndents(String s) {
        int tabs;
        if (!this._newline) {
            return 0;
        }
        if (this._indent >= 0) {
            for (tabs = 0; tabs < s.length() && s.charAt(tabs) == '\t'; ++tabs) {
            }
            this._buffer.append(this._indentList[this._indent + tabs]);
        }
        this._newline = false;
        return tabs;
    }

    protected void emitGap() {
        if (!this._gap) {
            this.endLine();
        }
    }

    private void endLine() {
        this._gap = this._newline;
        this._buffer.append("\n");
        this._newline = true;
    }

    protected void emitPartial(String s) {
        int skip = this.emitIndents(s);
        if (skip == 0) {
            this._buffer.append(s);
        } else {
            this._buffer.append(s, skip, s.length());
        }
    }

    protected void emitPartial(String ... strs) {
        if (strs == null) {
            return;
        }
        this.emitPartial(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            this._buffer.append(strs[i]);
        }
    }

    protected void emitLine() {
        this.endLine();
    }

    protected void emitLine(String s) {
        this.emitPartial(s);
        this.endLine();
    }

    protected void emitLine(String s, INDENT_ indent) {
        this.emitLine(s);
        this.indent();
    }

    protected void emitLine(INDENT_ indent, String s) {
        this.indent();
        this.emitLine(s);
    }

    protected void emitLine(UNINDENT_ unindent, String s) {
        this.unindent();
        this.emitLine(s);
    }

    protected void emitLine(String ... strs) {
        this.emitPartial(strs);
        this.endLine();
    }

    protected void emitLine(INDENT_ indent, String ... strs) {
        this.indent();
        this.emitLine(strs);
    }

    public abstract void emitObjects(List<VmodlObject> var1);

    protected static boolean parseOptionalBoolean(String value, boolean default_) {
        return value != null ? Boolean.parseBoolean(value) : default_;
    }

    protected static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    protected static String qq(String s) {
        return "\"" + s + "\"";
    }

    protected static String qb(String s) {
        return "<" + s + ">";
    }

    protected static String qs(String s) {
        return "'" + s + "'";
    }

    public static String join(Collection<?> list, String sep) {
        StringBuilder sbuf = new StringBuilder();
        boolean first = true;
        for (Object elt : list) {
            if (!first) {
                sbuf.append(sep);
            }
            sbuf.append(elt);
            first = false;
        }
        return sbuf.toString();
    }

    protected static String join(Collection<?> list) {
        return VmodlEmitter.join(list, ", ");
    }

    public static String getNamespace(String pkg) {
        ArrayList<String> nsList = new ArrayList<String>();
        for (String ns : pkg.split("[.]")) {
            ns = _packageMap.containsKey(ns) ? _packageMap.get(ns) : Utils.capitalize(ns);
            if (ns.length() <= 0) continue;
            nsList.add(ns);
        }
        return VmodlEmitter.join(nsList, ".");
    }

    protected static boolean isBuiltin(VmodlObject obj) {
        return _builtins.contains(obj.getQualifiedVmodlType());
    }

    private static void initIndentList(String[] list, String spaces) {
        list[0] = "";
        for (int i = 1; i < list.length; ++i) {
            list[i] = list[i - 1] + spaces;
        }
    }

    protected static void insertVersion(List<Version> list, Version version) {
        boolean found = false;
        for (int i = 0; i < list.size(); ++i) {
            Version vPos = list.get(i);
            if (vPos == version) {
                found = true;
                break;
            }
            if (!Versions.isAncestor(vPos, version)) continue;
            list.add(i, version);
            found = true;
            break;
        }
        if (!found) {
            list.add(version);
        }
    }

    static {
        VmodlEmitter.initIndentList(_defaultIndentList, "   ");
    }

    protected static enum UNINDENT_ {

    }

    protected static enum INDENT_ {

    }
}

