/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings;

import emitters.NsVersionAliases;
import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.backend.Platform;
import emitters.bindings.APIAudit;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import vmodl.service;

public class JavaServerEmitter
extends VmodlEmitter {
    private static String DO_TYPE_OPTION = "do.type";
    private static String DO_TYPE_STRUCT = "struct";
    private static String MO_TYPE_OPTION = "mo.type";
    private static String CTX_LOADER_OPTION = "ctx.loader.type";
    private static String HIDE_MOREF_OPTION = "hide.moref";
    private static String DO_PERSISTENCE_OPTION = "do.persistence";
    public static String HIDE_INTERNAL_VERSIONS = "hide.internal.versions";
    public static String HIDE_INTERNAL_DECLS = "hide.internal.declarations";
    private static String BACKWARD_COMPAT = "backward.compat";
    private static final String CORE_BINDING_PACKAGE_NAME = "com.vmware.vim.binding.";
    private static String SECRET_FIELD_VALUE = "(not shown)";
    private static final String KEY_PROP_NAME = "key";
    private final String _packagePrefix;
    private final String _filename;
    private final String _javaVmomiPath;
    private final String _interfacePath;
    private final String _implPath;
    private final String _rootContext;
    private final boolean _structDataObjects;
    private final MoTypeOption _moType;
    private final PersistOption _persistence;
    private final ContextLoaderOption _ctxLoader;
    private final boolean _hideMoRef;
    private final boolean _emitInternalVersions;
    private final List<String> _vmodltypes = new ArrayList<String>();
    private final List<String> _vmodlversions = new ArrayList<String>();
    private final Map<String, String> _dataObjectDefaultImpl = new HashMap<String, String>();
    private final Version _backwardCompatVersion;
    private final boolean _backwardCompatible;
    private final APIAudit _apiAuditingType = APIAudit.initAPIAuditing();
    private static final String WSDL_NAMES_METHOD = "loadWsdlNames";
    private static final String TYPES_METHOD = "loadTypes";
    private static final String DO_NAMES_METHOD = "loadDataObjectNames";
    private static final String DO_TYPES_METHOD = "loadDataObjectTypes";
    private String _servicePrefix;

    public JavaServerEmitter(Map<String, String> options, String packagePrefix) {
        this._packagePrefix = packagePrefix;
        this._javaVmomiPath = this._filename = "java/";
        this._interfacePath = this._javaVmomiPath + "interface/";
        this._implPath = this._javaVmomiPath + "impl/";
        this._rootContext = options.get("root.context");
        if (this._rootContext == null) {
            throw new RuntimeException("root.context option required");
        }
        this._structDataObjects = DO_TYPE_STRUCT.equals(options.get(DO_TYPE_OPTION));
        this._moType = MoTypeOption.parse(options.get(MO_TYPE_OPTION));
        this._persistence = PersistOption.parse(options.get(DO_PERSISTENCE_OPTION));
        this._ctxLoader = ContextLoaderOption.parse(options.get(CTX_LOADER_OPTION));
        this._hideMoRef = Boolean.parseBoolean(options.get(HIDE_MOREF_OPTION));
        this._emitInternalVersions = !Boolean.parseBoolean(options.get(HIDE_INTERNAL_VERSIONS));
        this.setHideInternalDecls(Boolean.parseBoolean(options.get(HIDE_INTERNAL_DECLS)));
        if (options.containsKey(BACKWARD_COMPAT)) {
            String versionName = options.get(BACKWARD_COMPAT);
            this._backwardCompatVersion = Versions.getVersion(versionName);
            this._backwardCompatible = true;
            if (!Versions.getTargetVersion().isAncestor(this._backwardCompatVersion)) {
                throw new RuntimeException("Backward-compat version is newer than target version");
            }
        } else {
            this._backwardCompatVersion = null;
            this._backwardCompatible = false;
        }
        this._servicePrefix = Versions.getVmodlNamespace().toUpperCase().replace('.', '_');
    }

    private boolean showMercyToVsan(VmodlObject object) {
        if ("vsan".equals(Services.getTargetService())) {
            String pkgName = object.getPackage();
            return "vim".equals(pkgName) || pkgName != null && pkgName.startsWith("vim.");
        }
        return false;
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.emitVersions();
        this.emitVersionInfo(false);
        if (this._emitInternalVersions) {
            this.emitVersionInfo(true);
        }
        ArrayList<VmodlObject> filtered = new ArrayList<VmodlObject>(objects.size());
        for (VmodlObject vo : objects) {
            if ((vo.getPackage().equals("vmodl") || !Services.isObjectFromTargetService(vo)) && !this.showMercyToVsan(vo)) continue;
            filtered.add(vo);
        }
        objects = filtered;
        for (VmodlObject obj : objects) {
            this.emitObject(obj);
            this.emitObjectImpl(obj);
        }
        Collections.sort(this._vmodlversions);
        if (this._ctxLoader == ContextLoaderOption.BOTH || this._ctxLoader == ContextLoaderOption.SPRING) {
            this.emitXmlConfigFile(objects, ContextVersion.V1);
            this.emitXmlConfigFile(objects, ContextVersion.V2);
        }
        if (this._ctxLoader == ContextLoaderOption.BOTH || this._ctxLoader == ContextLoaderOption.JAVA) {
            this.emitJavaConfigFile(objects);
        }
    }

    private boolean emitAPIAuditingAnnotations(boolean isDeprecated, boolean isInternal) {
        boolean isAnnotated;
        String annotation = null;
        switch (this._apiAuditingType) {
            case INTERNAL: {
                if (!isInternal) break;
                annotation = "@Deprecated";
                break;
            }
            default: {
                if (!isDeprecated) break;
                annotation = "@Deprecated";
            }
        }
        boolean bl = isAnnotated = annotation != null;
        if (isAnnotated) {
            this.emitLine(annotation);
        }
        return isAnnotated;
    }

    private void emitAPIAuditingAnnotations(VmodlObject obj, Method method) {
        if (!(obj instanceof ManagedObject)) {
            throw new RuntimeException("Data object passed to emit method for " + obj.getQualifiedVmodlType());
        }
        try {
            ManagedObject mobj = (ManagedObject)obj;
            boolean isAnnotated = this.emitAPIAuditingAnnotations(mobj.isDeprecated(), mobj.isInternal());
            if (!isAnnotated) {
                this.emitAPIAuditingAnnotations(method.isDeprecated(), method.isInternal());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to emit deprecated or API auditing annotation: " + e.getMessage());
        }
    }

    private void emitAPIAuditingAnnotations(VmodlObject obj, ManagedProperty inputProp) {
        boolean isAnnotated = this.emitAPIAuditingAnnotations(obj.isDeprecated(), obj.isInternal());
        if (!isAnnotated) {
            VmodlDecl pd = inputProp.getDecl();
            this.emitAPIAuditingAnnotations(pd.isDeprecated(), pd.isInternal());
        }
    }

    private void emitImport(String importPackage) {
        this.emitLine("import " + importPackage + ";");
    }

    private void emitImportVmodl() {
        this.emitImport("com.vmware.vim.binding.vmodl.*");
    }

    private void emitXmlConfigFile(List<VmodlObject> objects, ContextVersion contextVersion) {
        String contextPath = this._interfacePath + this._rootContext.replace('.', '/') + "/context" + contextVersion.getSuffix() + ".xml";
        super.beginFile(contextPath);
        this.emitLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.emitLine("<beans xmlns=\"http://www.springframework.org/schema/beans\"");
        this.indent();
        this.emitLine("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.emitLine("xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">");
        this.unindent();
        this.emitLine("<bean name=\"context\" class=\"com.vmware.vim.vmomi.core.types.impl.VmodlContextLoader\">");
        this.indent();
        if (this._hideMoRef) {
            this.emitLine("<property name=\"hideMoRef\" value=\"true\" />");
        }
        if (contextVersion == ContextVersion.V1) {
            this.emitLine("<property name=\"vmodlTypeContext\">");
            this.indent();
            this.emitLine("<list>");
            this.indent();
            Collections.sort(this._vmodltypes);
            for (String string : this._vmodltypes) {
                this.emitLine("<value>", string, "</value>");
            }
            this.unindent();
            this.emitLine("</list>");
            this.unindent();
            this.emitLine("</property>");
        } else {
            this.emitLine("<property name=\"wsdlNameContext\">");
            this.indent();
            this.emitLine("<map>");
            this.indent();
            for (VmodlObject vmodlObject : objects) {
                this.emitXmlNestedObjects(vmodlObject, vmodlObject);
            }
            this.unindent();
            this.emitLine("</map>");
            this.unindent();
            this.emitLine("</property>");
        }
        this.emitLine("<property name=\"vmodlDataObjects\">");
        this.indent();
        this.emitLine("<map>");
        this.indent();
        for (Map.Entry entry : this._dataObjectDefaultImpl.entrySet()) {
            this.emitLine("<entry key=\"", (String)entry.getKey(), "\" value=\"", (String)entry.getValue(), "\"/>");
        }
        this.unindent();
        this.emitLine("</map>");
        this.unindent();
        this.emitLine("</property>");
        this.emitLine("<property name=\"vmodlVersionContext\">");
        this.indent();
        this.emitLine("<list>");
        this.indent();
        for (String string : this._vmodlversions) {
            this.emitLine("<value>", string, "</value>");
        }
        this.unindent();
        this.emitLine("</list>");
        this.unindent();
        this.emitLine("</property>");
        this.unindent();
        this.emitLine("</bean>");
        this.emitLine("</beans>");
        this.endFile();
    }

    private void emitJavaConfigFile(List<VmodlObject> objects) {
        String path = this._interfacePath + this._rootContext.replace('.', '/') + "/$ContextMetadata.java";
        super.beginFile(path);
        this.emitLine("package ", this._rootContext, ";");
        this.emitLine();
        this.emitLine("import com.vmware.vim.vmomi.core.types.impl.VmodlContextMetadata;");
        this.emitLine();
        this.emitLine("public class $ContextMetadata extends VmodlContextMetadata {");
        this.indent();
        this.emitLine("public $ContextMetadata() {");
        this.indent();
        this.emitLine("version = 1;");
        if (this._hideMoRef) {
            this.emitLine("hideMoRef = true;");
            this.emitLine();
        }
        this.emitAsArray("versions", this._vmodlversions);
        this.emitLine();
        this.emitMethodCall(WSDL_NAMES_METHOD);
        this.emitMethodCall(TYPES_METHOD);
        this.emitMethodCall(DO_NAMES_METHOD);
        this.emitMethodCall(DO_TYPES_METHOD);
        this.unindent();
        this.emitLine("}");
        this.emitMethodStart(WSDL_NAMES_METHOD);
        ArrayList<Integer> numberOfClasses = new ArrayList<Integer>(objects.size());
        this.emitStringArrayInitialization("wsdlNames");
        for (VmodlObject vo : objects) {
            numberOfClasses.add(this.emitJavaNestedObjectsWsdlName(vo));
        }
        this.emitArrayClosing();
        this.emitMethodEnd();
        this.emitMethodStart(TYPES_METHOD);
        this.emitStringArrayInitialization("types");
        for (int i = 0; i < objects.size(); ++i) {
            VmodlObject vo;
            vo = objects.get(i);
            Integer voClasses = (Integer)numberOfClasses.get(i);
            for (int j = 0; j < voClasses; ++j) {
                this.emitArrayElement(this._packagePrefix, ".", vo.getPackage(), ".", vo.getClassName());
            }
        }
        this.emitArrayClosing();
        this.emitMethodEnd();
        this.emitMethodStart(DO_NAMES_METHOD);
        ArrayList<String> doTypes = new ArrayList<String>(this._dataObjectDefaultImpl.size());
        this.emitStringArrayInitialization("dataObjectNames");
        for (Map.Entry<String, String> entry : this._dataObjectDefaultImpl.entrySet()) {
            this.emitArrayElement(entry.getKey());
            doTypes.add(entry.getValue());
        }
        this.emitArrayClosing();
        this.emitMethodEnd();
        this.emitMethodStart(DO_TYPES_METHOD);
        this.emitAsArray("dataObjectTypes", doTypes);
        this.emitMethodEnd();
        this.unindent();
        this.emitLine("}");
        this.endFile();
    }

    private void emitMethodStart(String name) {
        this.emitLine();
        this.emitLine("private void ", name, "() {");
        this.indent();
    }

    private void emitMethodEnd() {
        this.unindent();
        this.emitLine("}");
    }

    private void emitMethodCall(String name) {
        this.emitLine(name, "();");
    }

    private int emitJavaNestedObjectsWsdlName(VmodlObject vo) {
        int count = 1;
        this.emitArrayElement(vo.getWsdlName());
        for (VmodlObject nestedObj : vo.getNestedList()) {
            count += this.emitJavaNestedObjectsWsdlName(nestedObj);
        }
        return count;
    }

    private void emitAsArray(String name, Iterable<String> strings) {
        this.emitStringArrayInitialization(name);
        for (String str : strings) {
            this.emitArrayElement(str);
        }
        this.emitArrayClosing();
    }

    private void emitArrayElement(String ... strings) {
        this.emitPartial("\"");
        this.emitPartial(strings);
        this.emitLine("\", ");
    }

    private void emitStringArrayInitialization(String name) {
        this.emitLine(name, " = new String[] {");
        this.indent();
    }

    private void emitArrayClosing() {
        this.unindent();
        this.emitLine(" };");
        this.emitLine();
    }

    private void emitXmlNestedObjects(VmodlObject outerObj, VmodlObject currObj) {
        this.emitLine("<entry key=\"", currObj.getWsdlName(), "\" value=\"", this._packagePrefix, ".", outerObj.getPackage(), ".", outerObj.getClassName(), "\"/>");
        for (VmodlObject nestedObj : currObj.getNestedList()) {
            this.emitXmlNestedObjects(outerObj, nestedObj);
        }
    }

    private void emitVersion(Version ver, boolean internal) {
        String packageName = ver.getPackage();
        String wireNs = ver.getWireNs();
        service svc = null;
        try {
            svc = Services.getService(ver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (internal) {
            packageName = packageName + ".internal";
        }
        if (svc != null && !ver.getWireNs().isEmpty() && !svc.namespace().equals(wireNs)) {
            System.out.println(String.format("WARNING: Inconsistent version @wsdlName with the service namespace for %1$s.%2$s", packageName, ver.getSimpleName()));
        }
        String packagePath = this.wrapPackageName(packageName).replace('.', '/');
        this._vmodlversions.add(this.wrapPackageName(packageName) + "." + ver.getSimpleName());
        this.beginFile(this._interfacePath + packagePath + "/" + ver.getSimpleName() + ".java");
        this.emitLine("package " + this.wrapPackageName(packageName) + ";");
        this.emitLine("import java.lang.annotation.*;");
        this.emitImportVmodl();
        this.emitLine();
        if (ver.getWireId() != null) {
            this.emitLine("@versionId(\"" + ver.getWireId() + "\")");
        }
        if (ver.getDisplayName() != null) {
            this.emitLine("@displayName(\"" + ver.getDisplayName() + "\")");
        }
        if (wireNs != null && wireNs.length() > 0) {
            if (internal) {
                wireNs = "internal" + wireNs;
            }
            this.emitLine("@wsdlName(\"" + wireNs + "\")");
        }
        if (internal) {
            this.emitLine("@internal");
        }
        if (ver.getDirectParents() != null) {
            int length;
            Set<Version> parents = Versions.getSortedDirectParents(ver);
            if (internal) {
                parents.add(ver);
            }
            if ((length = parents.size()) > 0) {
                this.emitPartial("@compatible({");
                for (Version version : parents) {
                    this.emitPartial(this.wrapPackageName(version.getVmodlName()), ".class");
                    if (--length <= 0) continue;
                    this.emitPartial(", ");
                }
                this.emitLine("})");
            }
        }
        if (svc != null) {
            this.emitPartial("@service(name=\"");
            this.emitPartial(svc.name());
            this.emitPartial("\", namespace=\"");
            this.emitPartial(svc.namespace());
            this.emitLine("\")");
        }
        this.emitLine("@Documented");
        this.emitLine("@Retention(value=RetentionPolicy.RUNTIME)");
        this.emitLine("public @interface " + ver.getSimpleName() + " {}");
        this.endFile();
    }

    private void emitVersions() {
        Collection<Version> versions = Versions.getVersions();
        Version target = Versions.getTargetVersion();
        for (Version ver : versions) {
            if (!target.isAncestor(ver) || !Services.isPackageFromTargetService(ver)) continue;
            this.emitVersion(ver, false);
            if (!this._emitInternalVersions) continue;
            this.emitVersion(ver, true);
        }
    }

    private void emitAnnotations(VmodlDecl decl) {
        if (decl.isLink()) {
            this.emitLine("@link");
            this.emitLine("@linkType(\"", this.resolveClass(decl.getObject(), '$'), "\")");
        }
        if (decl.isLinkable()) {
            this.emitLine("@linkable");
        }
        if (decl.isManaged()) {
            this.emitLine("@managedObjectType(\"", this.resolveManagedObjectType(decl), "\")");
        }
        if (decl.isSecret()) {
            this.emitLine("@secret");
        }
        this.emitCollectionAnnotations(decl, false);
    }

    private void emitAnnotations(VmodlObject obj) {
        if (Versions.isInternalAtTarget(obj)) {
            this.emitLine("@internal");
        }
        this.emitLine("@versionClass(", this.wrapPackageName(obj.getVersion().getVmodlName()), ".class)");
        this.emitLine("@wsdlName(\"", obj.getWsdlName(), "\")");
        this.emitAPIAuditingAnnotations(obj.isDeprecated(), obj.isInternal());
    }

    private void emitAnnotations(VmodlObject parentObject, ManagedProperty obj) {
        this.emitLine("@readonly ");
        this.emitLine("@name(\"", obj.getName(), "\")");
        if (obj.getPrivilegeId() != null) {
            this.emitLine("@privilege(\"", obj.getPrivilegeId(), "\") ");
        }
        this.emitLine("@versionClass(", this.wrapPackageName(obj.getVersion().getVmodlName()), ".class)");
        if (obj.getDecl().isOptional()) {
            this.emitLine("@optional ");
        }
        if (obj.getDecl().isManaged()) {
            this.emitLine("@managedObjectType(\"", this.resolveManagedObjectType(obj.getDecl()), "\") ");
        }
        this.emitCollectionAnnotations(obj.getDecl(), false);
        this.emitAPIAuditingAnnotations(parentObject, obj);
    }

    private void emitAnnotations(Parameter param) {
        this.emitLine("@name(\"", param.getName(), "\") ");
        this.emitLine("@versionClass(", this.wrapPackageName(param.getVersion().getVmodlName()), ".class)");
        if (param.getDecl().isOptional()) {
            this.emitLine("@optional ");
        }
        if (param.getDecl().isManaged()) {
            this.emitLine("@managedObjectType(\"", this.resolveManagedObjectType(param.getDecl()), "\") ");
        }
        if (param.getPrivilegeId() != null) {
            this.emitLine("@privilege(\"", param.getPrivilegeId(), "\")");
        }
        if (param.getDecl().isSecret()) {
            this.emitLine("@secret");
        }
        this.emitCollectionAnnotations(param.getDecl(), false);
    }

    private void emitAnnotations(ManagedObject mo) {
        this.emitLine("@managed");
        this.emitAnnotations((VmodlObject)mo);
        if (mo.isSessionSpecific()) {
            this.emitLine("@sessionSpecific");
        }
    }

    private void emitAnnotations(VmodlObject obj, Property prop) {
        this.emitAnnotations(prop.getDecl());
        if (this.isOptionalProperty(prop.getDecl(), obj.getVersion(), prop.getVersion())) {
            this.emitLine("@optional");
        }
        this.emitLine("@versionClass(", this.wrapPackageName(prop.getVersion().getVmodlName()), ".class)");
        if (prop.getPrivilegeId() != null) {
            this.emitLine("@privilege(\"", prop.getPrivilegeId(), "\") ");
        }
        boolean isAnnotated = this.emitAPIAuditingAnnotations(obj.isDeprecated(), obj.isInternal());
        if (prop.getDecl().isSilent()) {
            this.emitLine("@silent");
        }
        if (prop.getDecl().isLocalizable()) {
            this.emitLine("@localizable");
        }
        if (!isAnnotated) {
            VmodlDecl pd = prop.getDecl();
            this.emitAPIAuditingAnnotations(pd.isDeprecated(), pd.isInternal());
        }
    }

    private void emitAnnotations(VmodlObject obj, Method method) {
        this.emitLine("@versionClass(", this.wrapPackageName(method.getVersion().getVmodlName()), ".class)");
        this.emitLine("@wsdlName(\"", method.getWsdlName(), "\")");
        if (method.getPrivilegeId() != null) {
            this.emitLine("@privilege(\"", method.getPrivilegeId(), "\") ");
        } else if (method.isDynamicPrivs()) {
            this.emitLine("@privilege(\"dynamic\")");
        } else {
            this.emitSubprivilege(method);
        }
        if (method.isTask()) {
            this.emitLine("@task");
        }
        if (Versions.isInternalAtTarget(obj) || Versions.isInternalAtTarget(method)) {
            this.emitLine("@internal");
        }
        if (method.isMultibody()) {
            this.emitLine("@multibody");
        }
        this.emitCollectionAnnotations(method.getReturnDecl(), false);
        List<DataObject> faults = method.getFaultList();
        if (faults != null && faults.size() > 0) {
            this.emitPartial("@faults({");
            boolean isFirst = true;
            for (VmodlObject vmodlObject : faults) {
                if (!isFirst) {
                    this.emitPartial(", ");
                } else {
                    isFirst = false;
                }
                this.emitPartial("\"", vmodlObject.getWsdlName(), "\"");
            }
            this.emitLine("})");
        }
        this.emitAPIAuditingAnnotations(obj, method);
    }

    private String resolveManagedObjectType(VmodlDecl decl) {
        VmodlObject obj = decl.getObject();
        if (obj == null) {
            return this.wrapPackageName("vmodl.ManagedObject");
        }
        return this.resolveClass(decl.getObject(), '$');
    }

    private void emitObject(VmodlObject obj) {
        if (obj instanceof DataObject) {
            this.emitDataObject((DataObject)obj);
        } else if (obj instanceof Enum) {
            this.emitEnumType((Enum)obj);
        } else if (obj instanceof ManagedObject) {
            this.emitManagedObject((ManagedObject)obj);
        }
    }

    private void emitObjectImpl(VmodlObject obj) {
        if (obj instanceof DataObject) {
            this.emitDataObjectImpl((DataObject)obj);
        } else if (obj instanceof ManagedObject) {
            this.emitManagedObjectImpl((ManagedObject)obj);
        }
    }

    private String wrapPackageName(String packageName) {
        if (this.isBuiltInVmodlType(packageName)) {
            return this.getBuiltInClassName(packageName);
        }
        return this._packagePrefix + "." + packageName;
    }

    private String wrapImplPackageName(String packageName) {
        if (packageName.startsWith("vmodl")) {
            return "com.vmware.vim.binding.impl." + packageName;
        }
        return this._packagePrefix + ".impl." + packageName;
    }

    private boolean isBuiltInVmodlType(String name) {
        return name.startsWith("vmodl.");
    }

    private String getBuiltInClassName(String name) {
        if (this.isBuiltInVmodlType(name)) {
            return CORE_BINDING_PACKAGE_NAME + name;
        }
        return name;
    }

    private void emitEnumType(Enum obj) {
        if (!this.shouldGenerateFor(obj)) {
            return;
        }
        VmodlObject container = obj.getContainer();
        String staticPrefix = "";
        if (container == null) {
            String packagePath = this.wrapPackageName(obj.getPackage()).replace('.', '/');
            String fullFileName = this._interfacePath + packagePath + "/" + obj.getClassName() + ".java";
            this._vmodltypes.add(this.wrapPackageName(obj.getPackage()) + "." + obj.getClassName());
            this.beginFile(fullFileName);
            this.emitLine("package ", this.wrapPackageName(obj.getPackage()), ";");
            this.emitImportVmodl();
        } else {
            staticPrefix = " static";
            this.indent();
            this.emitLine();
        }
        this.emitComments(obj.getComment());
        this.emitAnnotations(obj);
        this.emitPartial("public" + staticPrefix + " enum ", obj.getClassName());
        if (obj.getBaseObject() != null) {
            String name = this.wrapPackageName(obj.getBaseObject().getQualifiedVmodlType());
            this.emitLine(" extends ", name);
        }
        this.emitLine(" {");
        this.indent();
        for (String value : obj.getValueList()) {
            String comment = obj.getComment(value);
            this.emitComments(comment);
            this.emitLine(value + ",");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        if (container == null) {
            this.endFile();
        } else {
            this.unindent();
            this.emitLine();
        }
    }

    private String getCompletionType(VmodlDecl specialization) {
        StringBuilder builder = new StringBuilder();
        builder.append("com.vmware.vim.vmomi.core.Future<");
        if (specialization.isVoid()) {
            builder.append("Void");
        } else if (specialization.isPrimitive() && !specialization.isArray()) {
            builder.append(this.getPrimitiveParam(specialization));
        } else {
            builder.append(this.vmodlTypeName(specialization));
        }
        return builder.append('>').toString();
    }

    private void emitManagedProperty(ManagedObject obj, ManagedProperty prop) {
        if (!this.shouldGenerateFor((VmodlObject)obj, prop)) {
            return;
        }
        VmodlDecl decl = prop.getDecl();
        String accessor = this.getAccessorPrefix(prop, decl.isOptional());
        if (this._moType != MoTypeOption.SYNC) {
            this.emitAnnotations((VmodlObject)obj, prop);
            this.emitPartial("public void ");
            this.emitPartial(accessor, JavaServerEmitter.capitalize(prop.getName()), "(");
            if (decl.isOptional()) {
                this.emitPartial("@optional ");
            }
            if (decl.isManaged()) {
                this.emitPartial("@managedObjectType(\"", this.resolveManagedObjectType(decl), "\") ");
            }
            if (decl.isSecret()) {
                this.emitPartial("@secret ");
            }
            this.emitPartial(this.getCompletionType(decl));
            this.emitLine(" _f);");
        }
        if (this._moType == MoTypeOption.SYNC || this._moType == MoTypeOption.BOTH) {
            this.emitLine();
            if (this._moType == MoTypeOption.SYNC) {
                this.emitAnnotations((VmodlObject)obj, prop);
            } else {
                this.emitLine("@name(\"", prop.getName(), "\")");
            }
            this.emitPartial("public ");
            if (decl.isOptional() && decl.isPrimitive() && !decl.isArray()) {
                this.emitPartial(this.getPrimitiveParam(decl));
            } else {
                this.emitPartial(this.vmodlTypeName(decl));
            }
            this.emitPartial(" ", accessor, JavaServerEmitter.capitalize(prop.getName()));
            this.emitLine("();");
        }
    }

    private void emitManagedMethod(ManagedObject obj, Method method) {
        if (!this.shouldGenerateFor((VmodlObject)obj, method)) {
            return;
        }
        if (this._moType == MoTypeOption.ASYNC || this._moType == MoTypeOption.BOTH) {
            this.emitAsyncMethod(obj, method, method.getParameterList(), true);
        }
        if (this._moType == MoTypeOption.SYNC || this._moType == MoTypeOption.BOTH) {
            this.emitSyncMethod(obj, method, method.getParameterList(), true);
        }
        if (this._backwardCompatible) {
            List<Version> emittingVersions = this.buildVersionList(method);
            List<List<Parameter>> versionParams = this.buildParameterList(method, emittingVersions);
            for (int overload = 0; overload < emittingVersions.size(); ++overload) {
                List<Parameter> params = versionParams.get(overload);
                if (params.equals(method.getParameterList())) continue;
                if (this._moType == MoTypeOption.ASYNC || this._moType == MoTypeOption.BOTH) {
                    this.emitAsyncMethod(obj, method, params, false);
                }
                if (this._moType != MoTypeOption.SYNC && this._moType != MoTypeOption.BOTH) continue;
                this.emitSyncMethod(obj, method, params, false);
            }
        }
    }

    private void emitAsyncMethod(ManagedObject obj, Method method, List<Parameter> params, boolean isMainMethod) {
        VmodlDecl returnDecl;
        if (isMainMethod) {
            this.emitComments(method.getComment());
            this.emitAnnotations((VmodlObject)obj, method);
        } else {
            this.emitBackwardsCompatibility(params);
        }
        this.emitPartial("public void");
        this.emitLine(" ", method.getName(), "(");
        this.indent();
        int paramsize = params.size();
        for (int i = 0; i < paramsize; ++i) {
            VmodlDecl paramDecl;
            Parameter param = params.get(i);
            if (!this.shouldGenerateFor(param)) continue;
            if (isMainMethod) {
                this.emitAnnotations(param);
            }
            if ((paramDecl = param.getDecl()).isOptional() && paramDecl.isPrimitive() && !paramDecl.isArray()) {
                this.emitPartial(this.getPrimitiveParam(paramDecl));
            } else {
                this.emitPartial(this.vmodlTypeName(paramDecl));
            }
            this.emitPartial(" ");
            this.emitPartial(param.getName());
            this.emitLine(", ");
        }
        VmodlDecl vmodlDecl = returnDecl = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
        if (isMainMethod) {
            if (returnDecl.isOptional()) {
                this.emitPartial("@optional ");
            }
            if (returnDecl.isManaged()) {
                this.emitPartial("@managedObjectType(\"", this.resolveManagedObjectType(returnDecl), "\") ");
            }
            if (returnDecl.isSecret()) {
                this.emitPartial("@secret ");
            }
            this.emitCollectionAnnotations(returnDecl, false);
        }
        this.emitPartial(this.getCompletionType(returnDecl));
        this.emitLine(" _f);");
        this.unindent();
        this.emitLine();
    }

    private void emitSyncMethod(ManagedObject obj, Method method, List<Parameter> params, boolean isMainMethod) {
        VmodlDecl returnDecl;
        if (isMainMethod) {
            if (this._moType == MoTypeOption.SYNC) {
                this.emitComments(method.getComment());
                this.emitAnnotations((VmodlObject)obj, method);
            } else {
                this.emitLine("@wsdlName(\"", method.getWsdlName(), "\")");
                if (this._apiAuditingType != null) {
                    this.emitAPIAuditingAnnotations((VmodlObject)obj, method);
                }
            }
        } else {
            this.emitBackwardsCompatibility(params);
        }
        VmodlDecl vmodlDecl = returnDecl = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
        if (isMainMethod) {
            if (returnDecl.isOptional()) {
                this.emitLine("@optional");
            }
            if (returnDecl.isSecret()) {
                this.emitLine("@secret");
            }
            if (returnDecl.isManaged()) {
                this.emitLine("@managedObjectType(\"", this.resolveManagedObjectType(returnDecl), "\")");
            }
        }
        this.emitPartial("public ");
        if (returnDecl.isOptional() && returnDecl.isPrimitive() && !returnDecl.isArray()) {
            this.emitPartial(this.getPrimitiveParam(returnDecl));
        } else {
            this.emitPartial(this.vmodlTypeName(returnDecl));
        }
        this.emitPartial(" ", method.getName(), "(");
        boolean first = true;
        int paramsize = params.size();
        for (int i = 0; i < paramsize; ++i) {
            VmodlDecl paramDecl;
            Parameter param = params.get(i);
            if (!this.shouldGenerateFor(param)) continue;
            if (first) {
                first = false;
            } else {
                this.emitPartial(", ");
            }
            if (this._moType == MoTypeOption.SYNC && isMainMethod) {
                this.emitAnnotations(param);
            }
            if ((paramDecl = param.getDecl()).isOptional() && paramDecl.isPrimitive() && !paramDecl.isArray()) {
                this.emitPartial(this.getPrimitiveParam(paramDecl));
            } else {
                this.emitPartial(this.vmodlTypeName(paramDecl));
            }
            this.emitPartial(" ");
            this.emitPartial(param.getName());
        }
        this.emitPartial(")");
        List<DataObject> faults = method.getFaultList();
        if (faults != null && faults.size() > 0) {
            this.emitLine();
            this.indent();
            this.emitPartial("throws ");
            boolean isFirst = true;
            for (VmodlObject vmodlObject : faults) {
                if (!isFirst) {
                    this.emitPartial(", ");
                } else {
                    isFirst = false;
                }
                String faultName = this.wrapPackageName(vmodlObject.getQualifiedVmodlType());
                this.emitPartial(faultName);
            }
            this.emitLine(";");
            this.unindent();
        } else {
            this.emitLine(";");
        }
        this.emitLine();
    }

    private List<Version> buildVersionList(Method method) {
        ArrayList<Version> emittingVersions = new ArrayList<Version>();
        if (Versions.isAncestor(method.getVersion(), this._backwardCompatVersion)) {
            emittingVersions.add(method.getVersion());
        } else {
            emittingVersions.add(this._backwardCompatVersion);
        }
        for (Parameter param : method.getParameterList()) {
            Version version = param.getVersion();
            if (!Versions.isAncestor(version, this._backwardCompatVersion)) continue;
            JavaServerEmitter.insertVersion(emittingVersions, version);
        }
        return emittingVersions;
    }

    private List<Version> buildVersionList(DataObject obj) {
        ArrayList<Version> emittingVersions = new ArrayList<Version>();
        Version objVersion = obj.getVersion();
        if (Versions.isAncestor(objVersion, this._backwardCompatVersion)) {
            emittingVersions.add(objVersion);
        } else {
            emittingVersions.add(this._backwardCompatVersion);
        }
        for (Property p : obj.getPropertyList()) {
            Version version = p.getVersion();
            if (!Versions.isAncestor(version, this._backwardCompatVersion)) continue;
            JavaServerEmitter.insertVersion(emittingVersions, version);
        }
        return emittingVersions;
    }

    private List<List<Parameter>> buildParameterList(Method method, List<Version> emittingVersions) {
        ArrayList<List<Parameter>> versionParams = new ArrayList<List<Parameter>>();
        for (int overload = 0; overload < emittingVersions.size(); ++overload) {
            versionParams.add(new ArrayList());
        }
        List<Parameter> paramList = method.getParameterList();
        for (int pIndex = 0; pIndex < paramList.size(); ++pIndex) {
            Parameter param = paramList.get(pIndex);
            Version paramVersion = param.getVersion();
            for (int overload = 0; overload < emittingVersions.size(); ++overload) {
                Version vPos = emittingVersions.get(overload);
                if (!Versions.isAncestor(vPos, paramVersion)) continue;
                ((List)versionParams.get(overload)).add(param);
            }
        }
        return versionParams;
    }

    private List<List<Property>> buildPropertyList(DataObject obj, List<Version> emittingVersions) {
        ArrayList<List<Property>> versionProps = new ArrayList<List<Property>>();
        for (int overload = 0; overload < emittingVersions.size(); ++overload) {
            versionProps.add(new ArrayList());
        }
        for (Property property : obj.getPropertyList()) {
            Version propertyVersion = property.getVersion();
            for (int overload = 0; overload < emittingVersions.size(); ++overload) {
                Version vPos = emittingVersions.get(overload);
                if (!Versions.isAncestor(vPos, propertyVersion)) continue;
                ((List)versionProps.get(overload)).add(property);
            }
        }
        return versionProps;
    }

    private boolean hasNestedObjectsToEmit(ManagedObject obj) {
        for (VmodlObject nestedObj : obj.getNestedList()) {
            if (!this.shouldGenerateFor(nestedObj)) continue;
            return true;
        }
        return false;
    }

    private void emitManagedObject(ManagedObject obj) {
        boolean shouldGenerate = this.shouldGenerateFor(obj);
        if (!shouldGenerate && !this.hasNestedObjectsToEmit(obj)) {
            return;
        }
        VmodlObject container = obj.getContainer();
        if (container == null) {
            String packagePath = this.wrapPackageName(obj.getPackage()).replace('.', '/');
            String fullFileName = this._interfacePath + packagePath + "/" + obj.getClassName() + ".java";
            this._vmodltypes.add(this.wrapPackageName(obj.getPackage()) + "." + obj.getClassName());
            this.beginFile(fullFileName);
            this.emitLine("package ", this.wrapPackageName(obj.getPackage()), ";");
            this.emitImportVmodl();
            this.emitLine();
        } else {
            this.indent();
            this.emitLine();
        }
        String fullyQualifiedVmodlName = obj.getPackage() + "." + obj.getClassName();
        this.emitLine("@fullyQualifiedVmodlName(\"" + fullyQualifiedVmodlName + "\")");
        this.emitComments(obj.getComment());
        this.emitAnnotations(obj);
        this.emitPartial("public interface ", obj.getClassName());
        if (obj.getBaseObject() != null) {
            String name = this.wrapPackageName(obj.getBaseObject().getQualifiedVmodlType());
            this.emitLine(" extends ", name);
        }
        this.emitLine("{");
        this.indent();
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
            this.emitLine();
        }
        if (shouldGenerate) {
            for (Property property : obj.getPropertyList()) {
                this.emitManagedProperty(obj, (ManagedProperty)property);
                this.emitLine();
            }
        }
        for (Method method : obj.getMethodList()) {
            this.emitManagedMethod(obj, method);
        }
        this.unindent();
        this.emitLine("}");
        if (container == null) {
            this.endFile();
        } else {
            this.unindent();
            this.emitLine();
        }
    }

    private void emitManagedObjectImpl(ManagedObject obj) {
        boolean shouldGenerate = this.shouldGenerateFor(obj);
        if (!shouldGenerate && !this.hasNestedObjectsToEmit(obj)) {
            return;
        }
        if (this._structDataObjects) {
            return;
        }
        if (obj.getNestedList().isEmpty()) {
            return;
        }
        VmodlObject container = obj.getContainer();
        if (container == null) {
            String packagePath = this.wrapImplPackageName(obj.getPackage()).replace('.', '/');
            String fullFileName = this._implPath + packagePath + "/" + obj.getClassName() + "_Impl.java";
            this.beginFile(fullFileName);
            this.emitLine("// This class does NOT implement the ManagedObject,");
            this.emitLine("// only the nested types defined by the ManagedObject");
            this.emitLine("package ", this.wrapImplPackageName(obj.getPackage()), ";");
            this.emitImportVmodl();
            this.emitLine();
        } else {
            this.indent();
            this.emitLine();
        }
        this.emitLine("public class ", obj.getClassName(), "_Impl");
        this.emitLine("{");
        this.indent();
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObjectImpl(nestedObj);
            this.emitLine();
        }
        this.unindent();
        this.emitLine("}");
        if (container == null) {
            this.endFile();
        } else {
            this.unindent();
            this.emitLine();
        }
    }

    private void emitDataObjectImpl(DataObject obj) {
        if (obj.isFault() && obj.getNestedList().size() == 0) {
            return;
        }
        if (!this.shouldGenerateFor(obj)) {
            return;
        }
        if (this._structDataObjects) {
            return;
        }
        VmodlObject container = obj.getContainer();
        String isStatic = "";
        if (container == null) {
            Iterator<VmodlObject> packagePath = this.wrapImplPackageName(obj.getPackage()).replace('.', '/');
            String fullFileName = this._implPath + (String)((Object)packagePath) + "/" + obj.getClassName() + "Impl.java";
            this.beginFile(fullFileName);
            this.emitLine("package ", this.wrapImplPackageName(obj.getPackage()), ";");
            this.emitImportVmodl();
            this.emitLine();
        } else {
            isStatic = "static ";
            this.indent();
            this.emitLine();
        }
        if (obj.isFault()) {
            this.emitPartial("public ", isStatic, "class ", obj.getClassName(), "Impl {");
            this.indent();
            for (VmodlObject nestedObj : obj.getNestedList()) {
                this.emitObjectImpl(nestedObj);
                this.emitLine();
            }
            this.unindent();
            this.emitLine("}");
            if (container == null) {
                this.endFile();
            } else {
                this.unindent();
                this.emitLine();
            }
            return;
        }
        this.emitPartial("public ", isStatic, "class ", obj.getClassName(), "Impl");
        if (obj.getBaseObject() != null) {
            this.emitLine(" extends ", this.resolveImplClass(obj.getBaseObject(), '.'));
        }
        this.emitLine("   implements ", this.wrapPackageName(obj.getQualifiedVmodlType()));
        this.emitLine("{");
        this.indent();
        this.emitDataObjectCtors(obj);
        this.emitSerialUID();
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObjectImpl(nestedObj);
            this.emitLine();
        }
        HashMap<String, VmodlDecl> managedProperties = new HashMap<String, VmodlDecl>();
        for (Property property : obj.getPropertyList()) {
            if (!this.shouldGenerateFor((VmodlObject)obj, property)) continue;
            String propType = this.resolvePropertyType(property, obj);
            VmodlDecl decl = property.getDecl();
            String accessor = this.getAccessorPrefix(property, decl.isOptional());
            String propName = property.getName();
            String getterBody = null;
            String setterBody = null;
            String modifier = null;
            String transientKeyword = "";
            if (this._hideMoRef && decl.isManaged()) {
                transientKeyword = "transient ";
                managedProperties.put(propName, decl);
            }
            this.emitLine("private ", transientKeyword, propType, " ", propName, ";");
            getterBody = "{ return " + propName + "; }";
            setterBody = "{ this." + propName + " = " + propName + "; }";
            modifier = "public ";
            this.emitLine(modifier, propType, " ", Utils.uncapitalize(accessor), JavaServerEmitter.capitalize(propName), "() ", getterBody);
            this.emitLine();
            boolean emitBothBooleanGetters = propType.equals("Boolean");
            if (emitBothBooleanGetters) {
                this.emitLine(modifier, propType, " ", "get", JavaServerEmitter.capitalize(propName), "() ", getterBody);
                this.emitLine();
            }
            this.emitLine(modifier, "void set" + JavaServerEmitter.capitalize(propName) + "(" + propType + " " + propName + ") ", setterBody);
            this.emitLine();
        }
        this.emitLine();
        this.emitToString(obj);
        this.emitLine();
        this.emitPersistenceMethods(managedProperties, obj);
        this.emitLine();
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        if (container == null) {
            this.endFile();
        } else {
            this.unindent();
            this.emitLine();
        }
    }

    private void emitPersistenceMethods(Map<String, VmodlDecl> managedProperties, DataObject obj) {
        if (managedProperties.size() > 0 && this._persistence == PersistOption.SERIALIZE) {
            this.emitSerializableMethods(managedProperties);
        } else if (this._persistence == PersistOption.EXTERNALIZE) {
            this.emitExternalizableMethods(obj);
        }
    }

    private void emitExternalizableMethods(DataObject obj) {
        String clazz = "";
        clazz = this._structDataObjects || obj.isFault() ? this.resolveClass(obj, '.') : this.resolveImplClass(obj, '.');
        this.emitLine("private ", clazz, " tmp = null;");
        this.emitLine("public void readExternal(java.io.ObjectInput in)");
        this.emitLine("{");
        this.indent();
        this.emitLine("tmp = (", clazz, ")((com.vmware.vim.vmomi.core.serialize.XmlObjectInput)in).unmarshal();");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitLine("public Object readResolve() throws java.io.ObjectStreamException");
        this.emitLine("{");
        this.indent();
        this.emitLine("return tmp;");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitLine("public void writeExternal(java.io.ObjectOutput out)");
        this.emitLine("{");
        this.indent();
        this.emitLine("((com.vmware.vim.vmomi.core.serialize.XmlObjectOutput)out).marshal(this);");
        this.unindent();
        this.emitLine("}");
    }

    private void emitSerializableMethods(Map<String, VmodlDecl> managedProperties) {
        this.emitLine("private void writeObject(java.io.ObjectOutputStream stream) throws java.io.IOException");
        this.emitLine("{");
        this.indent();
        this.emitLine("stream.defaultWriteObject();");
        boolean emitMoRefArrayDecl = true;
        for (String p : managedProperties.keySet()) {
            if (managedProperties.get(p).isArray()) {
                if (emitMoRefArrayDecl) {
                    this.emitLine("ManagedObjectReference[] moRefs = null;");
                    emitMoRefArrayDecl = false;
                }
                this.emitLine("if (", p, " == null) {");
                this.indent();
                this.emitLine("stream.writeObject(null);");
                this.unindent();
                this.emitLine("} else {");
                this.indent();
                this.emitLine("moRefs = new ManagedObjectReference[", p, ".length];");
                this.emitLine("for (int i = 0; i < ", p, ".length; i++) {");
                this.indent();
                this.emitLine("moRefs[i] = (", p, "[i] == null)?null:", p, "[i]._getRef();");
                this.unindent();
                this.emitLine("}");
                this.emitLine("stream.writeObject(moRefs);");
                this.unindent();
                this.emitLine("}");
                continue;
            }
            this.emitLine("stream.writeObject((", p, " == null)?null:", p, "._getRef());");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitLine("private void readObject(java.io.ObjectInputStream stream) throws java.io.IOException, ClassNotFoundException");
        this.emitLine("{");
        this.indent();
        this.emitLine("stream.defaultReadObject();");
        this.emitLine("if (stream instanceof com.vmware.vim.vmomi.core.serialize.MoRefResolver) {");
        this.indent();
        boolean emitMoRefDecl = true;
        emitMoRefArrayDecl = true;
        for (String p : managedProperties.keySet()) {
            String vmodlTypeName = this.vmodlTypeName(managedProperties.get(p));
            if (managedProperties.get(p).isArray()) {
                if (emitMoRefArrayDecl) {
                    this.emitLine("ManagedObjectReference[] moRefs = null;");
                    emitMoRefArrayDecl = false;
                }
                this.emitLine("moRefs = (ManagedObjectReference[])stream.readObject();");
                this.emitLine("if (moRefs != null) {");
                this.indent();
                String arrayElementType = vmodlTypeName.substring(0, vmodlTypeName.length() - "[]".length());
                this.emitLine(p, " = new ", arrayElementType, "[moRefs.length];");
                this.emitLine("for (int i = 0; i < moRefs.length; i++) {");
                this.indent();
                this.emitResolve("moRefs[i]", p + "[i]", arrayElementType);
                this.unindent();
                this.emitLine("}");
                this.unindent();
                this.emitLine("}");
                continue;
            }
            if (emitMoRefDecl) {
                this.emitLine("ManagedObjectReference moRef = null;");
                emitMoRefDecl = false;
            }
            this.emitLine("moRef = (ManagedObjectReference)stream.readObject();");
            this.emitResolve("moRef", p, vmodlTypeName);
        }
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
    }

    private void emitResolve(String moRefField, String moField, String cast) {
        this.emitLine("if (", moRefField, " == null) {");
        this.indent();
        this.emitLine(moField, " = null;");
        this.unindent();
        this.emitLine("} else {");
        this.indent();
        this.emitLine(moField, " = (", cast, ")", "((com.vmware.vim.vmomi.core.serialize.MoRefResolver)stream).resolve(", moRefField, ");");
        this.unindent();
        this.emitLine("}");
    }

    private boolean shouldSkipPropertyInCtor(boolean isFault, Property p) {
        return isFault && (p.getName().equals("faultCause") || p.getName().equals("faultMessage"));
    }

    private void emitDataObjectCtors(DataObject obj) {
        ArrayList<DataObject> hierarchy = new ArrayList<DataObject>();
        for (DataObject currentObject = obj; currentObject != null && !currentObject.getQualifiedVmodlType().equals(Utils.DynamicDataClassName); currentObject = (DataObject)currentObject.getBaseObject()) {
            hierarchy.add(currentObject);
        }
        Collections.reverse(hierarchy);
        String clazz = "";
        clazz = this._structDataObjects || obj.isFault() ? obj.getClassName() : obj.getClassName() + "Impl";
        this.emitLine("public ", clazz, "() { }");
        this.emitDataObjectCtor(obj, clazz, hierarchy, Versions.getTargetVersion());
        if (this._backwardCompatible) {
            List<Version> emittingVersions = this.buildVersionList(obj);
            List<List<Property>> versionProps = this.buildPropertyList(obj, emittingVersions);
            for (int overload = 0; overload < emittingVersions.size(); ++overload) {
                List<Property> properties = versionProps.get(overload);
                Version vPos = emittingVersions.get(overload);
                if (obj.getPropertyList().equals(properties)) continue;
                this.emitDataObjectCtor(obj, clazz, hierarchy, vPos);
            }
        }
    }

    private void emitDataObjectCtor(DataObject obj, String clazz, List<DataObject> hierarchy, Version vPos) {
        boolean ctorOpened = false;
        boolean emitComma = false;
        for (DataObject o : hierarchy) {
            for (Property p : o.getPropertyList()) {
                Version propertyVersion;
                if (this.shouldSkipPropertyInCtor(o.isFault(), p) || !Versions.isAncestor(vPos, propertyVersion = p.getVersion())) continue;
                if (!ctorOpened) {
                    this.emitLine();
                    this.emitLine("public ", clazz, "(");
                    this.indent();
                    ctorOpened = true;
                }
                if (!emitComma) {
                    emitComma = true;
                } else {
                    this.emitLine(",");
                }
                String propType = this.resolvePropertyType(p, obj);
                this.emitPartial(propType, " ", p.getName());
            }
        }
        if (ctorOpened) {
            this.emitLine(") {");
            this.emitLine();
            if (hierarchy.size() > 1) {
                this.emitPartial("super(");
                boolean justOpened = true;
                for (int i = 0; i < hierarchy.size() - 1; ++i) {
                    boolean classIsFault = hierarchy.get(i).isFault();
                    for (Property p : hierarchy.get(i).getPropertyList()) {
                        Version propertyVersion;
                        if (this.shouldSkipPropertyInCtor(classIsFault, p) || !Versions.isAncestor(vPos, propertyVersion = p.getVersion())) continue;
                        if (justOpened) {
                            this.indent();
                            justOpened = false;
                        } else {
                            this.emitLine(",");
                        }
                        this.emitPartial(p.getName());
                    }
                }
                this.emitLine(");");
                if (!justOpened) {
                    this.unindent();
                }
            }
            for (Property p : obj.getPropertyList()) {
                Version propertyVersion;
                if (this.shouldSkipPropertyInCtor(obj.isFault(), p) || !Versions.isAncestor(vPos, propertyVersion = p.getVersion())) continue;
                this.emitLine("this.", p.getName(), " = ", p.getName(), ";");
            }
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
    }

    private void emitToString(DataObject obj) {
        this.emitLine("public String toString() {");
        this.indent();
        int numberProps = obj.getFullPropertyList().size();
        this.emitLine("StringBuilder objString = new StringBuilder(" + numberProps * 40 + ");");
        this.emitLine();
        this.emitLine("objString.append(\"(" + obj.getPackage() + "." + obj.getClassName() + ") {\\n\");");
        for (int i = 0; i < numberProps; ++i) {
            Property property = obj.getFullPropertyList().get(i);
            if (!this.shouldGenerateFor((VmodlObject)obj, property)) continue;
            VmodlDecl decl = property.getDecl();
            String getterPropertyName = this.getAccessorPrefix(property, decl.isOptional()) + JavaServerEmitter.capitalize(property.getName()) + "()";
            this.emitIndentation(false);
            this.emitLine("objString.append(\"" + property.getName() + " = \");");
            if (decl.isArray()) {
                this.emitLine("if (" + getterPropertyName + " == null) {");
                this.indent();
                this.emitLine("objString.append(\"null\");");
                this.unindent();
                this.emitLine("} else {");
                this.indent();
                if (decl.getObject() != null) {
                    this.emitLine("objString.append(\"(" + decl.getObject().getPackage() + "." + decl.getObject().getClassName() + ") [\\n\");");
                } else {
                    this.emitLine("objString.append(\"(" + (Object)((Object)decl.getTypeId()) + ") [\\n\");");
                }
                this.emitLine("for (int i = 0; i < " + getterPropertyName + ".length; i++) {");
                this.indent();
                this.emitIndentation(true);
                if (decl.isPrimitive()) {
                    this.emitLine("objString.append(" + getterPropertyName + "[i]);");
                } else {
                    this.emitLine("objString.append(com.vmware.vim.vmomi.core.util.StringUtil.indent(\"\"+" + getterPropertyName + "[i], true));");
                }
                this.emitLine("if (i < " + getterPropertyName + ".length - 1) {");
                this.indent();
                this.emitLine("objString.append(\",\");");
                this.unindent();
                this.emitLine("}");
                this.emitLine("objString.append(\"\\n\");");
                this.unindent();
                this.emitLine("}");
                this.emitIndentation(false);
                this.emitLine("objString.append(\"]\");");
                this.unindent();
                this.emitLine("}");
            } else if (decl.isPrimitive()) {
                if (!decl.isSecret()) {
                    this.emitLine("objString.append(this." + getterPropertyName + ");");
                } else {
                    this.emitLine("if (this." + getterPropertyName + " == null) {");
                    this.indent();
                    this.emitLine("objString.append(\"null\");");
                    this.unindent();
                    this.emitLine("} else {");
                    this.indent();
                    this.emitLine("objString.append(\"" + SECRET_FIELD_VALUE + "\");");
                    this.unindent();
                    this.emitLine("}");
                }
            } else {
                this.emitLine("if (this." + getterPropertyName + " == null) {");
                this.indent();
                this.emitLine("objString.append(\"null\");");
                this.unindent();
                this.emitLine("} else {");
                this.indent();
                this.emitLine("objString.append(com.vmware.vim.vmomi.core.util.StringUtil.indent(\"\"+this." + getterPropertyName + ", false));");
                this.unindent();
                this.emitLine("}");
            }
            if (i >= numberProps - 1) continue;
            this.emitLine("objString.append(\",\\n\");");
        }
        this.emitLine("objString.append(\"\\n}\");");
        this.emitLine("return objString.toString();");
        this.unindent();
        this.emitLine("}");
    }

    private void emitIndentation(boolean isArray) {
        StringBuilder sb = new StringBuilder();
        int indentSize = 3;
        if (isArray) {
            indentSize *= 2;
        }
        for (int i = 0; i < indentSize; ++i) {
            sb.append(' ');
        }
        this.emitLine("objString.append(\"" + sb.toString() + "\");");
    }

    private void emitDataObject(DataObject obj) {
        if (!this.shouldGenerateFor(obj)) {
            return;
        }
        VmodlObject container = obj.getContainer();
        if (container == null) {
            String packagePath = this.wrapPackageName(obj.getPackage()).replace('.', '/');
            String fullFileName = this._interfacePath + packagePath + "/" + obj.getClassName() + ".java";
            this._vmodltypes.add(this.wrapPackageName(obj.getPackage()) + "." + obj.getClassName());
            this.beginFile(fullFileName);
            this.emitLine("package ", this.wrapPackageName(obj.getPackage()), ";");
            this.emitImportVmodl();
            this.emitLine();
        } else {
            this.indent();
            this.emitLine();
        }
        this.emitComments(obj.getComment());
        this.emitAnnotations(obj);
        String classType = null;
        boolean isInterface = false;
        if (obj.isFault()) {
            classType = "public class ";
        } else if (this._structDataObjects) {
            classType = obj.getContainer() == null ? "public class " : "public static class ";
            String fqn = this.resolveClass(obj, '$');
            this._dataObjectDefaultImpl.put(fqn, fqn);
            this.emitLine("@data");
        } else {
            classType = "public interface ";
            isInterface = true;
            this._dataObjectDefaultImpl.put(this.resolveClass(obj, '$'), this.resolveImplClass(obj, '$'));
            this.emitLine("@data");
        }
        if (obj.hasProperties()) {
            this.emitPartial("@propertyOrder({");
            boolean needComma = false;
            for (Property property : obj.getPropertyList()) {
                if (!this.shouldGenerateFor((VmodlObject)obj, property)) continue;
                if (needComma) {
                    this.emitPartial(",");
                } else {
                    needComma = true;
                }
                this.emitPartial("\"", property.getName(), "\"");
            }
            this.emitLine("})");
        }
        if (obj.isFault()) {
            String fullyQualifiedVmodlName = obj.getPackage() + "." + obj.getClassName();
            this.emitLine("@fullyQualifiedVmodlName(\"" + fullyQualifiedVmodlName + "\")");
        }
        this.emitPartial(classType, obj.getClassName());
        if (obj.getBaseObject() != null) {
            Object name = this.wrapPackageName(obj.getBaseObject().getQualifiedVmodlType());
            if (!obj.isFault() && obj.getBaseObject().getPackage().equals("vmodl") && obj.getBaseObject().getClassName().equals("DynamicData")) {
                String prefix;
                String persistanceInterface = this.getPersistenceInterface();
                if (this._structDataObjects) {
                    name = "com.vmware.vim.binding.impl.vmodl.DynamicDataImpl ";
                    prefix = "implements";
                } else {
                    prefix = ",";
                }
                if (null != persistanceInterface) {
                    name = (String)name + prefix + persistanceInterface;
                }
            }
            this.emitPartial(new String[]{" extends ", name});
        }
        this.emitLine("{");
        this.indent();
        if (!isInterface) {
            this.emitDataObjectCtors(obj);
            this.emitSerialUID();
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
            this.emitLine();
        }
        HashMap<String, VmodlDecl> managedProperties = new HashMap<String, VmodlDecl>();
        for (Property property : obj.getPropertyList()) {
            if (!this.shouldGenerateFor((VmodlObject)obj, property)) continue;
            if (obj.isFault()) {
                this.emitComments(property.getComment());
                this.emitAnnotations((VmodlObject)obj, property);
            }
            String propType = this.resolvePropertyType(property, obj);
            VmodlDecl decl = property.getDecl();
            String accessor = this.getAccessorPrefix(property, decl.isOptional());
            String propName = property.getName();
            String getterBody = null;
            String setterBody = null;
            String modifier = null;
            String transientKeyword = "";
            if (this._hideMoRef && decl.isManaged()) {
                transientKeyword = "transient ";
                if (!isInterface) {
                    managedProperties.put(propName, decl);
                }
            }
            if (obj.isFault()) {
                this.emitLine("private ", transientKeyword, propType, " ", propName, ";");
                this.emitLine();
                getterBody = " {return " + propName + "; }";
                setterBody = " {this." + propName + " = " + propName + "; }";
                modifier = "public ";
            } else if (this._structDataObjects) {
                this.emitLine("public ", transientKeyword, propType, " ", propName, ";");
                this.emitLine();
                getterBody = " { return " + propName + "; }";
                setterBody = " { this." + propName + " = " + propName + "; }";
                modifier = "public ";
            } else {
                getterBody = ";";
                setterBody = ";";
                modifier = "";
            }
            boolean emitBothBooleanGetters = propType.equals("Boolean");
            boolean emitDeprecatedAnnotation = emitBothBooleanGetters && !obj.isDeprecated() && !property.getDecl().isDeprecated();
            String comment = property.getComment();
            if (emitDeprecatedAnnotation) {
                if (comment == null) {
                    comment = "";
                }
                comment = comment + "\n@deprecated Use the {@link #get" + JavaServerEmitter.capitalize(propName) + "()} instead.";
            }
            this.emitComments(comment);
            this.emitAnnotations((VmodlObject)obj, property);
            if (emitDeprecatedAnnotation && this._apiAuditingType == APIAudit.NOTSET) {
                this.emitLine("@Deprecated");
            }
            this.emitLine(modifier, propType, " ", Utils.uncapitalize(accessor), JavaServerEmitter.capitalize(propName), "()", getterBody);
            this.emitLine();
            if (emitBothBooleanGetters) {
                this.emitComments(property.getComment());
                this.emitAnnotations((VmodlObject)obj, property);
                this.emitLine(modifier, propType, " ", "get", JavaServerEmitter.capitalize(propName), "()", getterBody);
                this.emitLine();
            }
            this.emitComments(property.getComment());
            this.emitAnnotations((VmodlObject)obj, property);
            this.emitLine(modifier, "void set" + JavaServerEmitter.capitalize(propName) + "(" + propType + " " + propName + ")", setterBody);
            this.emitLine();
        }
        this.emitLine();
        if (!isInterface) {
            this.emitPersistenceMethods(managedProperties, obj);
            this.emitLine();
        }
        if (this._structDataObjects || obj.isFault()) {
            this.emitToString(obj);
            this.emitLine();
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        if (container == null) {
            this.endFile();
        } else {
            this.unindent();
            this.emitLine();
        }
    }

    private String resolvePropertyType(Property property, DataObject obj) {
        VmodlDecl decl = property.getDecl();
        String propType = null;
        propType = decl.isLink() ? (decl.isArray() ? "String []" : "String") : (this.shouldBoxProperty(decl, obj.getVersion(), property.getVersion()) ? this.getPrimitiveParam(decl) : this.vmodlTypeName(decl));
        if (propType.equals("com.vmware.vim.binding.vmodl.MethodFault")) {
            propType = "Exception";
        }
        return propType;
    }

    private String getPersistenceInterface() {
        if (this._persistence == PersistOption.EXTERNALIZE) {
            return " java.io.Externalizable ";
        }
        return null;
    }

    private String resolveClass(VmodlObject obj, char nestedClassSeparator) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj.getClassName());
        for (VmodlObject container = obj.getContainer(); container != null; container = container.getContainer()) {
            buf.insert(0, nestedClassSeparator);
            buf.insert(0, container.getClassName());
        }
        buf.insert(0, ".");
        buf.insert(0, this.wrapPackageName(obj.getPackage()));
        return buf.toString();
    }

    private String resolveImplClass(VmodlObject obj, char nestedClassSeparator) {
        StringBuilder buf = new StringBuilder();
        buf.append(obj.getClassName());
        buf.append("Impl");
        for (VmodlObject container = obj.getContainer(); container != null; container = container.getContainer()) {
            buf.insert(0, nestedClassSeparator);
            buf.insert(0, "Impl");
            if (container instanceof ManagedObject) {
                buf.insert(0, "_");
            }
            buf.insert(0, container.getClassName());
        }
        buf.insert(0, ".");
        buf.insert(0, this.wrapImplPackageName(obj.getPackage()));
        return buf.toString();
    }

    private String vmodlTypeName(VmodlDecl decl) {
        String typeName;
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case BYTE: {
                typeName = "byte";
                break;
            }
            case SHORT: {
                typeName = "short";
                break;
            }
            case INT: {
                typeName = "int";
                break;
            }
            case LONG: {
                typeName = "long";
                break;
            }
            case FLOAT: {
                typeName = "float";
                break;
            }
            case DOUBLE: {
                typeName = "double";
                break;
            }
            case STRING: {
                typeName = "String";
                break;
            }
            case DATETIME: {
                typeName = "java.util.Calendar";
                break;
            }
            case TYPENAME: {
                typeName = "TypeName";
                break;
            }
            case METHODNAME: {
                typeName = "MethodName";
                break;
            }
            case PROPPATH: {
                typeName = "String";
                break;
            }
            case URI: {
                typeName = "java.net.URI";
                break;
            }
            case BINARY: {
                typeName = "Binary";
                break;
            }
            case ANY: {
                typeName = "java.lang.Object";
                break;
            }
            case VOID: {
                typeName = "void";
                break;
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                typeName = this.wrapPackageName(enumobj.getQualifiedVmodlType());
                break;
            }
            case MANAGED: {
                if (this._hideMoRef) {
                    VmodlObject moobj = decl.getObject();
                    if (moobj != null) {
                        typeName = this.wrapPackageName(moobj.getQualifiedVmodlType());
                        break;
                    }
                    typeName = vmodl.ManagedObject.class.getSimpleName();
                    break;
                }
                typeName = this.wrapPackageName("vmodl.ManagedObjectReference");
                break;
            }
            case DATA: {
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    typeName = this.wrapPackageName(obj.getQualifiedVmodlType());
                    break;
                }
                typeName = vmodl.DataObject.class.getSimpleName();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
        if (typeName.equals("com.vmware.vim.binding.vmodl.MethodFault")) {
            typeName = "Exception";
        }
        if (decl.isArray()) {
            typeName = typeName + "[]";
        }
        return typeName;
    }

    private String getPrimitiveParam(VmodlDecl decl) {
        String objType;
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                objType = "Boolean";
                break;
            }
            case BYTE: {
                objType = "Byte";
                break;
            }
            case SHORT: {
                objType = "Short";
                break;
            }
            case INT: {
                objType = "Integer";
                break;
            }
            case LONG: {
                objType = "Long";
                break;
            }
            case FLOAT: {
                objType = "Float";
                break;
            }
            case DOUBLE: {
                objType = "Double";
                break;
            }
            default: {
                return this.vmodlTypeName(decl);
            }
        }
        if (decl.isArray()) {
            objType = objType + "[]";
        }
        return objType;
    }

    private void emitComments(String comments) {
        if (comments != null && !comments.isEmpty()) {
            Pattern genericEol = Pattern.compile("\r\n?|\n");
            this.emitLine("/**");
            for (String line : genericEol.split(comments)) {
                this.emitLine(" * " + this.wrapLinkInComment(line));
            }
            this.emitLine(" */");
        }
    }

    private String wrapLinkInComment(String line) {
        String retval = line.replaceAll("\\{@link vim", "{@link " + this.wrapPackageName("vim"));
        retval = line.replaceAll("\\{@link vmodl", "{@link " + this.wrapPackageName("vmodl"));
        retval = line.replaceAll("@see vim", "@see " + this.wrapPackageName("vim"));
        retval = line.replaceAll("@see vmodl", "@see " + this.wrapPackageName("vmodl"));
        return retval;
    }

    private void emitSubprivilege(Method method) {
        Map<String, String> subprivileges = method.getSubclassPrivileges();
        if (subprivileges != null) {
            this.emitLine("@subprivileges({");
            this.indent();
            Set<Map.Entry<String, String>> entries = subprivileges.entrySet();
            Iterator<Map.Entry<String, String>> it = entries.iterator();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                Map.Entry<String, String> entry = it.next();
                String className = this.wrapPackageName(entry.getKey());
                String privilegeId = entry.getValue();
                this.emitLine("@subprivilege (");
                this.indent();
                this.emitLine("className = \"", className, "\",");
                this.emitLine("privilegeId = \"", privilegeId, "\"");
                this.unindent();
                if (i < size - 1) {
                    this.emitLine("),");
                    continue;
                }
                this.emitLine(")");
            }
            this.unindent();
            this.emitLine("})");
        }
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(filename);
        this.emitLine("// DO NOT modify, this class is auto-generated");
    }

    protected String uncapitalize(String str) {
        if ('A' <= str.charAt(0) && str.charAt(0) <= 'Z' && 'A' <= str.charAt(1) && str.charAt(1) <= 'Z') {
            return str;
        }
        return Utils.uncapitalize(str);
    }

    private String getAccessorPrefix(Property property, boolean isOptional) {
        if (property.getDecl().isBoolean()) {
            return "is";
        }
        return "get";
    }

    private void emitSerialUID() {
        this.emitLine("private static final long serialVersionUID = 1L;");
    }

    private boolean shouldBoxProperty(VmodlDecl decl, Version objectVersion, Version propertyVersion) {
        return decl.isPrimitive() && !decl.isArray() && this.isOptionalProperty(decl, objectVersion, propertyVersion);
    }

    private boolean isOptionalProperty(VmodlDecl decl, Version objectVersion, Version propertyVersion) {
        if (decl.isOptional()) {
            return true;
        }
        return !objectVersion.equals(propertyVersion) && Versions.isAncestor(propertyVersion, objectVersion) && !Versions.hasLegacyChild(propertyVersion);
    }

    private void emitCollectionAnnotations(VmodlDecl decl, boolean emitPartial) {
        String ann = null;
        if (decl.isList()) {
            ann = "@list";
        } else if (decl.isMap()) {
            ann = "@map";
        } else if (decl.isSet()) {
            ann = "@set";
        } else if (decl.isArray()) {
            ann = this.isKeyedObjectType(decl) ? "@map" : "@list";
        }
        if (ann != null) {
            if (emitPartial) {
                this.emitPartial(ann + " ");
            } else {
                this.emitLine(ann);
            }
        }
    }

    private void emitBackwardsCompatibility(List<Parameter> params) {
        this.emitLine("/**");
        this.emitLine(" * Backwards compatibility overload.");
        this.emitLine(" */");
        this.emitPartial("@backwardCompatibility({");
        for (int i = 0; i < params.size(); ++i) {
            this.emitPartial("\"", params.get(i).getName(), "\"");
            if (i >= params.size() - 1) continue;
            this.emitPartial(", ");
        }
        this.emitLine("})");
    }

    private void emitVersionInfo(boolean isInternal) {
        NsVersionAliases nsVersionAliases = Versions.getNsVersionAliases();
        String package_ = this._packagePrefix + "." + nsVersionAliases.iterator().next().version.getPackage() + (isInternal ? ".internal" : "");
        String filePath = package_.replace('.', File.separatorChar) + File.separator + "versions.java";
        this.beginFile(this._interfacePath + filePath);
        this.emitLine("package " + package_ + ";");
        this.emitLine("import java.util.ArrayList;");
        this.emitLine("public class versions {");
        this.indent();
        this.emitLine("public final static boolean BUILT_ON_MAIN = ", Boolean.toString(Platform.builtOnMain()), ";");
        for (NsVersionAliases.Entry entry : nsVersionAliases) {
            this.emitLine("public final static Class<?> " + this._servicePrefix + "_VERSION_" + entry.label + " = " + entry.version.getSimpleName() + ".class;");
        }
        String versionsList = this._servicePrefix + "_VERSIONS_LIST";
        this.emitLine("public final static ArrayList<Class<?>> " + versionsList + " = new ArrayList<Class<?>>();");
        this.emitLine("static {");
        this.indent();
        for (Version version : Versions.enumerateVersions()) {
            this.emitLine(versionsList + ".add(" + version.getSimpleName() + ".class);");
        }
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("};");
        this.endFile();
    }

    public boolean isKeyedObjectType(VmodlDecl decl) {
        switch (decl.getTypeId()) {
            case INT: 
            case STRING: 
            case MANAGED: {
                return true;
            }
            case DATA: {
                DataObject dataObjectType = (DataObject)decl.getObject();
                Field keyProperty = null;
                for (Property property : dataObjectType.getPropertyList()) {
                    if (!property.getName().equals(KEY_PROP_NAME)) continue;
                    keyProperty = property;
                    break;
                }
                if (keyProperty == null) {
                    return false;
                }
                VmodlDecl keyPropDecl = keyProperty.getDecl();
                return keyPropDecl.getTypeId() == VmodlDecl.TypeId.INT || keyPropDecl.getTypeId() == VmodlDecl.TypeId.STRING || keyPropDecl.getTypeId() == VmodlDecl.TypeId.MANAGED;
            }
        }
        return false;
    }

    private static enum ContextLoaderOption {
        SPRING,
        JAVA,
        BOTH;


        public static ContextLoaderOption parse(String value) {
            if (value == null) {
                return BOTH;
            }
            if (SPRING.name().equalsIgnoreCase(value)) {
                return SPRING;
            }
            if (JAVA.name().equalsIgnoreCase(value)) {
                return JAVA;
            }
            if (BOTH.name().equalsIgnoreCase(value)) {
                return BOTH;
            }
            throw new IllegalArgumentException(String.format("For java-%1$s acceptable values are %2$s, %3$s and %4$s", CTX_LOADER_OPTION, SPRING.name().toLowerCase(), JAVA.name().toLowerCase(), BOTH.name().toLowerCase()));
        }
    }

    private static enum ContextVersion {
        V1(""),
        V2("_v2");

        private final String _suffix;

        private ContextVersion(String suffix) {
            this._suffix = suffix;
        }

        public String getSuffix() {
            return this._suffix;
        }
    }

    private static enum PersistOption {
        EXTERNALIZE,
        SERIALIZE;


        public static PersistOption parse(String value) {
            if (value == null) {
                return SERIALIZE;
            }
            if (EXTERNALIZE.name().equalsIgnoreCase(value)) {
                return EXTERNALIZE;
            }
            if (SERIALIZE.name().equalsIgnoreCase(value)) {
                return SERIALIZE;
            }
            throw new IllegalArgumentException(String.format("For java-%1$s acceptable values are %2$s and %3$s", DO_PERSISTENCE_OPTION, EXTERNALIZE.name().toLowerCase(), SERIALIZE.name().toLowerCase()));
        }
    }

    private static enum MoTypeOption {
        SYNC,
        ASYNC,
        BOTH;


        public static MoTypeOption parse(String value) {
            if (value == null) {
                return ASYNC;
            }
            if (SYNC.name().equalsIgnoreCase(value)) {
                return SYNC;
            }
            if (ASYNC.name().equalsIgnoreCase(value)) {
                return ASYNC;
            }
            if (BOTH.name().equalsIgnoreCase(value)) {
                return BOTH;
            }
            throw new IllegalArgumentException(String.format("For java-%1$s acceptable values are %2$s, %3$s and %4$s", MO_TYPE_OPTION, SYNC.name().toLowerCase(), ASYNC.name().toLowerCase(), BOTH.name().toLowerCase()));
        }
    }
}

