/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.cpp;

import emitters.Services;
import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.model.Field;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class CppEmitter
extends VmodlEmitter {
    protected final String _targetNs;
    protected final String _namespace;
    protected final String _capitalizedNamespace;
    protected final String _apiName;
    protected final String _apiDecl;
    protected final boolean _emitAsyncStubMethods;
    protected final boolean _emitDiffMethod;
    protected String _headersDir;
    protected String _apiHeaderFile;
    private final List<String> _includeList = new ArrayList<String>();
    private String _currentNamespace = "";
    protected static final String kUnnamed = "unnamed namespace sentinel";

    CppEmitter(Map<String, String> options) {
        this._targetNs = Versions.getTargetVersion().getNamespace();
        this._namespace = Versions.getVmodlNamespace();
        this._capitalizedNamespace = CppEmitter.getNamespace(this._namespace);
        this._apiName = options.get("api");
        if (this._apiName == null) {
            throw new RuntimeException("The 'api' parameter is mandatory for C++ emitters");
        }
        this._apiDecl = this._apiName + " ";
        this._emitAsyncStubMethods = CppEmitter.parseOptionalBoolean(options.get("emit.async.stub.methods"), true);
        this._emitDiffMethod = CppEmitter.parseOptionalBoolean(options.get("emit.diff.method"), true);
        String includeList = options.get("include");
        if (includeList != null) {
            for (String header : includeList.split(",")) {
                this.addHeader(header);
            }
        }
    }

    protected void setHeadersDir(String dir) {
        this._headersDir = dir + "/";
        if (!this._apiName.equals("VMOMI_API")) {
            StringBuilder sb = new StringBuilder(this._headersDir + "Api/");
            for (String s : this._apiName.split("_")) {
                sb.append(Character.toUpperCase(s.charAt(0)));
                sb.append(s.substring(1).toLowerCase());
            }
            sb.append(".h");
            this._apiHeaderFile = sb.toString();
        }
    }

    protected void addHeader(String header) {
        this._includeList.add(header);
    }

    protected String getModuleName(String suffix) {
        String filename = this.getFilename();
        int begin = 0;
        int end = filename.lastIndexOf(suffix);
        String name = "";
        while (begin < end) {
            int index = filename.indexOf(47, begin);
            if (index < 0) {
                index = end;
            }
            name = name + CppEmitter.capitalize(filename.substring(begin, index));
            begin = index + 1;
        }
        return name;
    }

    protected void beginCppFile(String filename) {
        this.beginFile(filename);
        this.emitLine("/******** AUTOMATICALLY GENERATED CODE - DO NOT EDIT ********/");
        this.emitLine();
        this._currentNamespace = "";
    }

    protected void beginHeader(String filename) {
        this.beginCppFile(filename);
        this.emitLine("#pragma once");
        this.emitLine();
    }

    protected void emitIncludes() {
        this.emitIncludes(this._includeList);
    }

    protected void emitIncludes(Iterable<String> list) {
        for (String header : list) {
            this.emitInclude(header);
        }
    }

    protected void emitInclude(String header) {
        this.emitLine("#include <", header, ">");
    }

    protected String getNamespace() {
        return this._currentNamespace;
    }

    protected void setNamespace(String namespace) {
        if (!this._currentNamespace.equals(namespace)) {
            this.emitNamespaceFooter();
            this._currentNamespace = namespace;
            this.emitNamespaceHeader();
        }
    }

    private void emitNamespaceHeader() {
        if (this._currentNamespace.length() > 0) {
            this.emitLine();
            if (this._currentNamespace.equals(kUnnamed)) {
                this.emitLine("namespace {");
            } else {
                for (String ns : this._currentNamespace.split("[.]")) {
                    this.emitLine("namespace " + ns + " {");
                }
            }
            this.emitLine();
        }
    }

    private void emitNamespaceFooter() {
        if (this._currentNamespace.length() > 0) {
            this.emitLine();
            if (this._currentNamespace.equals(kUnnamed)) {
                this.emitLine("} // namespace");
            } else {
                ArrayList<String> nsList = new ArrayList<String>();
                for (String ns : this._currentNamespace.split("[.]")) {
                    nsList.add(0, ns);
                }
                for (String ns : nsList) {
                    this.emitLine("} // namespace " + ns);
                }
            }
            this.emitLine();
        }
    }

    protected TreeSet<Version> getVersionSet(String targetNs) {
        TreeSet<Version> versionSet = new TreeSet<Version>(Versions._comparator);
        for (Version version : Versions.getVersions()) {
            if (!version.getNamespace().equals(targetNs) || Services.schemaNamespaceId(version) == null) continue;
            versionSet.add(version);
        }
        return versionSet;
    }

    protected String formatMethodDecl(Method method) {
        return this.formatMethod(method, null, false);
    }

    protected String formatAsyncMethodDecl(Method method) {
        return this.formatMethod(method, null, true);
    }

    protected void emitMethodDecl(String methodDecl, String apiAuditMsg) {
        if (apiAuditMsg != null) {
            this.emitPartial("APIAUDIT(\"" + apiAuditMsg + "\", ");
            this.emitPartial(methodDecl);
            this.emitPartial(")");
        } else {
            this.emitPartial(methodDecl);
        }
    }

    protected void emitFunctionDecl(String functionDecl, String apiAuditMsg) {
        if (apiAuditMsg != null) {
            this.emitPartial("APIAUDITFUNCTION(\"" + apiAuditMsg + "\", ");
            this.emitPartial(functionDecl);
            this.emitPartial(")");
        } else {
            this.emitPartial(functionDecl);
        }
    }

    protected void emitMethodDef(Method method, String className) {
        this.emitPartial(this.formatMethod(method, className, false));
    }

    protected void emitMethodDef(Method method, String className, boolean async) {
        this.emitPartial(this.formatMethod(method, className, async));
    }

    private String formatMethod(Method method, String className, boolean async) {
        String returnTypeName;
        String typeName;
        String paramName;
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Field field : method.getParameterList()) {
            paramName = field.getName();
            typeName = CppEmitter.getInParamString(field.getDecl());
            paramNames.add(CppEmitter.formatDecl(typeName, paramName));
        }
        if (async) {
            returnTypeName = "void";
            paramNames.add("const Vmomi::Stub::CompletionFunctor& func");
            paramNames.add("Vmacore::Ref<Vmacore::System::ScheduledItem>& si");
        } else {
            VmodlDecl vmodlDecl;
            VmodlDecl vmodlDecl2 = vmodlDecl = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            if (vmodlDecl.isVoid()) {
                returnTypeName = "void";
            } else if (vmodlDecl.isPrimitive() && !vmodlDecl.isArray()) {
                returnTypeName = CppEmitter.getMethodReturnString(vmodlDecl);
            } else {
                returnTypeName = "void";
                paramName = "result /* OUT */";
                typeName = CppEmitter.getOutParamString(vmodlDecl);
                paramNames.add(CppEmitter.formatDecl(typeName, paramName));
            }
        }
        String string = CppEmitter.capitalize(method.getName());
        String result = className == null ? CppEmitter.formatDecl(returnTypeName, string) + "(" + CppEmitter.join(paramNames, ", ") + ")" : returnTypeName + "\n" + className + "::" + string + "(" + CppEmitter.join(paramNames, ", ") + ")";
        return result;
    }

    protected static String formatDecl(String typeName, String declName) {
        return typeName + (typeName.endsWith("*") ? "" : " ") + declName;
    }

    protected static String formatTemplate(String templateName, String typeName) {
        if (typeName.endsWith(">") || typeName.startsWith("::")) {
            return templateName + "< " + typeName + " >";
        }
        return templateName + "<" + typeName + ">";
    }

    protected static String formatPrefix(VmodlDecl decl) {
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                return "Bool";
            }
            case BYTE: {
                return "Byte";
            }
            case SHORT: {
                return "Short";
            }
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case STRING: {
                return "String";
            }
            case DATETIME: {
                return "DateTime";
            }
            case TYPENAME: {
                return "TypeName";
            }
            case METHODNAME: {
                return "MethodName";
            }
            case PROPPATH: {
                return "PropertyPath";
            }
            case URI: {
                return "Uri";
            }
            case BINARY: {
                return "Binary";
            }
            case ANY: {
                return "Any";
            }
            case MANAGED: {
                if (decl.getObject() == null) {
                    return "VmodlManagedObject";
                }
            }
            case ENUM: {
                return CppEmitter.formatPrefix(decl.getObject());
            }
            case DATA: {
                if (decl.isLink()) {
                    return "String";
                }
                return CppEmitter.formatPrefix(decl.getObject());
            }
        }
        throw new RuntimeException("Invalid type");
    }

    protected static String formatPrefix(VmodlObject obj) {
        StringBuffer prefix = new StringBuffer("");
        String vmodlTypeName = obj.getQualifiedVmodlType();
        for (String pkg : vmodlTypeName.split("[.]")) {
            prefix.append(CppEmitter.capitalize(pkg));
        }
        return prefix.toString();
    }

    protected static String formatTypeInfo(VmodlDecl decl) {
        return "g" + CppEmitter.formatPrefix(decl) + "TypeInfo";
    }

    protected static String formatTypeInfo(VmodlObject obj) {
        return "g" + CppEmitter.formatPrefix(obj) + "TypeInfo";
    }

    protected static String formatMethodObjects(ManagedObject obj) {
        return "g" + CppEmitter.formatPrefix(obj) + "MethodObjects";
    }

    protected static String formatTypePtr(VmodlDecl decl) {
        if (decl.isVoid()) {
            return "nullptr";
        }
        return "&" + CppEmitter.formatTypeInfo(decl);
    }

    protected static String formatTypePtr(VmodlObject obj) {
        return "&" + CppEmitter.formatTypeInfo(obj);
    }

    protected static List<String> getPropArgList(VmodlObject obj) {
        VmodlObject baseObj;
        ArrayList<String> argList = new ArrayList<String>();
        if (!obj.getQualifiedVmodlType().equals(Utils.DynamicDataClassName)) {
            for (Property property : obj.getPropertyList()) {
                if (CppEmitter.shouldSkipPropInConstructor(obj, property)) continue;
                argList.add(CppEmitter.getFormalName(property));
            }
        }
        if ((baseObj = obj.getBaseObject()) != null && baseObj.getKind() == VmodlObject.Kind.DataObject) {
            argList.addAll(0, CppEmitter.getPropArgList(baseObj));
        }
        return argList;
    }

    protected static List<String> getPropDeclList(VmodlObject obj) {
        VmodlObject baseObj;
        ArrayList<String> declList = new ArrayList<String>();
        if (!obj.getQualifiedVmodlType().equals(Utils.DynamicDataClassName)) {
            for (Property property : obj.getPropertyList()) {
                if (CppEmitter.shouldSkipPropInConstructor(obj, property)) continue;
                String name = CppEmitter.getFormalName(property);
                VmodlDecl decl = property.getDecl();
                String typeString = CppEmitter.getInParamString(decl);
                declList.add(CppEmitter.formatDecl(typeString, name));
            }
        }
        if ((baseObj = obj.getBaseObject()) != null && baseObj.getKind() == VmodlObject.Kind.DataObject) {
            declList.addAll(0, CppEmitter.getPropDeclList(baseObj));
        }
        return declList;
    }

    protected static List<Property> getConstructorProperties(VmodlObject obj) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (obj != null && obj.getKind() == VmodlObject.Kind.DataObject && !obj.getQualifiedVmodlType().equals(Utils.DynamicDataClassName)) {
            for (Property property : obj.getPropertyList()) {
                if (CppEmitter.shouldSkipPropInConstructor(obj, property)) continue;
                result.add(property);
            }
        }
        return result;
    }

    protected static List<Property> getRecursiveConstructorProperties(VmodlObject obj) {
        ArrayList<Property> result = new ArrayList<Property>();
        VmodlObject baseObj = obj.getBaseObject();
        if (baseObj != null && baseObj.getKind() == VmodlObject.Kind.DataObject) {
            result.addAll(CppEmitter.getRecursiveConstructorProperties(baseObj));
        }
        result.addAll(CppEmitter.getConstructorProperties(obj));
        return result;
    }

    protected static String getMemberName(Property property) {
        if (property.getName().equals("rdtscp")) {
            return "_rdtscp_";
        }
        return "_" + property.getName();
    }

    protected static String getFormalName(Property property) {
        return property.getName() + "_";
    }

    protected static String getTypeString(VmodlDecl.TypeId typeId) {
        switch (typeId) {
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "bool";
            }
            case BYTE: {
                return "int8";
            }
            case SHORT: {
                return "int16";
            }
            case INT: {
                return "int32";
            }
            case LONG: {
                return "int64";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                return "Vmomi::String";
            }
            case DATETIME: {
                return "Vmomi::DateTime";
            }
            case TYPENAME: {
                return "Vmomi::TypeName";
            }
            case METHODNAME: {
                return "Vmomi::MethodName";
            }
            case PROPPATH: {
                return "Vmomi::PropertyPath";
            }
            case URI: {
                return "Vmomi::Uri";
            }
            case BINARY: {
                return "Vmomi::Binary";
            }
        }
        throw new RuntimeException("C++ type unknown for non-primitive typeId");
    }

    protected static String getTypeString(VmodlDecl decl) {
        String typeName = CppEmitter.getBaseTypeString(decl);
        if (!decl.isArray()) {
            if (decl.isValue() && decl.isOptional()) {
                typeName = CppEmitter.formatTemplate("Optional", typeName);
            }
            return typeName;
        }
        if (decl.isValue()) {
            return CppEmitter.formatTemplate("Vmomi::Array", typeName);
        }
        return CppEmitter.formatTemplate("Vmomi::DataArray", typeName);
    }

    protected static String getPeekTypeString(VmodlDecl decl) {
        String typeName = CppEmitter.getBaseTypeString(decl);
        if (decl.isArray()) {
            typeName = decl.isValue() ? CppEmitter.formatTemplate("Vmomi::Array", typeName) : CppEmitter.formatTemplate("Vmomi::DataArray", typeName);
        }
        return typeName;
    }

    protected static String getBaseTypeString(VmodlDecl decl) {
        if (decl.isLink()) {
            return "Vmomi::String";
        }
        if (decl.isData() || decl.isEnum()) {
            return CppEmitter.getQualifiedClassName(decl.getObject());
        }
        if (decl.isAny()) {
            return "Vmomi::Any";
        }
        if (decl.isManaged()) {
            return "Vmomi::MoRef";
        }
        return CppEmitter.getTypeString(decl.getTypeId());
    }

    protected static String getDeclString(VmodlDecl decl) {
        return CppEmitter.getDeclString(decl, true);
    }

    protected static String getDeclString(VmodlDecl decl, boolean useRef) {
        String typeName = CppEmitter.getTypeString(decl);
        if (decl.isSingleValue()) {
            return typeName;
        }
        if (useRef) {
            return CppEmitter.formatTemplate("Ref", typeName);
        }
        return typeName + " *";
    }

    protected static String getClassVariableDeclString(VmodlDecl decl) {
        String typeName = CppEmitter.getTypeString(decl);
        if (decl.isSingleValue()) {
            return typeName;
        }
        if (decl.isArray()) {
            return CppEmitter.formatTemplate("ArrayField", typeName);
        }
        return CppEmitter.formatTemplate("Ref", typeName);
    }

    protected static String getInParamString(VmodlDecl decl) {
        return CppEmitter.getPropertyReturnOrInParamString(decl);
    }

    protected static String getOutParamString(VmodlDecl decl) {
        String typeName = CppEmitter.getTypeString(decl);
        if (decl.isPrimitive() && !decl.isArray()) {
            throw new RuntimeException("Tried to return a primitive as an out param");
        }
        if (decl.isLink()) {
            throw new RuntimeException("Tried to return a link as an out param");
        }
        return CppEmitter.formatTemplate("Ref", typeName) + "&";
    }

    protected static String getPropertyReturnString(VmodlDecl decl) {
        return CppEmitter.getPropertyReturnOrInParamString(decl);
    }

    protected static String getMethodReturnString(VmodlDecl decl) {
        String typeName = CppEmitter.getTypeString(decl);
        if (decl.isPrimitive() && !decl.isArray()) {
            return typeName;
        }
        return typeName + " *";
    }

    private static String getPropertyReturnOrInParamString(VmodlDecl decl) {
        String typeName = CppEmitter.getTypeString(decl);
        if (!decl.isSingleValue()) {
            return typeName + " *";
        }
        if (decl.isOptional() || decl.isLink()) {
            return "const " + typeName + "&";
        }
        switch (decl.getTypeId()) {
            case STRING: 
            case DATETIME: 
            case TYPENAME: 
            case METHODNAME: 
            case PROPPATH: 
            case URI: 
            case BINARY: {
                return "const " + typeName + "&";
            }
        }
        return typeName;
    }

    protected static String getGetPtrPropertyReturnString(VmodlDecl decl) {
        return CppEmitter.getPeekTypeString(decl) + " *";
    }

    protected static String getPeekPropertyReturnString(VmodlDecl decl) {
        return "const " + CppEmitter.getPeekTypeString(decl) + " *";
    }

    protected static String getSwapPropertyInParamString(VmodlDecl decl) {
        if (decl.isSingleValue()) {
            return CppEmitter.getTypeString(decl) + " * const";
        }
        return "Ref< " + CppEmitter.getTypeString(decl) + " > * const";
    }

    protected static String getFullClassName(VmodlObject obj) {
        String fullName = obj.getClassName();
        if (obj.getContainer() != null) {
            fullName = CppEmitter.join(obj.getContainerNameList(), "::") + "::" + fullName;
        }
        return fullName;
    }

    protected static String getFullStubName(ManagedObject mobj) {
        String fullName = CppEmitter.getStubName(mobj);
        if (mobj.getContainer() != null) {
            fullName = CppEmitter.join(mobj.getContainerNameList(), "::") + "::" + fullName;
        }
        return fullName;
    }

    protected static String getQualifiedClassName(VmodlObject obj) {
        return CppEmitter.qualifyClassName(obj, CppEmitter.getFullClassName(obj));
    }

    protected static String getStubName(ManagedObject mobj) {
        return mobj.getClassName() + "Stub";
    }

    protected String getHeaderFile(VmodlObject obj) {
        return this.getHeaderFilePrefix(obj) + ".h";
    }

    protected String getHeaderFilePrefix(VmodlObject obj) {
        String className;
        if (obj.getContainer() != null) {
            obj = obj.getContainer();
        }
        if ((className = CppEmitter.getQualifiedClassName(obj)).startsWith("::")) {
            className = className.replaceFirst("::", "");
        }
        String filename = className.replaceAll("::", "/");
        return this._headersDir + filename;
    }

    protected static String getQualifiedStubName(ManagedObject mobj) {
        return CppEmitter.qualifyClassName(mobj, CppEmitter.getFullStubName(mobj));
    }

    private static String qualifyClassName(VmodlObject obj, String className) {
        String namespace = obj.getNamespace();
        if (namespace.length() > 0) {
            className = namespace.replace(".", "::") + "::" + className;
        }
        return "::" + className;
    }

    protected static boolean shouldSkipPropInConstructor(VmodlObject obj, Property prop) {
        return obj.isFault() && (CppEmitter.getFormalName(prop).equals("faultCause_") || CppEmitter.getFormalName(prop).equals("faultMessage_"));
    }

    protected void emitValidation(String val, int propIndex) {
        this.emitLine("DEBUG_ONLY(Vmomi::Validate(" + val + ", this, " + Integer.toString(propIndex) + "));");
    }

    protected void emitComment(String comment) {
        this.emitComment(comment, null);
    }

    protected void emitComment(String comment, String supplementalComment) {
        this.emitGap();
        if (comment != null && (comment = comment.trim()).length() == 0) {
            comment = null;
        }
        if (supplementalComment != null && (supplementalComment = supplementalComment.trim()).length() == 0) {
            supplementalComment = null;
        }
        Pattern genericEol = Pattern.compile("\r\n?|\n");
        if (comment != null || supplementalComment != null) {
            this.emitLine("/**");
            if (comment != null) {
                for (String line : genericEol.split(comment)) {
                    this.emitLine(" * " + line);
                }
            }
            if (supplementalComment != null) {
                for (String line : genericEol.split(supplementalComment)) {
                    this.emitLine(" * " + line);
                }
            }
            this.emitLine(" */");
        }
    }

    protected String getVersionsHeader() {
        return this._headersDir + this._capitalizedNamespace.replace(".", "/") + "/Versions.h";
    }
}

