/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.cpp;

import emitters.NsVersionAliases;
import emitters.Services;
import emitters.Versions;
import emitters.backend.Platform;
import emitters.bindings.cpp.CppEmitter;
import emitters.model.DataObject;
import emitters.model.DataProperty;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CppImplementationEmitter
extends CppEmitter {
    private final String _cppDirectory;
    private final boolean _alwaysEmitVersionInfo;

    public CppImplementationEmitter(Map<String, String> options, String directory) {
        super(options);
        this._cppDirectory = directory;
        this._alwaysEmitVersionInfo = CppImplementationEmitter.parseOptionalBoolean(options.get("always.emit.version.info"), false);
        String headerDir = options.get("hpp.dir");
        if (headerDir == null) {
            throw new RuntimeException("The headers directory is mandatory for C++ emitters");
        }
        this.setHeadersDir(headerDir);
        this.addHeader("vmomi/emitter.h");
        this.addHeader("vmomi/client.h");
        this.addHeader("vmomi/Validator.h");
        this.addHeader("vmomi/MethodFault.h");
        if (this._apiHeaderFile != null) {
            this.addHeader(this._apiHeaderFile);
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (String header : this.findHeaderSet(objects)) {
            this.addHeader(header);
        }
        this.beginImplFile("typeinfo.cpp");
        VmodlObjects vmodlObjects = new VmodlObjects(objects);
        Collection<DataObject> dataObjects = vmodlObjects.getDataObjects();
        Iterable<Enum> enumObjects = vmodlObjects.getEnums();
        Collection<ManagedObject> managedObjects = vmodlObjects.getManagedObjects();
        for (DataObject dobj : dataObjects) {
            this.emitDataObjectTypeInfo(dobj);
        }
        this.emitDataObjectTypeInfoArray(dataObjects);
        for (Enum eobj : enumObjects) {
            this.emitEnumObjectTypeInfo(eobj);
        }
        for (ManagedObject mobj : managedObjects) {
            this.emitManagedObjectTypeInfo(mobj);
        }
        for (ManagedObject obj : managedObjects) {
            this.setNamespace("");
            this.emitStubFactory(obj);
            this.emitManagedTypeInfo(obj);
        }
        int numTypes = vmodlObjects.getNumTypes();
        if (numTypes > 0) {
            this.setNamespace("unnamed namespace sentinel");
            this.emitLine("Type * sTypes[", Integer.toString(numTypes), "];");
            this.emitLine();
            this.emitGetTypes(vmodlObjects);
            this.emitGetTypeSpecializations(vmodlObjects);
        }
        this.emitVersionsInfo();
        if (numTypes > 0) {
            this.setNamespace("unnamed namespace sentinel");
            this.emitLine("const TypeInfoLoader sTypeInfoLoader(&", this._capitalizedNamespace.replace(".", "::"), "::sVmodlVersions, getTypes);");
        }
        this.endImplFile();
        this.beginImplFile("stub.cpp");
        this.setNamespace("");
        for (ManagedObject managedObject : managedObjects) {
            int methodCount = managedObject.getMethodList().size() + managedObject.getPropertyListWithOverrides().size();
            this.emitLine("ManagedMethod *", CppImplementationEmitter.formatMethodObjects(managedObject), "[", Integer.toString(methodCount + 1), "];");
        }
        this.emitLine();
        for (ManagedObject managedObject : managedObjects) {
            if (managedObject.getContainer() != null) continue;
            this.setNamespace(managedObject.getNamespace());
            this.emitManagedObjectStubImpl(managedObject);
            this.emitLine();
        }
        this.endImplFile();
        this.beginImplFile("impl.cpp");
        for (DataObject dataObject : dataObjects) {
            this.setNamespace(dataObject.getNamespace());
            this.emitDataObjectImpl(dataObject);
            this.emitDataObjectTypeMethod(dataObject);
        }
        for (ManagedObject managedObject : managedObjects) {
            this.setNamespace(managedObject.getNamespace());
            this.emitManagedObjectTypeMethod(managedObject);
        }
        for (ManagedObject managedObject : managedObjects) {
            if (managedObject.getContainer() != null) continue;
            this.setNamespace(managedObject.getNamespace());
            this.emitMethodNameConstants(managedObject);
        }
        for (Enum enum_ : enumObjects) {
            this.setNamespace(enum_.getNamespace());
            this.emitEnumConstants(enum_);
        }
        this.endImplFile();
    }

    private void emitGetTypeSpecializations(VmodlObjects vmodlObjects) {
        this.setNamespace("Vmomi");
        GetTypeEmitter getTypeEmitter = new GetTypeEmitter();
        getTypeEmitter.setup("DataObjectType *", "GetDoType");
        for (VmodlObject vmodlObject : vmodlObjects.getDataObjects()) {
            getTypeEmitter.emit(vmodlObject);
        }
        getTypeEmitter.setup("EnumType *", "GetEnumType");
        for (VmodlObject vmodlObject : vmodlObjects.getEnums()) {
            getTypeEmitter.emit(vmodlObject);
        }
        getTypeEmitter.setup("ManagedObjectType *", "GetMoType");
        for (VmodlObject vmodlObject : vmodlObjects.getManagedObjects()) {
            getTypeEmitter.emit(vmodlObject);
        }
    }

    private void emitVersionsInfo() {
        boolean hasParentNamespaces;
        this.setNamespace(this._capitalizedNamespace);
        this.emitLine("extern const VmodlVersions sVmodlVersions;");
        if (this.shouldSkipVersionsLoader()) {
            return;
        }
        TreeSet<Version> versionSet = this.getVersionSet(this._targetNs);
        int numVersions = versionSet.size();
        int disabledCount = 0;
        boolean offsetKnown = false;
        int offset = 0;
        this.setNamespace("unnamed namespace sentinel");
        this.emitLine("const VersionInfo sVersions[] = {", INDENT);
        for (Version version : versionSet.descendingSet()) {
            String printableWireId = version.getPrintableWireId();
            VmodlDecl vmodlDecl = Method.taskReturnDecl();
            String taskReturnTypeName = vmodlDecl == null ? "" : vmodlDecl.getObject().getQualifiedVmodlType();
            String serviceNamespace = Services.schemaNamespaceId(version);
            this.emitLine("{", CppImplementationEmitter.qq(version.getVmodlName()), ", ", CppImplementationEmitter.qq(version.getWireNs()), ", ", CppImplementationEmitter.qq(printableWireId), ", ", CppImplementationEmitter.qq(taskReturnTypeName), ", ", CppImplementationEmitter.qq(serviceNamespace), ", ", this.versionKind(version), ", ", this.versionAttributes(version), "},");
            Version.Kind kind = version.getKind();
            if (kind == Version.Kind.DISABLED) {
                ++disabledCount;
                continue;
            }
            if (offsetKnown || kind == Version.Kind.FEATURE) continue;
            if (this.isNewestVersion(version)) {
                offsetKnown = true;
                continue;
            }
            ++offset;
        }
        this.emitLine(UNINDENT, "};");
        int numParents = 0;
        HashSet<String> parentNamespaces = new HashSet<String>();
        this.emitLine("const VersionParent sParents[] = {", INDENT);
        for (Version version : versionSet) {
            Set<Version> directParents = Versions.getSortedDirectParents(version);
            numParents += directParents.size();
            for (Version parent : directParents) {
                if (!version.isAncestor(parent)) continue;
                String parentNs = parent.getNamespace();
                if (!parentNs.equals(this._targetNs)) {
                    parentNamespaces.add(parentNs);
                }
                this.emitLine("{", CppImplementationEmitter.qq(version.getVmodlName()), ", ", CppImplementationEmitter.qq(parent.getVmodlName()), "},");
            }
        }
        this.emitLine(UNINDENT, "};");
        boolean bl = hasParentNamespaces = !parentNamespaces.isEmpty();
        if (hasParentNamespaces) {
            this.emitLine("const char * sParentNamespaces[] = {", INDENT);
            for (String parentNs : parentNamespaces) {
                this.emitLine(CppImplementationEmitter.qq(parentNs), ",");
            }
            this.emitLine(UNINDENT, "};");
        }
        this.setNamespace("");
        this.emitInclude(this.getVersionsHeader());
        this.setNamespace(this._capitalizedNamespace);
        if (!this._apiName.equals("VMODL_HOSTD_API")) {
            this.emitLine("NamespaceId vmodlNamespaceId;");
            this.emitLine("const PublicVersion *vmodlNsPublicVersions[", Integer.toString(numVersions - disabledCount), "];");
            this.emitLine("const InternalVersion *vmodlNsInternalVersions[", Integer.toString(numVersions - disabledCount), "];");
            this.emitLine();
        }
        NsVersionAliases nsVersionAliases = Versions.getNsVersionAliases();
        this.emitLine("const VmodlVersions sVmodlVersions = {", INDENT);
        this.emitLine(CppImplementationEmitter.qq(this._targetNs), ", &vmodlNamespaceId,");
        this.emitLine(hasParentNamespaces ? "sParentNamespaces" : "nullptr", ", sVersions, sParents", ", vmodlNsPublicVersions, vmodlNsInternalVersions");
        this.emitLine(", ", Integer.toString(parentNamespaces.size()), ", ", Integer.toString(numVersions), ", ", Integer.toString(numParents));
        this.emitLine(", ", Integer.toString(nsVersionAliases.newestVersionIndex + offset), ", ", Integer.toString(nsVersionAliases.ltsVersionIndex + offset), ", ", Integer.toString(nsVersionAliases.oldestVersionIndex + offset));
        Version legacyIt = nsVersionAliases.oldestVersion;
        int legacyIndex = nsVersionAliases.oldestVersionIndex + offset;
        while (legacyIt != null && !legacyIt.isLegacy()) {
            legacyIt = legacyIt.getNsLtsParent();
            ++legacyIndex;
        }
        this.emitLine(", ", Integer.toString(legacyIt != null ? legacyIndex : -1));
        this.emitLine(UNINDENT, "};");
    }

    private boolean shouldSkipVersionsLoader() {
        String[] nsElements;
        if (this._targetNs.equals("vmodl") && this._cppDirectory.equals("vmodl/core")) {
            return false;
        }
        if (this._cppDirectory.equals("hostd")) {
            return false;
        }
        if (this._alwaysEmitVersionInfo) {
            return false;
        }
        String[] pathElements = this._cppDirectory.split("/|\\\\");
        if (pathElements.length > (nsElements = this._targetNs.split("\\.")).length) {
            return true;
        }
        Collections.reverse(Arrays.asList(pathElements));
        Collections.reverse(Arrays.asList(nsElements));
        for (int i = 0; i < pathElements.length; ++i) {
            if (pathElements[i].equalsIgnoreCase(nsElements[i])) continue;
            return true;
        }
        return false;
    }

    private String versionKind(Version version) {
        switch (version.getKind()) {
            case LTS: {
                return "VersionKind::kLts";
            }
            case DEV: {
                return "VersionKind::kDev";
            }
            case FEATURE: {
                return "VersionKind::kFeature";
            }
            case DISABLED: {
                return "VersionKind::kDisabled";
            }
        }
        throw new RuntimeException("Unhandled version kind: " + (Object)((Object)version.getKind()));
    }

    private String versionAttributes(Version version) {
        StringBuilder attributes = new StringBuilder();
        if (version.isLegacy()) {
            this.addAttribute(attributes, "VersionAttr::kLegacy");
        }
        if (Versions.getTwoOperationsForTaskMethod()) {
            this.addAttribute(attributes, "VersionAttr::kHasTwoOpsForTasks");
        }
        return attributes.length() != 0 ? attributes.toString() : "VersionAttr::kNone";
    }

    private void addAttribute(StringBuilder attributes, String attr) {
        if (attributes.length() > 0) {
            attributes.append(" | ");
        }
        attributes.append(attr);
    }

    private boolean isNewestVersion(Version version) {
        Version targetVersion = Versions.getTargetVersion();
        if (targetVersion.getKind() != Version.Kind.DISABLED) {
            return version == targetVersion;
        }
        Version.Kind kind = version.getKind();
        return Platform.builtOnMain() ? kind == Version.Kind.DEV : kind == Version.Kind.LTS;
    }

    private void emitGetTypes(VmodlObjects vmodlObjects) {
        this.emitLine("Type * const *getTypes(int& size)");
        this.emitLine("{", INDENT);
        int index = vmodlObjects.getDataObjects().size();
        if (index != 0) {
            this.emitLine("for (unsigned int i = 0; i < sizeof(sDataTypeInfo) / sizeof(sDataTypeInfo[0]); ++i) {");
            this.indent();
            this.emitTypeArrayInitializerPrefix("i");
            this.emitLine("CreateDataObjectType(&sDataTypeInfo[i]);");
            this.unindent();
            this.emitLine("}");
        }
        for (VmodlObject vmodlObject : vmodlObjects.getEnums()) {
            this.emitTypeArrayInitializerPrefix(index++);
            this.emitLine(CppImplementationEmitter.formatTemplate("CreateEnumType", CppImplementationEmitter.getQualifiedClassName(vmodlObject)), "(&s", CppImplementationEmitter.formatPrefix(vmodlObject), "EnumInfo);");
        }
        for (VmodlObject vmodlObject : vmodlObjects.getManagedObjects()) {
            this.emitTypeArrayInitializerPrefix(index++);
            this.emitLine("CreateManagedObjectType(&s", CppImplementationEmitter.formatPrefix(vmodlObject), "ManagedInfo);");
        }
        this.emitLine("size = ", Integer.toString(vmodlObjects.getNumTypes()), ";");
        this.emitLine("return sTypes;");
        this.emitLine(UNINDENT, "};");
        this.emitLine();
    }

    private void emitTypeArrayInitializerPrefix(int index) {
        this.emitPartial("sTypes[", Integer.toString(index++), "] = ");
    }

    private void emitTypeArrayInitializerPrefix(String index) {
        this.emitPartial("sTypes[", index, "] = ");
    }

    private void emitDataObjectTypeInfo(DataObject dobj) {
        this.emitType(dobj, dobj.isFault() ? "Type::FAULT" : "Type::DATA_OBJECT");
        this.emitDataProperties(dobj);
        this.emitGetMethod(dobj);
        this.emitPeekMethod(dobj);
        this.emitSetMethod(dobj);
        this.emitSwapMethod(dobj);
        this.emitIsSetMethod(dobj);
        this.emitUnsetMethod(dobj);
        this.emitFactoryMethods(dobj);
        this.emitLine();
    }

    private void emitEnumObjectTypeInfo(Enum eobj) {
        this.emitType(eobj, "Type::ENUM");
        this.emitEnumTypeInfo(eobj);
        this.emitLine();
    }

    private void emitManagedObjectTypeInfo(ManagedObject mobj) {
        this.emitType(mobj, "Type::MOREF");
        this.emitMethodInfo(mobj);
        this.emitMethodsAndProperties(mobj);
        this.emitPropertyIndexLookupMethod(mobj);
        this.emitDispatchMethod(mobj);
        this.emitLine();
    }

    private void emitGetMethod(DataObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.emitLine("static void");
        this.emitLine("s", CppImplementationEmitter.formatPrefix(obj), "Get(DataObject *dobj, int id, void *valueOut)");
        this.emitLine("{");
        this.indent();
        String typePtr = CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
        this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj"), " =");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr), "(dobj);");
        this.unindent();
        this.emitLine("switch (id) {");
        for (Property p : obj.getPropertyList()) {
            DataProperty property = (DataProperty)p;
            VmodlDecl decl = property.getDecl();
            String cast = !decl.isSingleValue() ? "(Ref<Any> *)" : (decl.isEnum() ? "(" + CppImplementationEmitter.getQualifiedClassName(decl.getObject()) + " *)" : (decl.isLink() ? "(Vmomi::String *)" : "(" + CppImplementationEmitter.getTypeString(decl.getTypeId()) + " *)"));
            this.emitLine("case ", Integer.toString(property.getPropIndex()), ": *", cast, "valueOut = _obj->", property.getAccessor().getName(), "(); break;");
        }
        this.emitLine("default: NOT_REACHED();");
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitPeekMethod(DataObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        this.emitLine("static const void *");
        this.emitLine("s", CppImplementationEmitter.formatPrefix(obj), "Peek(const DataObject * const dobj, int id)");
        this.emitLine("{");
        this.indent();
        String typePtr = "const " + CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
        this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj"), " =");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr), "(dobj);");
        this.unindent();
        int propertyId = 0;
        this.emitLine("switch (id) {");
        for (Property property : obj.getPropertyList()) {
            this.emitLine("case ", Integer.toString(propertyId), ": return _obj->", property.getPeeker().getName(), "()", ";");
            ++propertyId;
        }
        this.emitLine("default: NOT_REACHED();");
        this.emitLine("}");
        this.emitLine("return nullptr;");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitSetMethod(DataObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static void");
        this.emitLine("s", typePrefix, "Set(DataObject *dobj, int id, void *valuePtr)");
        this.emitLine("{");
        this.indent();
        String typePtr = CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
        this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj"), " =");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr), "(dobj);");
        this.unindent();
        int propertyId = 0;
        this.emitLine("switch (id) {");
        for (Property property : obj.getPropertyList()) {
            String valueExpr;
            VmodlDecl decl = property.getDecl();
            if (!decl.isSingleValue()) {
                valueExpr = this.formatNarrow(decl, "(*(Any **)valuePtr)");
            } else if (decl.isEnum()) {
                VmodlObject propObj = decl.getObject();
                valueExpr = "*(" + CppImplementationEmitter.getQualifiedClassName(propObj) + " *)valuePtr";
            } else {
                valueExpr = decl.isLink() ? "*(Vmomi::String *)valuePtr" : "*(" + CppImplementationEmitter.getTypeString(decl.getTypeId()) + " *)valuePtr";
            }
            this.emitLine("case ", Integer.toString(propertyId), ": ", "_obj->", property.getMutator().getName(), "(", valueExpr, "); ", "break;");
            ++propertyId;
        }
        this.emitLine("default: NOT_REACHED();");
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitSwapMethod(DataObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static void");
        this.emitLine("s", typePrefix, "Swap(DataObject * const dobj, int id, void * const ptrValueInOut)");
        this.emitLine("{");
        this.indent();
        String typePtr = CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
        this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj") + " =");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr) + "(dobj);");
        this.unindent();
        int propertyId = 0;
        this.emitLine("switch (id) {");
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            String paramType = CppImplementationEmitter.getSwapPropertyInParamString(decl);
            String valueExpr = CppImplementationEmitter.formatTemplate("static_cast", paramType) + "(ptrValueInOut)";
            this.emitLine("case ", Integer.toString(propertyId), ": ", "_obj->", property.getSwapper().getName(), "(", valueExpr, "); ", "break;");
            ++propertyId;
        }
        this.emitLine("default: NOT_REACHED();");
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitIsSetMethod(DataObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static bool");
        this.emitLine("s", typePrefix, "IsSet(const DataObject *dobj, int id)");
        this.emitLine("{");
        this.indent();
        boolean hasCase = false;
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            if (!decl.isOptional() && decl.isSingleValue()) continue;
            hasCase = true;
            break;
        }
        if (hasCase) {
            String typePtr = "const " + CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
            this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj"), " =");
            this.indent();
            this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr), "(dobj);");
            this.unindent();
            int propertyId = 0;
            this.emitLine("switch (id) {");
            for (Property property : obj.getPropertyList()) {
                VmodlDecl decl = property.getDecl();
                if (decl.isOptional() || !decl.isSingleValue()) {
                    String valueExpr;
                    String accessorName = property.getAccessor().getName();
                    if (decl.isArray()) {
                        DataProperty p = (DataProperty)property;
                        valueExpr = "return _obj->" + p.getIsSet().getName() + "();";
                    } else {
                        valueExpr = decl.isValue() ? "return _obj->" + accessorName + "().HasValue();" : "return _obj->" + accessorName + "() != nullptr;";
                    }
                    this.emitLine("case ", Integer.toString(propertyId), ": ", valueExpr);
                }
                ++propertyId;
            }
            this.emitLine("default:");
            this.indent();
            this.emitLine("// All other properties are non-optional primitives");
            this.emitLine("return true;");
            this.unindent();
            this.emitLine("}");
        } else {
            this.emitLine("// All properties are non-optional primitives");
            this.emitLine("return true;");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitUnsetMethod(DataObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        boolean hasOptional = false;
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            if (!decl.isOptional()) continue;
            hasOptional = true;
            break;
        }
        if (!hasOptional) {
            return;
        }
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static void");
        this.emitLine("s", typePrefix, "Unset(DataObject *dobj, int id)");
        this.emitLine("{");
        this.indent();
        String typePtr = CppImplementationEmitter.getQualifiedClassName(obj) + " * const";
        this.emitLine(CppImplementationEmitter.formatDecl(typePtr, "_obj"), " =");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTemplate("static_cast", typePtr), "(dobj);");
        this.unindent();
        int propertyId = 0;
        this.emitLine("switch (id) {");
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            if (decl.isOptional()) {
                String valueExpr;
                if (decl.isValue() && !decl.isArray()) {
                    String unsetterName = property.getUnsetter().getName();
                    valueExpr = "_obj->" + unsetterName + "();";
                } else {
                    String mutatorName = property.getMutator().getName();
                    valueExpr = "_obj->" + mutatorName + "(nullptr);";
                }
                this.emitLine("case ", Integer.toString(propertyId), ": ", valueExpr, " break;");
            }
            ++propertyId;
        }
        this.emitLine("default:");
        this.indent();
        this.emitLine("// All other properties are non-optional");
        this.emitLine("NOT_REACHED();");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitPropertyIndexLookupMethod(VmodlObject obj) {
        if (!obj.hasProperties()) {
            return;
        }
        TreeMap<Integer, List<Pair>> data = new TreeMap<Integer, List<Pair>>();
        int index = 0;
        for (String name : this.listProperties(obj)) {
            int size = name.length();
            List<Pair> pairs = data.get(size);
            if (pairs == null) {
                pairs = new ArrayList<Pair>();
                data.put(size, pairs);
            }
            boolean alreadyExisting = false;
            for (Pair pair : pairs) {
                if (!pair.label.equals(name)) continue;
                alreadyExisting = true;
                break;
            }
            if (alreadyExisting) continue;
            pairs.add(new Pair(name, Integer.toString(index++)));
        }
        this.emitIndexLookupMethod(obj, data);
    }

    private List<String> listProperties(VmodlObject obj) {
        VmodlObject baseObject = obj.getBaseObject();
        List<Object> properties = baseObject == null ? new ArrayList() : this.listProperties(baseObject);
        for (Property property : obj.getPropertyListWithOverrides()) {
            properties.add(property.getName());
        }
        return properties;
    }

    private void emitFactoryMethods(DataObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        String className = CppImplementationEmitter.getQualifiedClassName(obj);
        this.emitLine("static DataObject *");
        this.emitLine("s", typePrefix, "Factory()");
        this.emitLine("{");
        this.emitLine("   return new ", CppImplementationEmitter.getQualifiedClassName(obj), "();");
        this.emitLine("}");
        this.emitLine();
        this.emitLine("static DataArrayBase *");
        this.emitLine("s", typePrefix, "ArrayFactory()");
        this.emitLine("{");
        this.emitLine("   return new ", CppImplementationEmitter.formatTemplate("DataArray", className), "();");
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDispatchMethod(ManagedObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        String dispatchName = "s" + typePrefix + "Dispatch";
        String typeName = CppImplementationEmitter.getQualifiedClassName(obj);
        this.emitLine("static void");
        this.emitLine(dispatchName, "(ManagedObject *mobj, int id, ", "RefVector<Any>& params, Ref<Any>& resultObj /* OUT */)");
        this.emitLine("{");
        this.indent();
        this.emitLine("resultObj = nullptr;");
        if (!obj.getEnabledMethodList().isEmpty() || !obj.getPropertyListWithOverrides().isEmpty()) {
            this.emitLine(CppImplementationEmitter.formatDecl(typeName + " *", "_obj") + " = " + CppImplementationEmitter.formatTemplate("NarrowToType", typeName) + "(mobj);");
            int methodId = 0;
            this.emitLine("switch (id) {");
            for (Method method : obj.getMethodList()) {
                if (method.getVersion().getKind() != Version.Kind.DISABLED) {
                    this.emitMethodDispatchCase(method, methodId);
                }
                ++methodId;
            }
            for (Property property : obj.getPropertyListWithOverrides()) {
                this.emitMethodDispatchCase(property.getAccessor(), methodId++);
            }
            this.emitLine("default: NOT_REACHED();");
            this.emitLine("}");
        } else {
            this.emitLine("// No methods defined for type");
            this.emitLine("NOT_REACHED();");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitType(VmodlObject obj, String kind) {
        this.emitLine(CppImplementationEmitter.formatDecl("const TypeInfo", CppImplementationEmitter.formatTypeInfo(obj)), " = {", kind, ", ", CppImplementationEmitter.qq(obj.getQualifiedVmodlType()), ", ", CppImplementationEmitter.qq(obj.getWsdlName()), ", ", CppImplementationEmitter.qq(obj.getVersion().getVmodlName()), "};");
    }

    private void emitDataProperties(DataObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static const MemberEntityDecl s" + typePrefix + "Properties[] = {");
        this.indent();
        for (Property property : obj.getPropertyList()) {
            String typeExpr = property.getDecl().isLink() ? CppImplementationEmitter.formatTypePtr(property.getDecl().getObject()) : CppImplementationEmitter.formatTypePtr(property.getDecl());
            String privId = property.getPrivilegeId();
            this.emitLine("{" + typeExpr + ", " + this.formatFlags(property) + ", " + CppImplementationEmitter.qq(property.getName()) + ", " + (privId != null ? CppImplementationEmitter.qq(privId) : "nullptr") + ", " + CppImplementationEmitter.qq(property.getVersion().getVmodlName()) + "}, ");
        }
        this.emitLine("{}");
        this.unindent();
        this.emitLine("};");
        this.emitLine();
    }

    private void emitMethodInfo(ManagedObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        for (Method method : obj.getMethodList()) {
            String paramInfo = "s" + typePrefix + CppImplementationEmitter.capitalize(method.getName()) + "Params";
            this.emitLine("static const NamedEntityDecl " + paramInfo + "[] = {");
            this.indent();
            for (Parameter parameter : method.getParameterList()) {
                this.emitLine(this.formatTypeInit(parameter.getDecl(), parameter.getName(), parameter.getPrivilegeId(), parameter.getVersion()) + ",");
            }
            this.emitLine("{}");
            this.unindent();
            this.emitLine("};");
            String faultInfo = "s" + typePrefix + CppImplementationEmitter.capitalize(method.getName()) + "Faults";
            this.emitLine("static const TypeInfo * const ", faultInfo, "[] = {");
            this.indent();
            for (DataObject faultObj : method.getFaultList()) {
                this.emitLine("&", CppImplementationEmitter.formatTypeInfo(faultObj), ",");
            }
            this.emitLine("nullptr");
            this.unindent();
            this.emitLine("};");
            Map<String, String> map = method.getSubclassPrivileges();
            if (map != null) {
                String privInfo = "s" + typePrefix + CppImplementationEmitter.capitalize(method.getName()) + "SubclassPrivileges";
                this.emitLine("static const SubclassPrivilegeTypeInfo " + privInfo + "[] = {");
                this.indent();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.emitLine("{" + CppImplementationEmitter.qq(entry.getKey()) + ", " + CppImplementationEmitter.qq(entry.getValue()) + "},");
                }
                this.emitLine("{nullptr, nullptr}");
                this.unindent();
                this.emitLine("};");
            }
            this.emitLine();
        }
    }

    private void emitMethodsAndProperties(ManagedObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        this.emitLine("static const MethodTypeInfo s", typePrefix, "Methods[] = {");
        this.indent();
        for (Method method : obj.getMethodList()) {
            String methodName = method.getName();
            String wsdlMethodName = method.getWsdlName();
            String privId = method.getPrivilegeId();
            if (privId == null && method.isDynamicPrivs()) {
                privId = "dynamic";
            }
            String paramInfo = "s" + typePrefix + CppImplementationEmitter.capitalize(methodName) + "Params";
            String faultInfo = "s" + typePrefix + CppImplementationEmitter.capitalize(methodName) + "Faults";
            String privInfo = method.getSubclassPrivileges() != null ? "s" + typePrefix + CppImplementationEmitter.capitalize(methodName) + "SubclassPrivileges" : "nullptr";
            Version returnVersion = Versions._vmodlVersion0;
            if (method.getReturnDecl().getObject() != null) {
                returnVersion = method.getReturnDecl().getObject().getVersion();
            }
            this.emitLine("{" + CppImplementationEmitter.qq(methodName) + ", " + CppImplementationEmitter.qq(wsdlMethodName) + ", " + (privId != null ? CppImplementationEmitter.qq(privId) : "nullptr") + ", " + privInfo + ", " + this.formatTypeInit(method.getReturnDecl(), "result", null, returnVersion) + ", " + paramInfo + ", " + faultInfo + ", " + (method.isTask() ? "true" : "false") + ", " + (method.isInternal() ? "true" : "false") + ", " + CppImplementationEmitter.qq(method.getVersion().getVmodlName()) + "},");
        }
        this.emitLine("{}");
        this.unindent();
        this.emitLine("};");
        this.emitLine();
        this.emitLine("static const MemberEntityDecl s" + typePrefix + "Properties[] = {");
        this.indent();
        for (Property property : obj.getPropertyListWithOverrides()) {
            String privId = ((ManagedProperty)property).getPrivilegeId();
            this.emitLine("{" + CppImplementationEmitter.formatTypePtr(property.getDecl()) + ", " + this.formatFlags(property) + ", " + CppImplementationEmitter.qq(property.getName()) + ", " + (privId != null ? CppImplementationEmitter.qq(privId) : "nullptr") + ", " + CppImplementationEmitter.qq(property.getVersion().getVmodlName()) + "}, ");
        }
        this.emitLine("{}");
        this.unindent();
        this.emitLine("};");
        this.emitLine();
    }

    private void emitIndexLookupMethod(VmodlObject obj, Map<Integer, List<Pair>> data) {
        this.emitLine("static int");
        this.emitLine("s", CppImplementationEmitter.formatPrefix(obj), "PropertyIndexLookup(const char * const key, const int size)");
        this.emitLine("{");
        this.indent();
        this.emitIndexLookup(data);
        this.emitLine("return -1;");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitIndexLookup(Map<Integer, List<Pair>> data) {
        if (data.isEmpty()) {
            return;
        }
        this.emitLine("switch (size) {");
        for (Map.Entry<Integer, List<Pair>> entry : data.entrySet()) {
            int keySize = entry.getKey();
            List<Pair> pairs = entry.getValue();
            this.emitLine("case ", Integer.toString(keySize), ":");
            this.indent();
            this.emitPairsRecognition(keySize, pairs);
            this.unindent();
        }
        this.emitLine("}");
    }

    private void emitPairsRecognition(int keySize, List<Pair> pairs) {
        if (pairs.size() == 1) {
            this.emitIndexLookupMethodCompareCase(pairs.get(0));
            return;
        }
        AnalysisResult analysisResult = this.analyzePairs(keySize, pairs);
        int index = analysisResult.index;
        this.emitLine("switch (key[" + index + "]) {");
        for (Pair pair : analysisResult.unique) {
            this.emitLine("case '", pair.label.substring(index, index + 1), "':");
            this.indent();
            this.emitIndexLookupMethodCompareCase(pair);
            this.unindent();
        }
        if (analysisResult.multiple != null) {
            for (List list : analysisResult.multiple) {
                Pair pair = (Pair)list.get(0);
                this.emitLine("case '", pair.label.substring(index, index + 1), "':");
                this.indent();
                this.emitPairsRecognition(keySize, list);
                this.unindent();
            }
        }
        this.emitLine("}");
        this.emitLine("break;");
    }

    private AnalysisResult analyzePairs(int keySize, List<Pair> pairs) {
        int counterSize = 77;
        int bestResult = 1;
        int bestIndex = 0;
        byte[] bestCharCount = null;
        for (int index = 0; index < keySize; ++index) {
            byte[] charCount = new byte[77];
            int uniqueCount = 0;
            for (Pair pair : pairs) {
                int countIndex = pair.label.charAt(index) - 46;
                if (charCount[countIndex] == 0) {
                    ++uniqueCount;
                }
                int n = countIndex;
                charCount[n] = (byte)(charCount[n] + 1);
            }
            if (uniqueCount == pairs.size()) {
                return new AnalysisResult(index, pairs);
            }
            if (uniqueCount <= bestResult) continue;
            bestIndex = index;
            bestCharCount = charCount;
            bestResult = uniqueCount;
        }
        ArrayList<Pair> unique = new ArrayList<Pair>();
        TreeMap<Integer, ArrayList<Pair>> multiple = new TreeMap<Integer, ArrayList<Pair>>();
        for (Pair pair : pairs) {
            int countIndex = pair.label.charAt(bestIndex) - 46;
            if (bestCharCount[countIndex] == 1) {
                unique.add(pair);
                continue;
            }
            ArrayList<Pair> list = (ArrayList<Pair>)multiple.get(countIndex);
            if (list == null) {
                list = new ArrayList<Pair>();
                multiple.put(countIndex, list);
            }
            list.add(pair);
        }
        return new AnalysisResult(bestIndex, unique, multiple.values());
    }

    private void emitIndexLookupMethodCompareCase(Pair pair) {
        String label = pair.label;
        this.emitLine("/* ", label, " */");
        this.emitIndexLookupMethodValueCompare(label);
        this.indent();
        this.emitLine("return ", pair.value, ";");
        this.unindent();
        this.emitLine("break;");
    }

    private void emitIndexLookupMethodValueCompare(String value) {
        int size = value.length();
        int i = 0;
        this.emitPartial("if (true");
        this.indent();
        while (i + 8 <= size) {
            this.emitHexString8(value, i);
            i += 8;
        }
        int stepsBack = 0;
        switch (size - i) {
            case 1: {
                this.emitHexString1(value, i);
                break;
            }
            case 2: {
                this.emitHexString2(value, i);
                break;
            }
            case 3: {
                if (i < 4) {
                    this.emitHexString2(value, i);
                    this.emitHexString1(value, i + 2);
                    break;
                }
                ++stepsBack;
            }
            case 4: {
                this.emitHexString4(value, i - stepsBack);
                break;
            }
            case 5: {
                if (i < 8) {
                    this.emitHexString4(value, i);
                    this.emitHexString1(value, i + 4);
                    break;
                }
                ++stepsBack;
            }
            case 6: {
                if (i < 8) {
                    this.emitHexString4(value, i);
                    this.emitHexString2(value, i + 4);
                    break;
                }
                ++stepsBack;
            }
            case 7: {
                if (i < 8) {
                    this.emitHexString4(value, i);
                    this.emitHexString2(value, i + 4);
                    this.emitHexString1(value, i + 6);
                    break;
                }
                this.emitHexString8(value, i - ++stepsBack);
            }
        }
        this.emitLine(")");
        this.unindent();
    }

    private void emitHexString1(String value, int index) {
        this.emitLine();
        this.emitPartial(" && ", "key[", Integer.toString(index), "] == '", value.substring(index, index + 1), "'");
    }

    private void emitHexString2(String value, int index) {
        this.emitLine();
        this.emitPartial(" && *reinterpret_cast<const int16*>(&key[", Integer.toString(index), "]) == static_cast<int16>(");
        this.emitIndexLookupMethodHexValue(value, index, index + 2);
        this.emitPartial(" /* ", value.substring(index, index + 2), " */)");
    }

    private void emitHexString4(String value, int index) {
        this.emitLine();
        this.emitPartial(" && *reinterpret_cast<const int32*>(&key[", Integer.toString(index), "]) == static_cast<int32>(");
        this.emitIndexLookupMethodHexValue(value, index, index + 4);
        this.emitPartial(" /* ", value.substring(index, index + 4), " */)");
    }

    private void emitHexString8(String value, int index) {
        this.emitLine();
        this.emitPartial(" && *reinterpret_cast<const int64*>(&key[", Integer.toString(index), "]) == static_cast<int64>(CONST64(");
        this.emitIndexLookupMethodHexValue(value, index, index + 8);
        this.emitPartial(") /* ", value.substring(index, index + 8), " */)");
    }

    private void emitIndexLookupMethodHexValue(String value, int i, int j) {
        this.emitPartial("0x");
        for (int k = j - 1; k >= i; --k) {
            this.emitPartial(Integer.toHexString(value.charAt(k)));
        }
    }

    private void emitDataObjectTypeInfoArray(Collection<DataObject> dataObjects) {
        int doCount = dataObjects.size();
        if (doCount == 0) {
            return;
        }
        this.emitLine("static const DataTypeInfo sDataTypeInfo[] = {");
        this.indent();
        for (DataObject dobj : dataObjects) {
            this.emitDataTypeInfo(dobj);
        }
        this.unindent();
        this.emitLine("};");
    }

    private void emitDataTypeInfo(DataObject obj) {
        boolean hasOptional = false;
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            if (!decl.isOptional()) continue;
            hasOptional = true;
            break;
        }
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        VmodlObject baseObj = obj.getBaseObject();
        String basePtr = CppImplementationEmitter.formatTypePtr(baseObj);
        this.emitLine("{", CppImplementationEmitter.formatTypePtr(obj), ", ", basePtr, ", ", "s", typePrefix, "Properties, ", obj.hasProperties() ? "s" + typePrefix + "Get" : "nullptr", ", ", obj.hasProperties() ? "s" + typePrefix + "Peek" : "nullptr", ", ", obj.hasProperties() ? "s" + typePrefix + "Set" : "nullptr", ", ", obj.hasProperties() ? "s" + typePrefix + "Swap" : "nullptr", ", ", "s", typePrefix, "IsSet, ", !obj.hasProperties() || !hasOptional ? "nullptr" : "s" + typePrefix + "Unset", ", ", "s", typePrefix, "Factory, ", "s", typePrefix, "ArrayFactory, ", Boolean.toString(obj.hasDynamicProperties()), "},");
    }

    private void emitStubFactory(ManagedObject obj) {
        this.emitLine("static Stub *");
        this.emitLine("s", CppImplementationEmitter.formatPrefix(obj), "StubFactory(Vmomi::MoRef *moref, ", "Vmomi::StubAdapter *adapter, Vmomi::RequestContext *context)");
        this.emitLine("{");
        this.emitLine("   return new ", CppImplementationEmitter.getQualifiedStubName(obj), "(moref, adapter, context);");
        this.emitLine("}");
        this.emitLine();
    }

    private void emitManagedTypeInfo(ManagedObject obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        VmodlObject baseObj = obj.getBaseObject();
        String basePtr = CppImplementationEmitter.formatTypePtr(baseObj);
        this.emitLine("static const ManagedTypeInfo s" + typePrefix + "ManagedInfo = ");
        this.indent();
        this.emitLine("{", CppImplementationEmitter.formatTypePtr(obj), ", ", basePtr, ", ", "s", typePrefix, "Properties, ", "s", typePrefix, "Methods, ", obj.hasProperties() ? "s" + typePrefix + "PropertyIndexLookup" : "nullptr", ", ", "s", typePrefix, "Dispatch, ", "s", typePrefix, "StubFactory, ", CppImplementationEmitter.formatMethodObjects(obj), "};");
        this.unindent();
        this.emitLine();
    }

    private void emitEnumTypeInfo(Enum obj) {
        String typePrefix = CppImplementationEmitter.formatPrefix(obj);
        String values = "s" + typePrefix + "EnumValues";
        this.emitLine("static const char * const ", values, "[] = {");
        this.indent();
        String fullEnumType = CppImplementationEmitter.getQualifiedClassName(obj);
        int end = fullEnumType.lastIndexOf("::");
        String container = end > -1 ? fullEnumType.substring(0, end) : "";
        for (String key : obj.getValueList()) {
            String valueString = container + "::" + obj.getValueString(key);
            this.emitLine(valueString + ",");
        }
        this.emitLine("nullptr");
        this.unindent();
        this.emitLine("};");
        this.emitLine("static const EnumTypeInfo s" + typePrefix + "EnumInfo = {");
        this.indent();
        this.emitLine(CppImplementationEmitter.formatTypePtr(obj) + ", " + values);
        this.emitLine("};");
        this.unindent();
    }

    private void emitEnumConstants(Enum obj) {
        String prefix = "";
        VmodlObject container = obj.getContainer();
        if (container != null) {
            prefix = CppImplementationEmitter.getFullClassName(container) + "::";
        }
        for (String key : obj.getValueList()) {
            String valueString = obj.getValueString(key);
            this.emitLine(String.format("const char %s%s[%d] = %s;", prefix, valueString, key.length() + 1, CppImplementationEmitter.qq(key)));
        }
    }

    private void emitMethodDispatchCase(Method method, int id) {
        VmodlDecl returnDecl;
        this.emitLine("case " + id + ":");
        this.emitLine("{");
        this.indent();
        ArrayList<String> paramList = new ArrayList<String>();
        int paramId = 0;
        for (Parameter param : method.getParameterList()) {
            VmodlDecl decl = param.getDecl();
            String name = "_p" + paramId;
            this.emitLine(CppImplementationEmitter.formatDecl(CppImplementationEmitter.getDeclString(decl, false), name) + ";");
            this.emitNarrowSafe(decl, "params[" + paramId + "]", name);
            paramList.add(name);
            ++paramId;
        }
        String resultName = "_result";
        VmodlDecl vmodlDecl = returnDecl = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
        if (!returnDecl.isPrimitive() || returnDecl.isArray()) {
            this.emitLine(CppImplementationEmitter.formatDecl(CppImplementationEmitter.getDeclString(returnDecl), resultName) + ";");
            paramList.add(resultName);
        }
        String methodExpr = "_obj->" + CppImplementationEmitter.capitalize(method.getName()) + "(" + CppImplementationEmitter.join(paramList, ", ") + ")";
        if (!returnDecl.isPrimitive() || returnDecl.isArray()) {
            this.emitLine(methodExpr + ";");
            this.emitBox(returnDecl, resultName, "resultObj");
        } else if (returnDecl.isOptional() && returnDecl.isPrimitive() && !returnDecl.isArray()) {
            String typeName = CppImplementationEmitter.getDeclString(returnDecl);
            this.emitLine(CppImplementationEmitter.formatDecl(typeName, resultName) + " = " + methodExpr + ";");
            this.emitBox(returnDecl, resultName, "resultObj");
        } else {
            this.emitBox(returnDecl, methodExpr, "resultObj");
        }
        this.emitLine("break;");
        this.unindent();
        this.emitLine("}");
    }

    private String formatFlags(Property property) {
        Set<Flag> flags = this.getFlags(property.getDecl());
        if (property.isReadonly()) {
            flags.add(Flag.F_READ_ONLY);
        }
        return flags.isEmpty() ? "0" : CppImplementationEmitter.join(flags, " | ");
    }

    private String formatFlags(VmodlDecl decl) {
        Set<Flag> flags = this.getFlags(decl);
        return flags.isEmpty() ? "0" : CppImplementationEmitter.join(flags, " | ");
    }

    private Set<Flag> getFlags(VmodlDecl decl) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (decl.isLink()) {
            flags.add(Flag.F_STRING_LINK);
        }
        if (decl.isLinkable()) {
            flags.add(Flag.F_LINKABLE);
        }
        if (decl.isOptional()) {
            flags.add(Flag.F_OPTIONAL);
        }
        if (decl.isArray()) {
            flags.add(Flag.F_ARRAY);
        }
        if (decl.isList()) {
            flags.add(Flag.F_LIST);
        } else if (decl.isSet()) {
            flags.add(Flag.F_SET);
        } else if (decl.isMap()) {
            flags.add(Flag.F_MAP);
        }
        if (decl.isSecret()) {
            flags.add(Flag.F_SECRET);
        }
        if (decl.isSilent()) {
            flags.add(Flag.F_SILENT);
        }
        return flags;
    }

    private void emitDataObjectTypeMethod(DataObject dobj) {
        String fullClassName = CppImplementationEmitter.getFullClassName(dobj);
        String qualifiedClassName = CppImplementationEmitter.getQualifiedClassName(dobj);
        this.emitLine("Vmomi::Type *");
        this.emitLine(fullClassName, "::_GetType() const");
        this.emitLine("{");
        this.indent();
        this.emitLine("return Vmomi::GetDoType< ", qualifiedClassName, " >();");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        this.emitLine("Vmomi::DataObjectType *");
        this.emitLine(fullClassName, "::_GetDataType() const");
        this.emitLine("{");
        this.indent();
        this.emitLine("return Vmomi::GetDoType< ", qualifiedClassName, " >();");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitManagedObjectTypeMethod(ManagedObject mobj) {
        this.emitLine("Vmomi::ManagedObjectType *");
        this.emitLine(CppImplementationEmitter.getFullClassName(mobj), "::_GetType() const");
        this.emitLine("{");
        this.indent();
        this.emitLine("return Vmomi::GetMoType< ", CppImplementationEmitter.getQualifiedClassName(mobj), " >();");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitIsEqualMethod(DataObject obj) {
        VmodlObject baseObj;
        String className = CppImplementationEmitter.getFullClassName(obj);
        this.emitLine("bool");
        this.emitLine(className, "::_IsEqual(const Any *obj, bool looseMatch) const");
        this.emitLine("{");
        this.indent();
        if (obj.hasProperties()) {
            this.emitLine("const " + className, " *that = static_cast< const " + className + "* >(obj);");
        }
        if (!(baseObj = obj.getBaseObject()).getWsdlName().equals("DataObject") && !baseObj.getWsdlName().equals("DynamicData")) {
            String baseClassName = CppImplementationEmitter.getQualifiedClassName(baseObj);
            this.emitPartial("if (", baseClassName, "::_IsEqual(obj, looseMatch)");
        } else {
            this.emitPartial("if (true");
        }
        for (Property property : obj.getPropertyList()) {
            String memberName = CppImplementationEmitter.getMemberName(property);
            VmodlDecl decl = property.getDecl();
            this.emitLine(" &&");
            if (decl.isSingleValue()) {
                if (decl.isOptional()) {
                    this.emitPartial("   (", memberName, " == that->", memberName, " || (looseMatch && !that->", memberName, ".HasValue()))");
                    continue;
                }
                this.emitPartial("   ", memberName, " == that->", memberName);
                continue;
            }
            this.emitPartial("   AreEqualAnysInt(", memberName, ", that->", memberName + ", ", this.formatFlags(decl), ", looseMatch)");
        }
        this.emitLine(") {");
        this.indent();
        this.emitLine("return true;");
        this.unindent();
        this.emitLine("} else {");
        this.indent();
        this.emitLine("return false;");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDiffPropertiesMethod(DataObject obj) {
        VmodlObject baseObj;
        if (obj.isFault()) {
            return;
        }
        String className = CppImplementationEmitter.getFullClassName(obj);
        this.emitLine("void");
        this.emitLine(className, "::_DiffProperties(const Any *obj, const String& ppath, ", "PropertyDiffSet& diffSet) const");
        this.emitLine("{");
        this.indent();
        if (obj.hasProperties()) {
            this.emitLine("const " + className, " *that = static_cast< const ", className, "* >(obj);");
        }
        if (!(baseObj = obj.getBaseObject()).getWsdlName().equals("DataObject") && !baseObj.getWsdlName().equals("DynamicData")) {
            String baseClassName = CppImplementationEmitter.getQualifiedClassName(baseObj);
            this.emitLine(baseClassName, "::_DiffProperties(obj, ppath, diffSet);");
        }
        for (Property property : obj.getPropertyList()) {
            String memberName = CppImplementationEmitter.getMemberName(property);
            String propName = property.getName();
            VmodlDecl decl = property.getDecl();
            if (decl.isSingleValue()) {
                String methodName = "DiffPrimitiveProperties";
                this.emitLine(methodName, "(", memberName, ", that->", memberName, ", ppath, \".", propName, "\", diffSet);");
                continue;
            }
            String flags = this.formatFlags(decl);
            this.emitLine("DiffAnyPropertiesInt(", memberName, ", that->", memberName, ", ppath, \".", propName, "\", ", flags, ", diffSet);");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitDataObjectImpl(DataObject obj) {
        String className = CppImplementationEmitter.getFullClassName(obj);
        String simpleName = obj.getClassName();
        String baseClassName = CppImplementationEmitter.getQualifiedClassName(obj.getBaseObject());
        String prototype = className + "::" + simpleName + "()";
        this.emitConstructor(prototype);
        this.emitLine();
        this.emitLine(className + "::" + simpleName + "(const " + simpleName + "& rhs)");
        this.indent();
        this.emitLine(": " + baseClassName + "(static_cast<const " + baseClassName + "&>(rhs))");
        for (Property property : obj.getPropertyList()) {
            VmodlDecl decl = property.getDecl();
            String memberName = CppImplementationEmitter.getMemberName(property);
            if (decl.isSingleValue()) {
                this.emitLine(", " + memberName + "(rhs." + memberName + ")");
                continue;
            }
            this.emitLine(", " + memberName + "(rhs." + memberName + " ? rhs." + memberName + "->_Clone() : nullptr)");
        }
        this.unindent();
        this.emitLine("{");
        this.emitLine("}");
        this.emitLine();
        this.emitLine(className + "::~" + simpleName + "()");
        this.emitLine("{");
        this.emitLine("}");
        this.emitLine();
        if (this._emitDiffMethod) {
            this.emitIsEqualMethod(obj);
            this.emitDiffPropertiesMethod(obj);
        }
        if (obj.isFault()) {
            this.emitFaultMethods(obj);
            this.emitFaultException(obj);
        }
        for (Property property : obj.getPropertyList()) {
            this.emitDataMethods(obj, (DataProperty)property);
        }
    }

    private void emitConstructor(String prototype) {
        this.emitLine(prototype);
        this.emitLine("{");
        this.emitLine("}");
    }

    private void emitDataMethods(VmodlObject obj, DataProperty property) {
        VmodlDecl decl = property.getDecl();
        if (decl.isArray()) {
            String memberName = CppImplementationEmitter.getMemberName(property);
            String returnTypeName = CppImplementationEmitter.getPropertyReturnString(decl);
            String className = CppImplementationEmitter.getFullClassName(obj);
            this.emitLine(returnTypeName);
            this.emitLine(className, "::", property.getAccessor().getName(), "() {");
            this.indent();
            this.emitLine("return " + memberName + ".Get();");
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
    }

    private void emitMethodNameConstants(ManagedObject obj) {
        for (Method method : obj.getMethodList()) {
            String methodName = method.getName();
            String className = CppImplementationEmitter.getFullClassName(obj);
            this.emitLine("const char " + className + "::METHOD_" + methodName.toUpperCase() + "[] = " + CppImplementationEmitter.qq(method.getQualifiedName()) + ";");
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            if (nestedObj.getKind() != VmodlObject.Kind.ManagedObject) continue;
            this.emitMethodNameConstants((ManagedObject)nestedObj);
        }
    }

    private void emitManagedObjectStubImpl(ManagedObject obj) {
        ManagedObject base = (ManagedObject)obj.getBaseObject();
        String className = CppImplementationEmitter.getFullStubName(obj);
        String simpleName = CppImplementationEmitter.getStubName(obj);
        String baseImpl = CppImplementationEmitter.isBuiltin(base) ? "Vmomi::StubImpl" : CppImplementationEmitter.getQualifiedStubName(base);
        this.emitLine();
        this.emitLine(className + "::" + simpleName + "(Vmomi::MoRef *moref, StubAdapter *adapter, Vmomi::RequestContext *context) :");
        this.indent();
        this.emitLine(baseImpl + "(moref, adapter, context) {}");
        this.unindent();
        this.emitLine(className + "::~" + simpleName + "() {}");
        this.emitLine();
        int id = 0;
        for (Method method : obj.getMethodList()) {
            this.emitStubImpl(obj, method, id++);
        }
        for (Property property : obj.getPropertyListWithOverrides()) {
            this.emitStubImpl(obj, property.getAccessor(), id++);
        }
        for (VmodlObject nestedObj : obj.getNestedList()) {
            if (nestedObj.getKind() != VmodlObject.Kind.ManagedObject) continue;
            this.emitManagedObjectStubImpl((ManagedObject)nestedObj);
        }
    }

    private void emitStubImpl(ManagedObject mo, Method method, int id) {
        if (method.getVersion().getKind() != Version.Kind.DISABLED) {
            this.emitStubMethod(mo, method, id, false);
            if (this._emitAsyncStubMethods) {
                this.emitStubMethod(mo, method, id, true);
            }
        } else {
            this.emitDisabledStubMethod(mo, method, false);
            if (this._emitAsyncStubMethods) {
                this.emitDisabledStubMethod(mo, method, true);
            }
        }
    }

    private void emitStubMethod(ManagedObject obj, Method method, int id, boolean isAsync) {
        this.emitStubMethodHeader(obj, method, isAsync);
        this.emitLine("RefVector<Any> _params(" + method.getParameterList().size() + ");");
        int paramId = 0;
        for (Parameter param : method.getParameterList()) {
            this.emitBox(param.getDecl(), param.getName(), "_params[" + paramId++ + "]");
        }
        String methodRef = CppImplementationEmitter.formatMethodObjects(obj) + "[" + id + "]";
        if (isAsync) {
            this.emitLine("_StartInvoke_Task(" + methodRef + ", _params, func, si);");
        } else {
            VmodlDecl returnDecl;
            VmodlDecl vmodlDecl = returnDecl = method.isTask() ? Method.taskReturnDecl() : method.getReturnDecl();
            if (returnDecl.isVoid()) {
                this.emitLine("_Invoke_Task(" + methodRef + ", _params);");
            } else {
                String tmpResult = "_resultObj";
                this.emitLine("Ref<Any> _resultObj;");
                this.emitLine("_Invoke_Task(" + methodRef + ", _params, " + "_resultObj" + ");");
                if (returnDecl.isArray()) {
                    this.emitLine("if (nullptr != _resultObj) {");
                    this.indent();
                    this.emitNarrow(returnDecl, "_resultObj", "result");
                    this.unindent();
                    this.emitLine("} else {");
                    this.indent();
                    this.emitLine("result = new " + CppImplementationEmitter.getTypeString(returnDecl) + "();");
                    this.unindent();
                    this.emitLine("}");
                } else if (returnDecl.isPrimitive()) {
                    String result = "_result";
                    this.emitLine(CppImplementationEmitter.formatDecl(CppImplementationEmitter.getDeclString(returnDecl), "_result") + ";");
                    this.emitNarrowSafe(returnDecl, "_resultObj", "_result");
                    this.emitLine("return _result;");
                } else {
                    this.emitNarrow(returnDecl, "_resultObj", "result");
                }
            }
        }
        this.emitStubMethodFooter();
    }

    void emitDisabledStubMethod(ManagedObject obj, Method method, boolean isAsync) {
        this.emitStubMethodHeader(obj, method, isAsync);
        this.emitLine("NOT_REACHED();");
        this.emitStubMethodFooter();
    }

    private void emitStubMethodHeader(ManagedObject obj, Method method, boolean isAsync) {
        this.emitMethodDef(method, CppImplementationEmitter.getFullStubName(obj), isAsync);
        this.emitLine("{");
        this.indent();
    }

    private void emitStubMethodFooter() {
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    private void emitNarrow(VmodlDecl decl, String src, String dst) {
        this.emitLine(dst + " = " + this.formatNarrow(decl, src) + ";");
    }

    private void emitNarrowSafe(VmodlDecl decl, String src, String dst) {
        boolean checkOptForNull;
        boolean bl = checkOptForNull = decl.isOptional() && decl.isPrimitive() && !decl.isArray();
        if (checkOptForNull) {
            this.emitLine("if (" + src + " != nullptr) {");
            this.indent();
        }
        this.emitNarrow(decl, src, dst);
        if (checkOptForNull) {
            this.unindent();
            this.emitLine("}");
        }
    }

    private String formatNarrow(VmodlDecl decl, String val) {
        String narrowExpr = null;
        String typeName = null;
        String className = null;
        if (decl.getObject() != null) {
            className = CppImplementationEmitter.getQualifiedClassName(decl.getObject());
        }
        if (decl.isValue()) {
            typeName = decl.isEnum() ? className : (decl.isLink() ? "Vmomi::String" : CppImplementationEmitter.getTypeString(decl.getTypeId()));
            typeName = decl.isArray() ? CppImplementationEmitter.formatTemplate("Vmomi::Array", typeName) : CppImplementationEmitter.formatTemplate("Vmomi::Primitive", typeName);
            narrowExpr = CppImplementationEmitter.formatTemplate("NarrowToType", typeName) + "(" + val + ")";
            if (!decl.isArray()) {
                narrowExpr = narrowExpr + "->GetValue()";
            }
        } else {
            if (decl.isManaged()) {
                className = "Vmomi::MoRef";
            } else if (decl.isAny()) {
                className = "Vmomi::Any";
            }
            typeName = decl.isArray() ? CppImplementationEmitter.formatTemplate("Vmomi::DataArray", className) : className;
            narrowExpr = CppImplementationEmitter.formatTemplate("NarrowToType", typeName) + "(" + val + ")";
        }
        return narrowExpr;
    }

    private void emitBox(VmodlDecl decl, String expr, String var) {
        if (decl.isVoid()) {
            this.emitLine(expr + ";");
        } else if (decl.isOptional() && decl.isPrimitive() && !decl.isArray()) {
            decl = new VmodlDecl(decl.getTypeId(), decl.getObject());
            this.emitLine(var + " = " + expr + ".HasValue() ? " + this.formatBox(decl, expr) + " : nullptr;");
        } else {
            this.emitLine(var + " = " + this.formatBox(decl, expr) + ";");
        }
    }

    private void emitFaultMethods(DataObject fault) {
        String className = CppImplementationEmitter.getFullClassName(fault);
        this.emitLine();
        this.emitLine("NORETURN void");
        this.emitLine(className, "::ThrowInternal()");
        this.emitLine("{");
        this.indent();
        this.emitLine("throw ", className, "::Exception(this);");
        this.unindent();
        this.emitLine("}");
    }

    private void emitFaultException(DataObject fault) {
        this.emitLine();
        String exceptionClass = CppImplementationEmitter.getFullClassName(fault) + "::Exception::";
        this.emitLine("NORETURN void " + exceptionClass + "Throw() { throw *this; }");
        this.emitLine();
    }

    private String formatBox(VmodlDecl decl, String val) {
        if (decl.isPrimitive() && !decl.isArray()) {
            String cppType = CppImplementationEmitter.getTypeString(decl);
            return CppImplementationEmitter.formatTemplate("Vmomi::NewPrimitive", cppType) + "(" + val + ")";
        }
        return val;
    }

    private String formatTypeInit(VmodlDecl type, String name, String privId, Version version) {
        return "{" + CppImplementationEmitter.formatTypePtr(type) + ", " + this.formatFlags(type) + ", " + CppImplementationEmitter.qq(name) + ", " + (privId != null ? CppImplementationEmitter.qq(privId) : "nullptr") + ", " + CppImplementationEmitter.qq(version.getVmodlName()) + "}";
    }

    private TreeSet<String> findHeaderSet(List<VmodlObject> objects) {
        TreeSet<String> headerSet = new TreeSet<String>();
        for (VmodlObject obj : objects) {
            this.findHeaderSetInt(obj, headerSet);
        }
        return headerSet;
    }

    private void findHeaderSetInt(VmodlObject obj, TreeSet<String> headerSet) {
        String dependHeader = this.getHeaderFile(obj);
        if (headerSet.contains(dependHeader)) {
            return;
        }
        if (!CppImplementationEmitter.isBuiltin(obj)) {
            headerSet.add(dependHeader);
        }
        for (VmodlObject tobj : obj.getAllDependencies()) {
            this.findHeaderSetInt(tobj, headerSet);
        }
    }

    private void beginImplFile(String filename) {
        this.beginCppFile(this._cppDirectory + "/" + filename);
        this.emitLine("#define VMOMI_EMITTER");
        this.emitLine();
        this.emitIncludes();
        this.emitLine();
        this.emitLine("// Workaround bug 1744611.");
        this.emitLine("#if !defined VMX86_DEBUG");
        this.emitLine("#   if defined __clang__ || (defined __GNUC__ && (__GNUC__ > 4 || __GNUC__ == 4 && __GNUC_MINOR__ >= 5))");
        this.emitLine("#      undef NOT_REACHED");
        this.emitLine("#      define NOT_REACHED() (__builtin_unreachable())");
        this.emitLine("#   elif defined _MSC_VER && _MSC_VER >= 1500");
        this.emitLine("#      undef NOT_REACHED");
        this.emitLine("#      define NOT_REACHED() (__assume(0))");
        this.emitLine("#   endif");
        this.emitLine("#endif");
        this.emitLine();
        this.emitLine("using namespace Vmomi;");
        this.emitLine();
    }

    private void endImplFile() {
        this.setNamespace("");
        this.endFile();
    }

    private static enum Flag {
        F_STRING_LINK,
        F_LINKABLE,
        F_OPTIONAL,
        F_ARRAY,
        F_LIST,
        F_SET,
        F_MAP,
        F_READ_ONLY,
        F_SECRET,
        F_SILENT;

    }

    private static class AnalysisResult {
        final int index;
        final List<Pair> unique;
        final Collection<List<Pair>> multiple;

        AnalysisResult(int index, List<Pair> pairs) {
            this.index = index;
            this.unique = pairs;
            this.multiple = null;
        }

        AnalysisResult(int index, List<Pair> unique, Collection<List<Pair>> multiple) {
            this.index = index;
            this.unique = unique;
            this.multiple = multiple;
        }
    }

    static class Pair {
        final String label;
        final String value;

        Pair(String label, String value) {
            this.label = label;
            this.value = value;
        }
    }

    class GetTypeEmitter {
        private String _returnType;
        private String _methodName;
        private int _index = 0;

        GetTypeEmitter() {
        }

        void setup(String returnType, String methodName) {
            this._returnType = returnType;
            this._methodName = methodName;
        }

        void emit(VmodlObject object) {
            CppImplementationEmitter.this.emitLine(new String[]{"template<> ", CppImplementationEmitter.this._apiDecl, this._returnType});
            CppImplementationEmitter.this.emitLine(new String[]{CppEmitter.formatTemplate(this._methodName, CppEmitter.getQualifiedClassName(object)), "()"});
            CppImplementationEmitter.this.emitLine("{");
            CppImplementationEmitter.this.indent();
            CppImplementationEmitter.this.emitLine(new String[]{"ASSERT(nullptr != sTypes[", Integer.toString(this._index), "]);"});
            CppImplementationEmitter.this.emitLine(new String[]{"return static_cast<", this._returnType, ">(sTypes[", Integer.toString(this._index++), "]);"});
            CppImplementationEmitter.this.unindent();
            CppImplementationEmitter.this.emitLine("}");
            CppImplementationEmitter.this.emitLine();
        }
    }

    static class VmodlObjects {
        private final List<DataObject> _doList = new ArrayList<DataObject>();
        private final List<Enum> _enumList = new ArrayList<Enum>();
        private final List<ManagedObject> _moList = new ArrayList<ManagedObject>();
        private final int _numTypes;

        VmodlObjects(Iterable<VmodlObject> objects) {
            for (VmodlObject obj : objects) {
                this.findObjects(obj);
            }
            this._numTypes = this._doList.size() + this._enumList.size() + this._moList.size();
        }

        Collection<DataObject> getDataObjects() {
            return this._doList;
        }

        Iterable<Enum> getEnums() {
            return this._enumList;
        }

        Collection<ManagedObject> getManagedObjects() {
            return this._moList;
        }

        int getNumTypes() {
            return this._numTypes;
        }

        private void findObjects(VmodlObject obj) {
            if (CppImplementationEmitter.isBuiltin(obj)) {
                return;
            }
            obj.setupEnabledLists();
            switch (obj.getKind()) {
                case DataObject: {
                    this._doList.add((DataObject)obj);
                    break;
                }
                case Enum: {
                    this._enumList.add((Enum)obj);
                    break;
                }
                case ManagedObject: {
                    this._moList.add((ManagedObject)obj);
                    break;
                }
            }
            for (VmodlObject nestedObj : obj.getNestedList()) {
                this.findObjects(nestedObj);
            }
        }
    }
}

